
  --PREISE
  CREATE TABLE Preise (                   --Sollte eigentlich TWawi.Preise sein, DB analysieren (Funktion für Dbrid etc.) kann allerdings nicht mit Schemata umgehen (09-2013)
    id             serial PRIMARY KEY,
    target_table   varchar(50),
    target_dbrid   varchar(32),
    preis          TWawi.Preis
  );

  -- Indizes
    CREATE INDEX preise_target_table ON preise (target_table);
    CREATE INDEX preise_target_dbrid ON preise (target_dbrid);

--Rückgabe des Standardkurznamen für abweichende Lieferadresse
CREATE OR REPLACE FUNCTION TAdk.get_vorg_ladress(IN _adkrz varchar) RETURNS varchar AS $$
    DECLARE _s varchar;
    BEGIN
        _s := ada_krzl FROM adk_adresses WHERE ada_ad_krz = _adkrz AND ada_ladress AND ada_vorgabe;
        RETURN coalesce(_s, _adkrz);
    END $$ LANGUAGE plpgsql STABLE;
--

--Rückgabe des Standardkurznamen für abweichende Rechnungsadresse
CREATE OR REPLACE FUNCTION TAdk.get_vorg_radress(IN _adkrz varchar) RETURNS varchar AS $$
    DECLARE _s varchar;
    BEGIN
        _s := ada_krzl FROM adk_adresses WHERE ada_ad_krz = _adkrz AND ada_radress AND ada_vorgabe;
        RETURN coalesce(_s, _adkrz);
    END $$ LANGUAGE plpgsql STABLE;
--

-- Bestelldokument - Externbestellung
CREATE TABLE ldsdokdokutxt(
   ltd_dokunr           integer PRIMARY KEY,
   ltd_titel            varchar(40),       -- Belegtitel, überschreibt Vorgaben (Bestellung, Auswärtsvergabe etc...)
   ltd_datum             date DEFAULT current_date,
   ltd_txt              text,
   ltd_txt_rtf          text,
   ltd_txt1             text,
   ltd_txt1_rtf         text,
   ltd_versandort       varchar(30) REFERENCES adressen_keys ON UPDATE CASCADE,
   ltd_gesrab           numeric DEFAULT 0, --Gesamtrabatt für Bestellungen eines Einkaufsdokumentes
   ltd_apkrzl           varchar(10),
   ltd_ap               varchar(100),      -- Freies Textfeld für Ansprechpartner
   ltd_zak              integer,           -- Zahlungsziel (in Tagen)
   ltd_skv              integer,           -- Skonto verfällt nach X Tagen
   ltd_sks              numeric(5,2),      -- Skontosatz
   ltd_vers             varchar(75),       -- Versandart
   ltd_versandbem       text,              -- Bemerkung zum Versand
   ltd_versandbem_rtf   text,
   ltd_abbisdat         date,              --Auftragsbestätigung bis dahin
   ltd_allg1            varchar(40),--Lieferzeitraum
   ltd_allg2            varchar(100), --Freies Textfeld, Ansprechpartner intern, Fachberater
   ltd_zakbem           varchar(40), --Zahlungskond. Bemerkung
   ltd_apint            varchar(10), -- Ansprechpartner Intern...Standard aus erster Position Bestellung, sonst current_user => ldsdok__a_iu() -- REFERENCES llv(ll_db_usename) ON UPDATE CASCADE siehe X TableContraints
   ltd_apint2           varchar(50),
   ltd_mahndat          date,           --Datum der Terminmahnung
   ltd_mahnstufe        smallint,       --Stufe der Mahnung
   ltd_mahntxt          text,           --Anschreiben Terminmahnung
   ltd_mahntxt_rtf      text,
   ltd_mahntxt1         text,           --Schlusstext Terminmahnung
   ltd_mahntxt1_rtf     text,
   ltd_defini           boolean DEFAULT FALSE
   /*,
   -- System (tables__generate_missing_fields)
   dbrid                varchar(32) NOT NULL DEFAULT nextval('db_id_seq'),
   insert_date          date,
   insert_by            varchar(32),
   modified_by          varchar(32),
   modified_date        timestamp(0)
   */
 );

 -- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
 CREATE TRIGGER ldsdokdokutxt_set_modified
  BEFORE INSERT OR UPDATE
  ON ldsdokdokutxt
  FOR EACH ROW
  EXECUTE PROCEDURE table_modified();


 -- Standard Dokumenttexte, Zahlungskonditionen und Versandarten
 CREATE OR REPLACE FUNCTION ldsdokdokutxt__b_10_i() RETURNS TRIGGER AS $$
  DECLARE codstat         varchar;
          krz             varchar;
          vertragtxtrec   record;
          AbFrist         integer;
          awldsdok        boolean;
          bemident        varchar;
          rhlnr           varchar;
          _zak            integer;
          _skv            integer;
          _sks            numeric;
          _zakbem         varchar;
          _vers           varchar;
          _versandbem     text;
          _versandbem_rtf text;
  BEGIN
    -- Standard Vertragskopftexte
    IF EXISTS(SELECT TRUE FROM ldsdok WHERE ld_dokunr = new.ltd_dokunr AND ld_vtp_id IS NOT NULL) THEN
      SELECT DISTINCT COALESCE(vtr_bez, vtr_gegenstand) AS vtr_bez, vtr_dokutxt_anf, vtr_dokutxt_anf_rtf, vtr_dokutxt_end, vtr_dokutxt_end_rtf
        INTO vertragtxtrec
        FROM ldsdok
        JOIN vertrag_pos ON vtp_id = ld_vtp_id
        JOIN vertrag ON vtr_nr = vtp_vtr_nr
        WHERE ld_dokunr = new.ltd_dokunr;

      new.ltd_titel    = vertragtxtrec.vtr_bez;
      new.ltd_txt      = vertragtxtrec.vtr_dokutxt_anf;
      new.ltd_txt_rtf  = vertragtxtrec.vtr_dokutxt_anf_rtf;
      new.ltd_txt1     = vertragtxtrec.vtr_dokutxt_end;
      new.ltd_txt1_rtf = vertragtxtrec.vtr_dokutxt_end_rtf;

    END IF;

    -- Standard-Frist für AB, per Systemeinstellung Einkauf. Nur wenn nichts eingetragen ist.
    AbFrist:=NullIf(TSystem.Settings__GetNumeric('EKFristAbBisDat'),0)::INTEGER;
    IF new.ltd_abbisdat IS NULL AND abFrist IS NOT NULL THEN
      new.ltd_abbisdat:=current_date+abfrist;
    END IF;

    -- Befinden sich auf dem Dokument Rahmenabrufe?
    SELECT ld_rhl_nr INTO rhlnr FROM ldsdok WHERE ld_dokunr = new.ltd_dokunr;
    -- Bei Rahmenabrufen, das Dokument der Rahmenbestellung raussuchen und Zahlungskonditionen / Versandarten übernehmen
    IF rhlnr IS NOT NULL THEN
      SELECT ltd_zak, ltd_skv, ltd_sks, ltd_zakbem, ltd_vers, ltd_versandbem, ltd_versandbem_rtf
           INTO _zak,    _skv,    _sks,    _zakbem,    _vers,    _versandbem,    _versandbem_rtf
        FROM rahmenlieferant
           JOIN ldsdok ON ( (ld_code ='R') OR (ld_code = 'E')) AND ((ld_auftg||'/'||ld_pos) = rhl_nr)
           JOIN ldsdokdokutxt ON ld_dokunr = ltd_dokunr
        WHERE rhl_nr = rhlnr;
    END IF;

    -- Zahlungskonditionen aus Angebot, vorhandenen Wert, Rahmenvertragsdokument oder Kreditorendaten
    SELECT coalesce(aLief_zak, new.ltd_zak, _zak, a2_zak),
           coalesce(aLief_skv, new.ltd_skv, _skv, a2_skv),
           coalesce(aLief_sks, new.ltd_sks, _sks, a2_sks),
           coalesce(aLief_zakbem, new.ltd_zakbem, _zakbem, NULL ),
           coalesce(aLief_vers, new.ltd_vers, _vers, a2_vers  ),
           coalesce(aLief_versandbem, new.ltd_versandbem, _versandbem, NULL),
           coalesce(aLief_versandbem_rtf, new.ltd_versandbem_rtf, _versandbem_rtf, NULL)
      INTO _zak, _skv, _sks, _zakbem, _vers, _versandbem, _versandbem_rtf
      FROM adk2
      JOIN ldsdok          ON ld_dokunr = new.ltd_dokunr
      LEFT JOIN anfangebot ON aAng_id = ld_aAng_id
      LEFT JOIN anflief    ON aLief_id = aAng_aLief_id
      WHERE ld_kn = a2_krz LIMIT 1;

    -- Standard-Zahlungskonditionen laut Systemvorgabe holen, für die Felder, die immer noch nicht gefüllt sind
    SELECT coalesce(_zak, std.zak),
           coalesce(_skv, std.skv),
           coalesce(_sks, std.sks), _zakbem,
           coalesce(_vers, std.vers), _versandbem, _versandbem_rtf
      INTO new.ltd_zak, new.ltd_skv, new.ltd_sks, new.ltd_zakbem, new.ltd_vers, new.ltd_versandbem, new.ltd_versandbem_rtf
      FROM TAdk.StandardZak('E') AS std;

    -- Standard Texte Bemerkungsverwaltung
    SELECT ld_code, ld_kn,
        ld_a2_id IS NOT NULL   -- ist Auswärtsauftrag
      INTO codstat, krz, awldsdok
      FROM ldsdok
      WHERE ld_dokunr=new.ltd_dokunr
      LIMIT 1;
    awldsdok:=coalesce(awldsdok, False);

    IF new.ltd_txt IS NULL THEN  -- Kopf
      IF awldsdok THEN bemident:='DOKAUSW_TXT_KOPF'; -- Vorgabetext für Auswärtsauftrag
      ELSE             bemident:='DOKEINK_TXT_KOPF_'||IFTHEN(codstat='R','RBE', 'BE'); -- Vorgabetext für Einkauf
      END IF;
      SELECT txt, txtrtf INTO new.ltd_txt,  new.ltd_txt_rtf  FROM belarzu__zu_tit__gettxtrtf(bemident, prodat_languages.adk2_spco(krz));
    END IF;
    IF new.ltd_txt1 IS NULL THEN -- Fuß
      IF awldsdok THEN bemident:='DOKAUSW_TXT_FUSS'; -- Vorgabetext für Auswärtsauftrag
      ELSE             bemident:='DOKEINK_TXT_FUSS_'||IFTHEN(codstat='R','RBE', 'BE'); -- Vorgabetext für Einkauf
      END IF;
      SELECT txt, txtrtf INTO new.ltd_txt1, new.ltd_txt1_rtf FROM belarzu__zu_tit__gettxtrtf(bemident, prodat_languages.adk2_spco(krz));
    END IF;
    --
    RETURN new;
  END$$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdokdokutxt__b_10_i
    BEFORE INSERT
    ON ldsdokdokutxt
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdokdokutxt__b_10_i();
 --

 --
  CREATE OR REPLACE FUNCTION ldsdokdokutxt__b_20_i__versandort() RETURNS TRIGGER AS $$
    DECLARE
        _krzl varchar;
    BEGIN

      -- Gefahrenübergangsort #7990, #12892
      _krzl := TAdk.DokVersandOrt( 'E', new.ltd_dokunr, new.ltd_vers );

      -- Bedingungen werden in TAdk.DokVersandOrt geprüft: NULL -> Bedinungen nicht erfüllt
      IF _krzl IS NOT NULL THEN
          new.ltd_versandort := _krzl;
      END IF;

      RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER ldsdokdokutxt__b_20_i__versandort
      BEFORE INSERT
      ON ldsdokdokutxt
      FOR EACH ROW
      WHEN (
              TSystem.Settings__GetBool( 'chkDokVersandOrt', true ) -- default true
          AND new.ltd_vers IS NOT null
      )
      EXECUTE PROCEDURE ldsdokdokutxt__b_20_i__versandort();
 --

 --
 CREATE OR REPLACE FUNCTION ldsdokdokutxt__a_12_iu() RETURNS TRIGGER AS $$
  DECLARE updategesrab boolean;
  BEGIN
    --
    updategesrab:=False;
    IF tg_op = 'INSERT' AND coalesce(new.ltd_gesrab,0)>0 THEN
       updategesrab := True;
    END IF;
    IF tg_op = 'UPDATE' THEN
        IF NOT Equals(new.ltd_gesrab, old.ltd_gesrab) THEN
           updategesrab := True;
        END IF;
    END IF;
    --
    IF updategesrab THEN
        --PERFORM disableauftgtrigger();
        --die Auftragsposition hält selbst ihre Werte, daher muß das auch neu berechnet werden wenn Gesamtrabatt!
        UPDATE ldsdok
           SET ld_netto = null, ld_brutto = null, ld_netto_basis_w = null, ld_brutto_basis_w = null
          FROM ldsdokdokutxt
         WHERE ltd_dokunr = new.ltd_dokunr
           AND ld_dokunr = new.ltd_dokunr;
        --PERFORM enableauftgtrigger();
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdokdokutxt__a_12_iu
    AFTER INSERT OR UPDATE
    ON ldsdokdokutxt
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdokdokutxt__a_12_iu();
 --

--Kopfdaten zur Gesamtbestellung und Zusatzinformationen
CREATE TABLE ldsdoktxt
 (ldt_code              VARCHAR(1) NOT NULL,    -- Externer/Interner Einkauf usw...
  ldt_auftg             VARCHAR(30) NOT NULL,   -- Bestellung für Auftrag
  ldt_txt               TEXT--,                 -- Zusatzinformationen für Bestellung
  --ldt_rhl_nr          VARCHAR(40) --REFERENCES rahmenlieferant
 );

 CREATE UNIQUE INDEX ldsdoktxt_nr ON ldsdoktxt(ldt_code, ldt_auftg);
 CREATE INDEX ldsdoktxt_ldt_auftg_like ON ldsdoktxt(ldt_auftg varchar_pattern_ops);

 --
 CREATE OR REPLACE FUNCTION ldsdoktxt__b_i() RETURNS TRIGGER AS $$
  BEGIN
    --Bei doppeltem Insert auf eine Bestellung verwerfen (Kann im alten Prodat passieren)
    IF NOT EXISTS(SELECT true FROM ldsdoktxt WHERE ldt_code=new.ldt_code AND ldt_auftg=new.ldt_auftg) THEN
        RETURN new;
    ELSE
        RETURN NULL;
    END IF;
    --
 END$$LANGUAGE plpgsql;
 --
 CREATE TRIGGER ldsdoktxt__b_i
  BEFORE INSERT
  ON ldsdoktxt
  FOR EACH ROW
  EXECUTE PROCEDURE ldsdoktxt__b_i();

 CREATE TABLE ldsdokbs
  (ls_bstat             varchar(2) PRIMARY KEY,
   ls_bez               varchar(100)
  );
--

-- Fertigungsauftrag (Interne Bestellung) und Bestellung beim Lieferanten/Auswärtslieferanten (Externe Bestellung)
CREATE TABLE ldsdok
 ( ld_id                SERIAL PRIMARY KEY,
   ld_code              VARCHAR(1) NOT NULL,
   ld_auftg             VARCHAR(30) NOT NULL CONSTRAINT xtt16540__ld_auftg CHECK (strpos(ld_auftg, '%') = 0), --BestellNr
   ld_pos               SMALLINT NOT NULL,
   ld_hpos              SMALLINT,                               -- REFERENCES ldsdok (ld_pos). ACHTUNG AKTUELL NUR BEI Demontage in Verwendung!!!!!!
   ld_stat              VARCHAR(40),                            -- Interne Statusflags (kommasepariert, analog RecnoEnum)
   ld_rhl_nr            VARCHAR(30), --REFERENCES rahmenlieferant
   ld_kn                VARCHAR(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,
   ld_krzl              VARCHAR(30) NOT NULL DEFAULT TAdk.get_vorg_ladress('#') REFERENCES adressen_keys ON UPDATE CASCADE,
   ld_krzf              VARCHAR(30) NOT NULL DEFAULT TAdk.get_vorg_radress('#') REFERENCES adressen_keys ON UPDATE CASCADE,
   ld_aknr              VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE,
   ld_aknr_idx          VARCHAR(40),                            -- Zeichnungsindex, vgl. art.ak_idx
   ld_akbz              VARCHAR(100),
   ld_stk               NUMERIC(14,6) NOT NULL,                 -- Menge bestellt
   ld_stk_uf1           NUMERIC(20,8),                          -- Menge bestellt in Grundmengeneinheit
   ld_stk_soll          NUMERIC(14,6),                          -- Menge Soll der aufgelegten Menge (13 aufgelegt, 10 Soll => 3 geplanter Ausschuß/Überschuß)
   ld_stk_soll_uf1      NUMERIC(20,8),
   ld_stkl              NUMERIC(20,8) NOT NULL DEFAULT 0,       -- Menge geliefert in Grundmengeneinheit
   ld_stkf              NUMERIC(20,8) NOT NULL DEFAULT 0,       -- Menge die in Eingangsrechnung übernommen wurde (In Grundmengeneinheit)
   ld_mce               INTEGER NOT NULL CONSTRAINT xtt4064 REFERENCES artmgc,
   ld_nbedarf           BOOLEAN NOT NULL DEFAULT FALSE, --Nicht Bedarfswirksam (Bestellung darf nicht in Verfügbarkeits und Bestandsberechnung eingehen, "freie" Bestellung)
   ld_sperr             BOOLEAN NOT NULL DEFAULT FALSE,                                          --Sperrstatus #9197
   ld_term              DATE,                                   -- Liefertermin
   ld_termweek          VARCHAR(7),                             -- Liefer-Terminwoche
   ld_terml             DATE,                                   -- Liefertermin (bestätigt)
   ld_termweekl         VARCHAR(7),                             -- Liefer-Terminwoche (bestätigt)
   ld_termv             DATE,                                   -- Liefertermin Bestellung, verschoben
   ld_datum             DATE DEFAULT current_date,              -- Bestelldatum
   ld_arab              NUMERIC NOT NULL DEFAULT 0,             -- Positionsrabatt
   ld_abnr              VARCHAR(50),                            -- Auftragsbestätigungsnummer
   ld_an_nr             VARCHAR(50) REFERENCES anl,             -- Projektnummer
   ld_abdat             DATE,
   ld_bem               VARCHAR(50),                            -- Artikelreferenz
   ld_preis             NUMERIC(12,4)  NOT NULL DEFAULT 0,      -- Preis unter Berücksichtung der Preiseinheit, Bsp: 4,99 pro 100 ld_ekp_mce.
   ld_preiseinheit      NUMERIC(12,4)  NOT NULL DEFAULT 1 CONSTRAINT ldsdok__chk__preiseinheit CHECK ( ld_preiseinheit > 0),      -- Menge, auf die sich die Preisangabe bezieht, Bsp: je 100 ld_ekp_mce
   ld_ep                NUMERIC(20,8) NOT NULL,                -- Preis pro Mengeneinheit. Bsp: 0,0499
   ld_ep_basis_w        NUMERIC(20,8),
   ld_ep_uf1            NUMERIC(20,8),
   ld_ep_uf1_basis_w    NUMERIC(20,8),
   ld_ekp_mce           INTEGER REFERENCES artmgc,   -- #7326 Einkaufs - Preismengeneinheit
   ld_kurs              NUMERIC(12,4) NOT NULL,
   ld_steucode          INTEGER REFERENCES steutxt,
   ld_steuproz          NUMERIC(5,2) NOT NULL DEFAULT 0,
   --
   ld_ep_netto          NUMERIC(12,4),          -- Einzelpreis ohne Abzuschläge inkl. Rabatte
   ld_netto             NUMERIC(16,4),              -- Positionswert inkl. AbZuschläge
   ld_brutto            NUMERIC(16,4),          -- Positionswert inkl. AbZuschläge,Steuern
   ld_netto_basis_w     NUMERIC(20,8),          -- Positionswert inkl. AbZuschläge in Basiswährung
   ld_brutto_basis_w    NUMERIC(20,8),          -- Positionswert inkl. AbZuschläge,Steuern in Basiswährung
   --
   ld_eklos             NUMERIC(12,4),          -- Welche Mengeneinheit? Vermutlich Positions-ME?
   ld_ekref             VARCHAR(50),
   ld_waer              VARCHAR(3) NOT NULL DEFAULT TSystem.Settings__Get('BASIS_W') /*CONSTRAINT xtt4056*/ REFERENCES bewa,
   ld_ag_id             INTEGER CONSTRAINT xtt5110 REFERENCES auftg,    -- Bedarf (Auftg I)
   ld_a2_id             INTEGER, --REFERENCES ab2,                      -- Auswärtsarbeitsgang für den bestellt wurde.
   ld_dokunr            INTEGER,
   ld_txt               TEXT,                                   -- Zusatztext zur Bestellposition (wird angedruckt)
   ld_txt_rtf           TEXT,
   ld_txtint            TEXT,                                   -- Zusatztext zur Bestellposition (wird NICHT angedruckt)
   ld_txtint_rtf        TEXT,
   ld_done              BOOL NOT NULL DEFAULT FALSE,
   ld_storno            BOOL NOT NULL DEFAULT FALSE,
   ld_o6_dimi           VARCHAR(50),
   ld_o6_stkz           INTEGER,        --Stück  Zuschnitt
   ld_o6_lz             NUMERIC(12,4),  --Länge  Zuschnitt
   ld_o6_bz             NUMERIC(12,4),  --Breite Zuschnitt
   ld_o6_hz             NUMERIC(12,4),  --Höhe   Zuschnitt
   ld_o6_zme            INTEGER     REFERENCES mgcode,  --ZuschnittME
    --ld_o6_zz          --ohne Zugabe, da Lieferant das selbst errechnen muß und ich nur Nettowerte angebe
   ld_rech_eing         BOOL DEFAULT FALSE,
   ld_interncreate      BOOL DEFAULT FALSE,
   ld_abk               INTEGER, --derzeit kein referenzes, da zum Teil mit abk "-1" gearbeitet wird, zB Robotfertigung EDI
   ld_planabk           INTEGER, --PlanABK, welche manuell zugewiesen wird. Siehe Funktion "abk_planauftg__compare;abk_planauftg__getPlanABK" #7594
   ld_folgeap_op_ix     INTEGER, --#8618 - Bestellung Kaufteil mit automatischer ABK beim Lagerzugang (Kontrolle, Nacharbeit, usw.) - z.B. Platte kaufen aber Loch selbst bohren
   ld_nident            VARCHAR(50) REFERENCES qsnorm,
   ld_post1             VARCHAR(50),                            -- Kundenspezifische Textfelder (analog Auftg)
   ld_post2             VARCHAR(50),
   ld_post3             VARCHAR(50),
   ld_post4             VARCHAR(50),
   ld_post5             VARCHAR(50),
   ld_post6             VARCHAR(50),
   ld_post7             VARCHAR(50),
   ld_bstat             VARCHAR(2)  REFERENCES ldsdokbs ON UPDATE CASCADE ON DELETE SET NULL,
   ld_bstat1            VARCHAR(2)  REFERENCES ldsdokbs ON UPDATE CASCADE ON DELETE SET NULL,
   ld_bstat2            VARCHAR(2)  REFERENCES ldsdokbs ON UPDATE CASCADE ON DELETE SET NULL,
   ld_lkontaktkrzl      VARCHAR(10),
   ld_lkontakt          VARCHAR(50),                            -- Ansprechpartner Lieferant (analog Auftg)
   ld_kontakt           VARCHAR(30) DEFAULT tsystem.current_user_ll_db_usename(),       -- Zuständiger Mitarbeiter (analog Auftg)
   ld_ks                VARCHAR(9)  REFERENCES ksv ON UPDATE CASCADE ON DELETE SET NULL, -- Wenn Einkauf für eine bestimmte Kostenstelle erfolgt
   ld_konto             VARCHAR(25), --  REFERENCES erloes ON UPDATE CASCADE ON DELETE SET NULL,
   ld_vtp_id            INTEGER,                -- REFERENCES in X_TableConstraints      -- VertragsID
   ld_banfnr            VARCHAR(50),            -- Nr. der Bestellanforderung, die Einkauf zugrund liegt
   ld_anfnr             VARCHAR(30),            -- Nr. der Anfrage, die Einkauf zugrund liegt
   ld_aAng_id           INTEGER, --REFERENCES anfangebot     -- wird in X_TableConstraints erstellt
   ld_q_nr              INTEGER,                -- REFERENCES qab, -- wird in X_TableConstraints erstellt, enthält den QAB, für den dieser Auftrag ggf. als Nacharbeitsauftrag erstellt wurde
   ld_lagzu_txt         TEXT,                   -- Zusatztext, der beim Lagerzugang des Artikels als Hinweis angezeigt werden soll
   ld_lagzu_txt_rtf     TEXT,
   ld_ltadatum          DATE,                 --Datum der Lieferterminabfrage #3840
   ld_ltauser           VARCHAR(50),    -- Mitarbeiter, der LTA versendet #3840
   ld_ltastatus         BOOL DEFAULT FALSE,      -- Status der LTA erledigt #3840
   CONSTRAINT ld_rahmennr_valid CHECK ((ld_code = 'R' AND ld_pos <> 0) OR ld_code <> 'R'), -- Rahmen entweder mit E und Pos 0 oder R und Pos<>0, sonst Überschneidung in rahmenlieferant
   CONSTRAINT ld_hpos_valid CHECK(ld_hpos IS DISTINCT FROM ld_pos) -- Übergeordnete Position (Hauptpos), diese Position ist deren Unterposition. Constraint="Position kann keine untergeordnete Position von sich selbst sein."
  );

 --
 CREATE TRIGGER ldsdok_delete_abk_project_structure AFTER DELETE ON ldsdok FOR EACH ROW EXECUTE PROCEDURE table_delete_abkstru();
 --Indexdefinitionen
  CREATE UNIQUE INDEX xtt5108     ON ldsdok(ld_code, ld_auftg, ld_pos);

  CREATE INDEX ldsdok_ld_auftg    ON ldsdok(ld_auftg varchar_pattern_ops);

  CREATE INDEX ldsdok_ld_aknr     ON ldsdok(ld_aknr varchar_pattern_ops);

  CREATE INDEX ldsdok_ld_kn       ON ldsdok(ld_kn varchar_pattern_ops);
  CREATE INDEX ldsdok_ld_krzl     ON ldsdok(ld_krzl varchar_pattern_ops);
  CREATE INDEX ldsdok_ld_krzf     ON ldsdok(ld_krzf varchar_pattern_ops);

  CREATE INDEX ldsdok_is_done     ON ldsdok(ld_id) WHERE ld_done;
  CREATE INDEX ldsdok_isnt_done   ON ldsdok(ld_id) WHERE NOT ld_done;

  CREATE INDEX ldsdok_ld_an_nr    ON ldsdok(ld_an_nr varchar_pattern_ops) WHERE ld_rhl_nr IS NOT NULL;
  CREATE INDEX ldsdok_ld_ekref_upper ON ldsdok(AEOEUE_UPPER(ld_ekref) varchar_pattern_ops) WHERE AEOEUE_UPPER(ld_ekref) IS NOT NULL;
  CREATE INDEX ldsdok_ld_q_nr     ON ldsdok(ld_q_nr) WHERE ld_q_nr IS NOT NULL;
  CREATE INDEX ldsdok_ld_q_nr_text ON ldsdok(CAST(ld_q_nr AS TEXT) varchar_pattern_ops) WHERE CAST(ld_q_nr AS TEXT) IS NOT NULL;

  CREATE INDEX ldsdok_ld_datum    ON ldsdok(ld_datum);

  CREATE INDEX ldsdok_ld_datum_yearmonth ON ldsdok(date_to_yearmonth(ld_datum));
  CREATE INDEX ldsdok_ld_kl_datum ON ldsdok(COALESCE(ld_terml, ld_term));
  CREATE INDEX ldsdok_ld_kl_termweek ON ldsdok(COALESCE(ld_termweek, ld_termweekl));
  CREATE INDEX ldsdok_ld_termweek_date_bedarfindex ON ldsdok(COALESCE(ld_terml, ld_term, termweek_to_date(COALESCE(ld_termweek, ld_termweekl))));

  CREATE INDEX ldsdok_dokunr      ON ldsdok(ld_dokunr) WHERE ld_dokunr IS NOT NULL;
  CREATE INDEX ldsdok_dokunr_text ON ldsdok(CAST(ld_dokunr AS TEXT) varchar_pattern_ops) WHERE CAST(ld_dokunr AS TEXT) IS NOT NULL;
  CREATE INDEX ldsdok_ld_abk      ON ldsdok(ld_abk) /*INCLUDE ( ld_id, ld_ag_id )*/ WHERE ld_abk IS NOT NULL;
  CREATE INDEX ldsdok_ld_abk_text ON ldsdok(CAST(ld_abk AS TEXT) varchar_pattern_ops) WHERE CAST(ld_abk AS TEXT) IS NOT NULL;
  CREATE UNIQUE INDEX ldsdok__ld_abk__unique ON ldsdok (ld_abk) WHERE ld_abk IS NOT null AND NOT ld_done; -- doppelte ABK unzulässig. Nach wie vor etwas unklar: https://redmine.prodat-sql.de/issues/19121. NOT ld_done nur, um das überhaupt erstmal einfach so bei Systemen einzuspielen und nicht noch historische Fehler aufzuräumen
  CREATE INDEX ldsdok_ld_a2_id    ON ldsdok(ld_a2_id) WHERE ld_a2_id IS NOT NULL;
  CREATE INDEX ldsdok_ld_ag_id    ON ldsdok(ld_ag_id) WHERE ld_ag_id IS NOT NULL;
  CREATE INDEX ldsdok_ld_rhl_nr   ON ldsdok(ld_rhl_nr varchar_pattern_ops) WHERE ld_rhl_nr IS NOT NULL;

  ALTER TABLE ldsdok
    ADD CONSTRAINT ldsdok__hpos_subpos_exists_cant_delete
      FOREIGN KEY (ld_code, ld_auftg, ld_hpos)
      REFERENCES ldsdok(ld_code, ld_auftg, ld_pos)
    ON UPDATE CASCADE;

  ALTER TABLE public.ldsdok ADD  CONSTRAINT ldsdok_ld_code__E_I_R check( ld_code in( 'E', 'I', 'R' ) );

  -- CREATE SEQUENCE ldsdok_ld_dokunr_seq; => Ausgelagert in Predefines mit Startwert
 --

 --KeyWordSearch
 CREATE OR REPLACE FUNCTION ldsdok__a_iu_keywordsearch() RETURNS TRIGGER AS $$
  BEGIN
   PERFORM TSystem.kws_create_keywords(new.*);
   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_iu_keywordsearch
   AFTER INSERT OR UPDATE
    OF ld_auftg, ld_an_nr, ld_bem, ld_akbz, ld_ekref, ld_abk, ld_dokunr
   ON ldsdok
   FOR EACH ROW
   --WHEN (new.ld_code IN ('E', 'R'))
   EXECUTE PROCEDURE ldsdok__a_iu_keywordsearch();
 /*Kontiertung, Kurs und Kostenstelle zuweisen*/
 CREATE OR REPLACE FUNCTION ldsdok__b_10_i() RETURNS TRIGGER AS $$
  DECLARE etxt TEXT;
  BEGIN
    IF (new.ld_pos IS NULL) THEN
        IF new.ld_interncreate THEN --wir halten die Positionsnummern so, das diese innerhalb einer Baugruppe eineindeutig bleiben. Daher muß wegen der Notation mit "-10" der PA-Numemr der Unterbauteile hier ein Rückfalll auf die Haupt-PA Nummer stattfinden
            new.ld_pos:=NUMERIC_LARGER(TWaWi.ldsdok__ld_pos__next(new.ld_code, new.ld_auftg), TWaWi.ldsdok__ld_pos__next('I', ld_auftg)) FROM auftg, ldsdok WHERE ag_id=new.ld_ag_id AND ld_abk=tabk.abk_main_abk(ag_parentabk);
        END IF;
        IF new.ld_pos IS NULL THEN --LOLL:Keileverschachtelung bzw. keine ABK aber dennoch interner PA
            new.ld_pos:=TWaWi.ldsdok__ld_pos__next(new.ld_code, new.ld_auftg);
        END IF;
    END IF;
    --

    IF new.ld_rhl_nr IS NOT NULL THEN -- Ansprechpartner des Lieferanten übernehmen, wenn noch keiner angegeben ist
        SELECT COALESCE(new.ld_lkontaktkrzl,ld_lkontaktkrzl), COALESCE(new.ld_lkontakt, ld_lkontakt) INTO new.ld_lkontaktkrzl, new.ld_lkontakt
        FROM ldsdok
        WHERE ( (ld_code='R' AND ld_auftg||'/'||ld_pos=new.ld_rhl_nr) OR (ld_code='E' AND ld_auftg = new.ld_auftg AND ld_pos = 0));
    END IF;
    --
    IF new.ld_code <> 'I' THEN

        eTxt :=       ezt_info
                 FROM eprzutxt
                WHERE ezt_aknr = new.ld_aknr
                  AND ezt_lkn = new.ld_kn
                      -- Flag, das Text auch auf Bestellung sein soll und nicht nur interner Hinweis zu dem Lieferanten
                  AND ezt_bestxt
        ;

        IF nullif(eTxt,'') IS NOT NULL THEN
           new.ld_txt  :=    coalesce(new.ld_txt, '')
                          || ifthen( nullif(new.ld_txt, '') IS NOT NULL,
                                     E'\n' || etxt,
                                     etxt
                                    );
           new.ld_txt_rtf := new.ld_txt; -- Formatierung geht verloren. Kann aber keine RTFs mergen.
        END IF;
    END IF;
    --
    IF new.ld_code='E' AND new.ld_konto IS NULL AND TSystem.Settings__GetBool('lds_konto_required') THEN
        RAISE EXCEPTION 'null value in not-null "ld_konto"';
    END IF;
    IF new.ld_code='E' AND new.ld_ks IS NULL AND TSystem.Settings__GetBool('lds_ks_required') THEN
        RAISE EXCEPTION 'null value in not-null "ld_ks"';
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdok__b_10_i
   BEFORE INSERT
   ON ldsdok
   FOR EACH ROW
   EXECUTE PROCEDURE ldsdok__b_10_i();
 --
 CREATE OR REPLACE FUNCTION ldsdok__b_01_iu() RETURNS TRIGGER AS $$
   BEGIN
      -- Vorprüfungen und Defaults zuerst, da die Werte weiter unten ggf. schon verwendet werden.
      new.ld_code         := UPPER(new.ld_code);
      new.ld_auftg        := UPPER(new.ld_auftg);
      new.ld_preis        := COALESCE(new.ld_preis, 0);
      new.ld_preiseinheit := COALESCE(new.ld_preiseinheit, 1);

      IF NOT  new.ld_done
         AND  (   ( (TG_OP = 'INSERT') AND (new.ld_kurs IS null) ) -- kein Kurs durch Oberfläche angegeben. Kurs aus Währung holen
               OR ( (TG_OP = 'UPDATE') AND (new.ld_waer  IS DISTINCT FROM old.ld_waer) AND (new.ld_kurs IS NOT DISTINCT FROM old.ld_kurs) ) -- Wechsel der Währung, aber Kurs NICHT verändert. Kurs aktualisieren!
              )
      THEN      --- #19766 Wechselkur soll auch neue geholt werden
          new.ld_kurs     := COALESCE( waerkurs( new.ld_waer ), 1 );
      END IF;

      -- WaWi-Felder nie unter 0. Fall: Bestellung löschen, wo mehr produziert wird, als Bedarf hier war (zB Sollmenge).
      new.ld_stkl         := GREATEST(new.ld_stkl, 0);
      new.ld_stkf         := GREATEST(new.ld_stkf, 0);
      -- Storno
      IF new.ld_storno THEN new.ld_done:=TRUE; END IF;
      --
      IF new.ld_abk=0 THEN RAISE EXCEPTION 'ldsdok__b_12_iu:ld_abk=0'; END IF; --0 im ABK-Index ist immer ein Fehler im Delphi

      -- #13997 der vorher im unten stehenden "IF" befindliche Zusatz "AND (new.ld_code <> 'I')" wurde als Schwachsinn klassifiziert und entfernt
    -- diese Änderung hat beim Insert aber nur kosmetischen Wert, wie ein paar Zeilen tiefer zu sehen ist,
    -- beginnend mit "IF new.ld_code='I' AND TG_OP='INSERT' THEN"
      IF (tg_op = 'INSERT') THEN
          -- Kein manueller Preis angegeben, ld_ep von irgendwoher gefüllt -> ld_preis zurückrechnen.
          IF (new.ld_preis = 0) AND (new.ld_ep <> 0) THEN
            new.ld_preis := new.ld_ep * new.ld_preiseinheit;             -- Alle Wert in Mengeneinheit, die für Preise angegeben ist.
          ELSE -- ld_preis ist angegeben oder alles ist 0
            new.ld_ep   := new.ld_preis / Do1If0(new.ld_preiseinheit);   -- Alle Wert in Mengeneinheit, die für Preise angegeben ist.
          END IF;
      END IF;

      -- #13997 der vorher im unten stehenden "IF" befindliche Zusatz "AND (new.ld_code <> 'I')" wurde als Schwachsinn klassifiziert und entfernt
      IF (tg_op = 'UPDATE') THEN
          -- Preis / PE geändert -> LD_EP Updaten
          IF (new.ld_preis IS DISTINCT FROM old.ld_preis) OR (new.ld_preiseinheit IS DISTINCT FROM old.ld_preiseinheit) THEN
             new.ld_ep := new.ld_preis / Do1If0(new.ld_preiseinheit);  -- Alle Wert in Mengeneinheit, die für Preise angegeben ist.
          ELSE IF (new.ld_ep <> old.ld_ep) THEN -- LD_EP geändert und Preis / PE gleich -> Preis zurückrechnen.
                 new.ld_preis := new.ld_ep * new.ld_preiseinheit;      -- Alle Wert in Mengeneinheit, die für Preise angegeben ist.
               END IF;
          END IF;
       END IF;
      --
      IF TG_OP='UPDATE' THEN
            -- Lieferschein löschen, wo mehr geliefert wurde, als Bedarf hier war (zB Sollmenge)
            IF new.ld_stkl<0 THEN
                new.ld_stkl:=0;
            END IF;
            IF new.ld_stkf<0 THEN
                new.ld_stkf:=0;
            END IF;

            IF (new.ld_abk<>COALESCE(old.ld_abk, 0)) THEN--das ist der rückwärts eintrag ABK-Index
                    RETURN new;
            END IF;
      END IF;
      -- Artikelindex aus Auftrag oder Artikel übernehmen, falls noch keiner angegeben wurde.
      IF (NULLIF(new.ld_aknr_idx,'') IS NULL) THEN
        IF (new.ld_ag_id IS NOT NULL) THEN -- Aus Auftrag?
          new.ld_aknr_idx := ag_aknr_idx FROM auftg WHERE ag_id = new.ld_ag_id;
        END IF;
        IF (NULLIF(new.ld_aknr_idx,'') IS NULL) THEN -- Immer noch nichts? Dann artikel.
          new.ld_aknr_idx := ak_idx FROM art WHERE ak_nr = new.ld_aknr;
        END IF;
      END IF;
      --
      IF new.ld_code='I' AND TG_OP='INSERT' THEN -- für interne Bestellungen aus ABK Auflösung werden die Herstellkosten als Verkaufspreis eingetragen
            SELECT ak_hest INTO new.ld_ep FROM art WHERE ak_nr=new.ld_aknr;
            new.ld_preis := new.ld_ep;
            new.ld_preiseinheit := 1;
      END IF;
      --
      IF new.ld_term IS NOT NULL THEN--Terminwoche setzen
            new.ld_termweek:=week_of_year(new.ld_term);
      END IF;
      IF new.ld_terml IS NOT NULL THEN--Terminwoche setzen
            new.ld_termweekl:=week_of_year(new.ld_terml);
      END IF;
      --übernahme Projektnummer aus Auftrag
      IF new.ld_an_nr IS NULL AND new.ld_ag_id IS NOT NULL THEN
            SELECT COALESCE(ag_an_nr, new.ld_an_nr) /*, COALESCE(ld_ekref, new.ld_ekref)*/ INTO new.ld_an_nr /*, new.ld_ekref*/ FROM auftg LEFT JOIN ldsdok ON ld_abk=ag_mainabk WHERE ag_id=new.ld_ag_id;
      END IF;
      --
      IF new.ld_folgeap_op_ix IS NOT NULL THEN
         new.ld_stat:=TSystem.ENUM_SetValue(new.ld_stat, 'F-ABK');
      END IF;
      --
      RETURN new;
   END$$LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdok__b_01_iu
    BEFORE UPDATE OR INSERT
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__b_01_iu();
  --
 --
 CREATE OR REPLACE FUNCTION ldsdok__b_01_iu__aknr() RETURNS TRIGGER AS $$
    BEGIN
        -- INSERT
        IF new.ld_mce IS NULL THEN --Standard ME für Artikel
           new.ld_mce := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(new.ld_aknr);
        END IF;
        --
        IF tg_op = 'UPDATE' THEN
           -- die meid hat sich nicht geändert, obwohl sich der Artikel geändert hat!
           IF (new.ld_aknr IS DISTINCT FROM old.ld_aknr) AND (new.ld_mce IS NOT DISTINCT FROM old.ld_mce)
           THEN /*wir müssen natürlich auch den Mengencode mit nachziehen!*/
             new.ld_mce := tartikel.me__convertme_for_art__by__mid(new.ld_aknr, old.ld_mce, true);
           END IF;

           IF (new.ld_aknr IS DISTINCT FROM old.ld_aknr) AND (new.ld_ekp_mce IS NOT null) AND (new.ld_ekp_mce IS NOT DISTINCT FROM old.ld_ekp_mce)
           THEN /*wir müssen natürlich auch den Mengencode mit nachziehen!*/
             new.ld_ekp_mce := tartikel.me__convertme_for_art__by__mid(new.ld_aknr, old.ld_ekp_mce, false);
           END IF;
        END IF;

        -- Der Datensatz wurde mit einer für den Artikel ungültigen Mengeneinheit gespeichert. Tabelle: %, ID: %, Feld: %, ART-Nr.: %, Artmgc-ID: %
        IF NOT TArtikel.me__art__artmgc__m_ids__valid(new.ld_aknr, new.ld_mce)
        THEN
           RAISE EXCEPTION '%', Format(lang_text(13795), 'ldsdok', new.ld_id::VARCHAR, 'ld_mce'    , new.ld_aknr, new.ld_mce    ::VARCHAR);
        END IF;

        IF NOT TArtikel.me__art__artmgc__m_ids__valid(new.ld_aknr, new.ld_ekp_mce)
        THEN
           RAISE EXCEPTION '%', Format(lang_text(13795), 'ldsdok', new.ld_id::VARCHAR, 'ld_ekp_mce', new.ld_aknr, new.ld_ekp_mce::VARCHAR);
        END IF;
        --
        RETURN new;
    END $$ LANGUAGE plpgsql;
    --
    CREATE TRIGGER ldsdok__b_01_iu__aknr
      BEFORE INSERT OR UPDATE
      OF ld_aknr, ld_mce, ld_ekp_mce
      ON ldsdok
      FOR EACH ROW
      WHEN (new.ld_aknr IS NOT null) -- wenn null kommt NOT NULL CONSTRAINT
      EXECUTE PROCEDURE ldsdok__b_01_iu__aknr();
 --
 CREATE OR REPLACE FUNCTION ldsdok__b_05_iu__stkvkpuf1() RETURNS TRIGGER AS $$ --beachte auftg__b_05_iu__stkvkpuf1
  BEGIN
     -- Losgröße 1 (keine Kommazahlen : Produktionsauftrag sind Stück)
     IF COALESCE(new.ld_eklos, 0) = 0 THEN
        IF TSystem.Settings__GetBool('lds_losgr_immer1') OR (new.ld_code = 'I') THEN
          new.ld_eklos := 1;
          new.ld_stk := TWawi.Round_ToLos(new.ld_eklos, new.ld_stk);
        END IF;
     END IF;

     -- Zuschnitte
      IF new.ld_o6_stkz + new.ld_o6_lz > 0 THEN  --Wenn Zuschnitte verwendet werden, kann Menge nicht einfach angepasst werden
            IF new.ld_o6_zme IS NOT NULL THEN
              new.ld_stk:=tartikel.zuschnittmenge(new.ld_o6_lz,
                                                  new.ld_o6_bz,
                                                  new.ld_o6_hz,
                                                  0, --ohne Zugabe, da Lieferant das selbst errechnen muß und ich nur Nettowerte angebe
                                                  Round(new.ld_o6_stkz)::INTEGER,
                                                  TArtikel.me__art__artmgc__m_ids__uf(TArtikel.me__mec__by__mid(new.ld_mce), new.ld_o6_zme));
            ELSE
              new.ld_stk:=tartikel.zuschnittmenge(new.ld_o6_lz, new.ld_o6_bz, new.ld_o6_hz,0, new.ld_o6_stkz);
            END IF;
      END IF;
      --
      new.ld_stk_uf1        := tartikel.me__menge__in__menge_uf1(new.ld_mce, new.ld_stk);
      -- Sollmenge umrechnen in GME

      IF (new.ld_stk_soll  = 0) THEN
          new.ld_stk_soll := NULL;
      END IF;
      new.ld_stk_soll_uf1   := tartikel.me__menge__in__menge_uf1(new.ld_mce, new.ld_stk_soll);
      -- Rechnet ld_ep (das bezieht sich auf die Preis-ME) um, in Grund-ME (also Bestell-ME wo Bestellmenge angegeben ist).
      new.ld_ep_uf1         := tartikel.me__preis__in__preis_uf1(COALESCE(new.ld_ekp_mce, new.ld_mce), new.ld_ep); -- ld_ep_uf1 ist also Preis pro 1 von der GME.
      new.ld_ep_basis_w     := new.ld_ep * new.ld_kurs;
      new.ld_ep_uf1_basis_w := new.ld_ep_uf1 * new.ld_kurs;
      --
      RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdok__b_05_iu__stkvkpuf1 --beachte Auftg, Epreis, ...
    BEFORE INSERT OR UPDATE
    OF ld_stk, ld_stk_soll
       , ld_ep, ld_preis, ld_preiseinheit, ld_kurs
       , ld_aknr, ld_mce, ld_ekp_mce
       , ld_o6_lz, ld_o6_bz, ld_o6_hz, ld_o6_stkz
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__b_05_iu__stkvkpuf1();
 --
 CREATE OR REPLACE FUNCTION ldsdok__b_50_iu__possum() RETURNS TRIGGER AS $$
  DECLARE rec RECORD;
          faktor NUMERIC;
  BEGIN
    -- rabattierten Preis berechnen
    faktor:=(1-(new.ld_arab/100))*COALESCE(1-(SELECT ltd_gesrab FROM ldsdokdokutxt WHERE ltd_dokunr=new.ld_dokunr)/100, 1);
    new.ld_ep_netto:=new.ld_ep * faktor; -- (in Preis-ME, da ld_ep verwendet)
    --prozentuale Abzu neu berechnen
    UPDATE ldsabzu SET
      ldaz_betr = COALESCE(new.ld_ep_netto * ldaz_proz/100, 0) -- verwendet rabatierten Preis
    WHERE ldaz_ld_id = new.ld_id
      AND ldaz_proz IS NOT NULL
      AND ldaz_betr <> ROUND(COALESCE(new.ld_ep_netto * ldaz_proz/100, 0), 4);-- Rundungsabweichungen einbeziehen, NUMERIC(12,4)

    --Abzüge/Zuschläge = (Anzahl * Betrag * [Steuerprozent])
    SELECT SUM(ldaz_betr * ldaz_anz) AS abzunetto,
           SUM(ldaz_betr * ldaz_anz * (1+COALESCE(ldaz_steuproz,0)/100)) AS abzubrutto INTO rec FROM ldsabzu WHERE ldaz_ld_id=new.ld_id;

    --Positionssummen | Immer Menge in GME * Preis in GME
    new.ld_netto  := (new.ld_stk_uf1 * new.ld_ep_uf1 * faktor) + COALESCE(rec.abzunetto,0);
    new.ld_brutto := (new.ld_stk_uf1 * new.ld_ep_uf1 * faktor) * (1 + COALESCE(new.ld_steuproz,0)/100) + COALESCE(rec.abzubrutto,0);
    new.ld_netto_basis_w := new.ld_netto  * new.ld_kurs;
    new.ld_brutto_basis_w:= new.ld_brutto * new.ld_kurs;
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdok__b_50_iu__possum --auftg__b_50_iu__possum
   BEFORE INSERT OR UPDATE
   OF ld_stk, ld_ep, ld_preis, ld_arab, ld_kurs, ld_steuproz, ld_netto
      , ld_mce, ld_ekp_mce, ld_preiseinheit
      , ld_o6_lz, ld_o6_bz, ld_o6_hz, ld_o6_stkz
      , ld_waer
   ON ldsdok
   FOR EACH ROW
   EXECUTE PROCEDURE ldsdok__b_50_iu__possum();

 --
 CREATE OR REPLACE FUNCTION ldsdok__b_iu__ld_termweek() RETURNS trigger AS $$
  BEGIN
    -- Kalenderwoche formatieren und Format überprüfen.
      -- von Liefer-Terminwoche geplant und bestätigt


    -- Liefer-Terminwoche (geplant)
    IF new.ld_termweek IS NOT null THEN
        new.ld_termweek := TSystem.termweek__format( new.ld_termweek );
    END IF;

    -- Liefer-Terminwoche (bestätigt)
    IF new.ld_termweekl IS NOT null THEN
        new.ld_termweekl := TSystem.termweek__format( new.ld_termweekl );
    END IF;


    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__b_iu__ld_termweek
    BEFORE INSERT OR UPDATE
    OF ld_termweek, ld_termweekl
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__b_iu__ld_termweek();
 --

 -- Verfügbarkeit in Art setzen
 CREATE OR REPLACE FUNCTION ldsdok__a_10_i() RETURNS TRIGGER AS $$
  BEGIN
    IF current_user='syncro' THEN RETURN new; END IF;

    PERFORM TSystem.Settings__Set('oabk', '');
    PERFORM TSystem.Settings__Set('abk_ot', '');

    PERFORM disablemodified();

    IF (new.ld_pos > 0 OR twawi.ldsdok__ld_pos0defini()) AND (new.ld_code <> 'R' OR twawi.ldsdok__ld_pos0defini()) THEN
        -- durch PERFORM tartikel.bestand_abgleich(new.ld_aknr); ersetzt:
        -- UPDATE art SET ak_bes=ak_bes+new.ld_stk_uf1 WHERE ak_nr=new.ld_aknr AND NOT new.ld_nbedarf; --Nur wenn Bestellung bedarfsdeckend

        -- Rahmenabruf => Wir updaten die zugehörige Rahmenbestellung
        IF new.ld_rhl_nr IS NOT NULL THEN
            -- inkl. dieser Bestellung haben wir genug Abrufe, dass der Rahmen erschöpft ist.
            IF (rahmen_stk_ldsdok_offen(new.ld_rhl_nr)).stko <= 0 THEN
                UPDATE ldsdok
                   SET ld_done = true
                 WHERE (ld_code = 'R' OR ld_pos = 0)
                   AND ld_auftg||'/'||ld_pos = new.ld_rhl_nr
                   AND NOT ld_done; -- Wir müssen zugehörige 'E+Pos0' oder 'R' Bestellung schliessen
            END IF;
        END IF;
    END IF;

    IF new.ld_ag_id IS NOT NULL THEN
        IF NOT EXISTS(SELECT true FROM ldsauftg WHERE la_ld_id = new.ld_id AND la_ag_id = new.ld_ag_id) THEN
            INSERT INTO ldsauftg
                        (la_ld_id, la_ag_id, la_stk, la_mce)
                 VALUES (new.ld_id, new.ld_ag_id, new.ld_stk, new.ld_mce);
        END IF;
    END IF;

    IF NOT EXISTS(SELECT true FROM ldsdoktxt WHERE ldt_code = new.ld_code AND ldt_auftg = new.ld_auftg) THEN
        INSERT INTO ldsdoktxt (ldt_code, ldt_auftg) VALUES (new.ld_code, new.ld_auftg);
    END IF;

    PERFORM enablemodified();
    PERFORM tartikel.bestand_abgleich_intern(new.ld_aknr);  -- Bestandsabgleich sofort (wird ggf. schon gebraucht),
    PERFORM tartikel.prepare_artikel_bedarf(new.ld_aknr);   -- Bedarfsberechnung erst am Ende
                                                            -- Grund: #9139 - Rahmenbestellung hier noch nicht vollständig angelegt (Eintrag in rahmenlieferant erst in ldsdok__a_iu).

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_10_i
    AFTER INSERT
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__a_10_i();
 --
 CREATE OR REPLACE FUNCTION ldsdok__a_15_iu__aknrXXXX() RETURNS TRIGGER AS $$
  BEGIN
   --
   UPDATE bestanfpos SET bap_done = new.ld_done WHERE bap_done IS DISTINCT FROM new.ld_done AND bap_pr_ld_id=new.ld_id AND new.ld_done;
   --
   IF (NOT new.ld_done) AND TSystem.Settings__GetBool('ArtikelBedarfPrognose') AND tartikel.has_vorproduktion_stv(new.ld_aknr) THEN --Position läuft und es existieren Unterartikel
      PERFORM tplanterm.artikel_prognose_from_ldsdok(new);
   END IF;
   --
   IF tg_op='UPDATE' THEN --new.ld_aknr<>old.ld_aknr; im statement direkt
      UPDATE abk SET ab_ap_nr=new.ld_aknr WHERE ab_ix=new.ld_abk AND ab_ap_nr=old.ld_aknr AND new.ld_aknr<>old.ld_aknr;
   END IF;
   --
   RETURN new;
  END$$LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdok__a_15_iu__aknrXXXX
   AFTER INSERT OR UPDATE
   OF ld_aknr, ld_stk, ld_stkl, ld_terml, ld_term, ld_done, ld_storno
   ON ldsdok
   FOR EACH ROW
   EXECUTE PROCEDURE ldsdok__a_15_iu__aknrXXXX();
 -- Bedarfsberechnungen, Teillieferungen, Bestellung + Bestelldokument und ABKs nachziehen
 CREATE OR REPLACE FUNCTION ldsdok__a_10_iu() RETURNS TRIGGER AS $$
  DECLARE r RECORD;
  BEGIN
    -- Bestelldokument anlegen, falls zugewiesen und noch keines existiert.
    IF new.ld_dokunr IS NOT NULL AND NOT EXISTS(SELECT true FROM ldsdokdokutxt WHERE ltd_dokunr=new.ld_dokunr) THEN
        --Kontaktdaten übernehmen
        INSERT INTO ldsdokdokutxt
                    (ltd_dokunr,
                     ltd_apkrzl,
                     ltd_ap,
                     ltd_apint
                     )
             VALUES (new.ld_dokunr,
                     new.ld_lkontaktkrzl,
                     new.ld_lkontakt,
                     CASE WHEN lower( current_user ) IN ( 'syncro', 'postgres' ) THEN
                               new.ld_kontakt
                          WHEN TSystem.Settings__GetBool('dok_ap_is_current_user') THEN
                               tsystem.current_user_ll_db_usename()
                          ELSE coalesce(new.ld_kontakt, tsystem.current_user_ll_db_usename())
                     END
                    );
    END IF;

    -- Rahmenbestellung
    IF (new.ld_code='R') OR (new.ld_pos=0) THEN
        IF NOT EXISTS(SELECT true FROM rahmenlieferant WHERE rhl_nr=new.ld_auftg||'/'||new.ld_pos) THEN
            INSERT INTO rahmenlieferant (rhl_nr, rhl_krz) VALUES (new.ld_auftg||'/'||new.ld_pos, new.ld_kn);
        END IF;--Eintrag in Rahmensubtabelle anlegen
        --
        SELECT ak_ac INTO r FROM art WHERE ak_nr=new.ld_aknr;

        -- Preise / ME / Mengen nachziehen bei Änderungen
        UPDATE rahmenlieferant SET rhl_ak_ac=r.ak_ac, rhl_ak_nr=new.ld_aknr, rhl_mgc=new.ld_mce, rhl_stk=new.ld_stk, rhl_stk_uf1 = new.ld_stk_uf1, rhl_ep=new.ld_ep, rhl_krz=new.ld_kn,
                                   rhl_rab=new.ld_arab, rhl_datv=new.ld_term, rhl_datb=new.ld_terml, rhl_done=new.ld_done, rhl_wert=ldsdok_pos_wert_basis_w(new.ld_id)
        WHERE rhl_nr=new.ld_auftg||'/'||new.ld_pos;
    END IF;
    --
    --Meldung ausgeben,wennn Steuersatz ungültig
    IF new.ld_steucode = (SELECT steu_z FROM steutxt WHERE steu_z=new.ld_steucode AND steu_valid_to<current_date) THEN
        PERFORM PRODAT_TEXT(15810);
    END IF;
    --
    -- Eigenschaften Meldebestandstext + Status herausnehmen, wenn Bestellung auf Artikel erfolgt.
    -- http://redmine.prodat-sql.de/issues/4095
    UPDATE recnokeyword SET r_descr=r_descr||'=>'||new.ld_auftg||'->'||new.ld_pos FROM art WHERE ak_nr=new.ld_aknr AND r_dbrid=art.dbrid AND r_descr='MELDE-TXT';
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_10_iu
    AFTER INSERT OR UPDATE
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__a_10_iu();
 --

 --
 CREATE OR REPLACE FUNCTION ldsdok__a_12_u() RETURNS TRIGGER AS $$
  DECLARE res               NUMERIC;
          lds_stk_restpos   NUMERIC; -- Bei Teillieferungen, Menge die für die automatische Restposition übrig ist.
  BEGIN
    -- Rückwärtseintrag ABK-Index
    IF (new.ld_abk <> COALESCE(old.ld_abk, 0)) THEN
        RETURN new;
    END IF;
    --

    -- Gebundenen Auftrag aktualisieren
    IF new.ld_stk <> old.ld_stk THEN -- Bestellmenge ändert sich
        UPDATE ldsauftg
           SET la_stk = new.ld_stk,
               la_mce = new.ld_mce
         WHERE la_ld_id = new.ld_id
           AND la_ag_id = new.ld_ag_id
           AND (   la_stk = old.ld_stk
                OR la_stk IS NULL) -- direkten Bezug (mit identischer Menge ändern)
           AND NOT EXISTS(SELECT true FROM ldsauftg AS ldsauftg_others
                           WHERE ldsauftg_others.la_ld_id = new.ld_id
                             AND ldsauftg_others.la_id <> ldsauftg.la_id); -- und keine andere Auftragsbezüge sind vorhanden.
    END IF;

    IF new.ld_ag_id IS DISTINCT FROM old.ld_ag_id THEN -- Auftragsbezug ändert sich
        IF new.ld_ag_id IS NOT NULL THEN -- Auftrag wird zugewiesen oder umgeschrieben, dann ggf. Eintrag in ldsauftg, siehe ebenso INSERT-Trigger.
            IF NOT EXISTS(SELECT true FROM ldsauftg
                           WHERE la_ld_id = new.ld_id
                             AND la_ag_id = new.ld_ag_id)
            THEN
                INSERT INTO ldsauftg
                            (la_ld_id, la_ag_id, la_stk, la_mce)
                     VALUES (new.ld_id, new.ld_ag_id, new.ld_stk, new.ld_mce);
            END IF;
        ELSIF old.ld_ag_id IS NOT NULL AND new.ld_ag_id IS NULL THEN -- Auftragsbezug wird explizit entfernt, dann Verlinkung entfernen (wird ggf. gelöscht, siehe ldsauftg).
            UPDATE ldsauftg
               SET la_ld_id= NULL
             WHERE la_ld_id = old.ld_id
               AND la_ag_id = old.ld_ag_id;
        END IF;
    END IF;

    IF new.ld_storno <> old.ld_storno THEN -- Bestellung storniert und reaktiviert.
        UPDATE ldsauftg
           SET la_ld_id = la_ld_id
         WHERE la_ld_id = new.ld_id; -- Berechnung ag_stkb anstoßen.
    END IF;
    --

    -- Rahmen aktualisieren
    IF (new.ld_rhl_nr IS NOT NULL) OR (old.ld_rhl_nr IS NOT NULL) THEN
         -- Rahmenbezug wird entfernt
        IF ((old.ld_rhl_nr IS NOT NULL) AND (new.ld_rhl_nr IS NULL)) THEN
            UPDATE ldsdok
               SET ld_done = coalesce((rahmen_stk_ldsdok_offen(old.ld_rhl_nr)).stko <= 0, ld_done), -- Rahmen (Pos 0 oder R) anhand Abruf bzw. Liefermenge öffen/schließen.
                   ld_stkl = coalesce((rahmen_stk_ldsdok_liefer(old.ld_rhl_nr)).stkl, ld_stkl) -- Im Rahmen ist immer die komplette Liefermenge gehalten
             WHERE (ld_code = 'R' OR ld_pos = 0)
               AND ld_auftg || '/' || ld_pos = old.ld_rhl_nr;
        END IF;

        -- Mengenänderungen bei vorhandenem Rahmenbezug bzw. Rahmenbezug wird nachgesetzt
        IF (new.ld_rhl_nr IS NOT NULL) THEN
            -- Abruf- bzw. Liefermenge ändert sich, Position wird geschlossen oder Rahmenbezug wird hergestellt => Rahmenstatus anpassen.
            IF (old.ld_stk_uf1 <> new.ld_stk_uf1) OR (old.ld_stkl <> new.ld_stkl) OR (old.ld_done <> new.ld_done) OR (old.ld_rhl_nr IS NULL) THEN
                UPDATE ldsdok
                   SET ld_done = coalesce((rahmen_stk_ldsdok_offen(new.ld_rhl_nr)).stko <= 0, ld_done), -- Rahmen (Pos 0 oder R) anhand Abruf bzw. Liefermenge öffen/schließen.
                       ld_stkl = coalesce((rahmen_stk_ldsdok_liefer(new.ld_rhl_nr)).stkl, ld_stkl) -- Im Rahmen ist immer die komplette Liefermenge gehalten
                 WHERE (ld_code = 'R' OR ld_pos = 0)
                   AND ld_auftg || '/' || ld_pos = new.ld_rhl_nr;
            END IF;
        END IF;
    END IF;

    --Auftrag nachziehen bei Mengenänderung oder Änderung des verknüpften Auftrags
    IF (old.ld_pos > 0 OR twawi.ldsdok__ld_pos0defini()) AND (old.ld_code <> 'R' OR twawi.ldsdok__ld_pos0defini()) THEN
        --wir setzen den Wert in der Nachkalkulation richtig!
        IF (new.ld_abk IS NOT NULL) AND (new.ld_stkl <> old.ld_stkl) THEN
            UPDATE abk
               SET ab_nk_st_uf1 = new.ld_stkl
             WHERE ab_ix = new.ld_abk
               AND ab_nk_st_uf1 < new.ld_stkl;
        END IF;
    END IF; --Der IF-Block ist vorgezogen, da ABK neu gerechnet werden muss, wenn sich Liefermenge einer bestätigten Rahmenbestellung ändert.

    -- Rest nur, wenn die Position noch offen ist.
    IF (old.ld_done AND new.ld_done) OR (current_user = 'syncro') THEN --Bestellposition war schon geschlossen => Bedarfe überspringen
        RETURN new;
    END IF;
    --

    PERFORM disablemodified();

    --Bestellung war Bedarfsdeckend und ist nicht mehr oder anders herum => Einmaliges neu Durchrechnen der Bedarfe notwendig
    IF (old.ld_nbedarf IS DISTINCT FROM new.ld_nbedarf) AND (NOT new.ld_done) THEN
        PERFORM tartikel.prepare_artikel_bedarf(new.ld_aknr, true);
    END IF;
    --

    -- Bestellung wieder aktiviert, wenn das kein Rahmen ist => Bedarfe und Teillieferungen neu durchrechnen, dann Exit
    IF old.ld_done AND NOT new.ld_done AND (old.ld_pos > 0 OR twawi.ldsdok__ld_pos0defini()) AND (old.ld_code <> 'R' OR twawi.ldsdok__ld_pos0defini()) THEN
        IF (NOT new.ld_nbedarf) THEN --Nicht bedarfsdeckend => Gleich raus
            PERFORM tartikel.prepare_artikel_bedarf(new.ld_aknr, true);
        END IF;

        PERFORM enablemodified();
        RETURN new;
    END IF;
    --

    -- Bei Artikel oder Mengenänderung, Bedarfe und Teillieferungen neu rechnen, falls Bestellposition bedarfsdeckend ist
    IF (NOT new.ld_nbedarf) THEN
        IF (old.ld_aknr <> new.ld_aknr) OR (old.ld_stk_uf1 <> new.ld_stk_uf1) OR (old.ld_stk_soll_uf1 IS DISTINCT FROM new.ld_stk_soll_uf1)
            OR (old.ld_code <> new.ld_code) OR (old.ld_done <> new.ld_done) OR (old.ld_stkl <> new.ld_stkl)
        THEN
            IF (old.ld_pos > 0 OR twawi.ldsdok__ld_pos0defini()) AND (old.ld_code <> 'R' OR twawi.ldsdok__ld_pos0defini()) AND NOT old.ld_done THEN
                PERFORM tartikel.prepare_artikel_bedarf(old.ld_aknr, true);
            END IF; -- wir haben eine gültige Bestellung und setzen das in der Art!
            IF (new.ld_pos > 0 OR twawi.ldsdok__ld_pos0defini()) AND (new.ld_code <> 'R' OR twawi.ldsdok__ld_pos0defini()) THEN
                PERFORM tartikel.prepare_artikel_bedarf(new.ld_aknr, true);
            END IF; -- wir haben eine gültige Bestellung und setzen das in der Art!
            IF new.ld_pos = 0 OR new.ld_code = 'R' THEN -- Rahmen berücksichtigen
                PERFORM tartikel.prepare_artikel_bedarf(new.ld_aknr, False);
            END IF;
        ELSE --das wird bei Änderung an Art eh gemacht, Gab es diese Änderung an Art nicht dann muss hier!
            IF coalesce(new.ld_term, '1900-01-01') <> coalesce(old.ld_term , '1900-01-01')
                OR coalesce(new.ld_terml, '1900-01-01') <> coalesce(old.ld_terml, '1900-01-01')
                OR coalesce(new.ld_termweek, '190001') <> coalesce(old.ld_termweek, '190001')
                OR coalesce(new.ld_termweekl, '190001') <> coalesce(old.ld_termweekl, '190001')
                OR coalesce(new.ld_termv, '1900-01-01') <> coalesce(old.ld_termv, '1900-01-01')
                OR new.ld_done
                OR new.ld_stk <> old.ld_stk
            THEN
                --PERFORM tartikel.bedarf__make_bedarf(new.ld_aknr);--falls sich nur ein Termin oder so geändert hat! (im anderen Fall ändert sich ak_res und von art wird bedarf neu berechnet!)
                PERFORM tartikel.prepare_artikel_bedarf(new.ld_aknr, true);
            END IF;
        END IF;
    END IF;
    --

    -- Bestellung erledigt, Bedarfe, ABK und Teillieferung nachziehen
    IF new.ld_done AND (old.ld_pos > 0 OR twawi.ldsdok__ld_pos0defini()) AND (old.ld_code <> 'R' OR twawi.ldsdok__ld_pos0defini()) THEN
        IF (NOT new.ld_nbedarf) THEN
            PERFORM tartikel.prepare_artikel_bedarf(new.ld_aknr, False);
        END IF;
        UPDATE abk SET ab_done= true, ab_storno= new.ld_storno WHERE NOT ab_done AND ab_ix = new.ld_abk; --Erledigt- und Storniert-Status in ABK nachziehen
        UPDATE ab2 SET a2_ende= true WHERE a2_ab_ix = new.ld_abk AND NOT a2_ende;--wir beenden alle ABG zu diesm Fertigungsauftrag, wenn das hier als erfüllt eingeht
        --
        UPDATE auftg SET ag_done= true WHERE ag_parentabk = new.ld_abk AND ag_stk_uf1 = ag_stkl AND ag_stk > 0 AND NOT ag_done;--bereits vollständig gebucht Materiallistenpositionen. 0 offen lassen für Chargennachweis-buchung
    END IF;
    --

    -- Bestellung(ldsdoktxt) anlegen bzw. nachziehen
    IF (old.ld_code <> new.ld_code) OR (old.ld_auftg <> new.ld_auftg) THEN
        IF NOT EXISTS(SELECT true FROM ldsdok WHERE ld_code = old.ld_code AND ld_auftg = old.ld_auftg) THEN -- Alte Bestellung ist komplett nicht mehr vorhanden.
            UPDATE ldsdoktxt
               SET ldt_code = new.ld_code, ldt_auftg = new.ld_auftg -- dann Kopf-Texte komplett umziehen
             WHERE ldt_code = old.ld_code AND ldt_auftg = old.ld_auftg
               AND NOT EXISTS(SELECT true FROM ldsdoktxt WHERE ldt_code = new.ld_code AND ldt_auftg = new.ld_auftg); -- ggf. entstehen verwaiste ldsdoktxt. Eigentl. zus. DELETE.
        ELSE -- einzelne Position übernommen, Text kopieren
            INSERT INTO ldsdoktxt
                   (ldt_code, ldt_auftg, ldt_txt)
            SELECT new.ld_code, new.ld_auftg, ldt_txt
              FROM ldsdoktxt
             WHERE ldt_code = old.ld_code AND ldt_auftg = old.ld_auftg
               AND NOT EXISTS(SELECT true FROM ldsdoktxt WHERE ldt_code = new.ld_code AND ldt_auftg = new.ld_auftg);
        END IF;
    END IF;
    --

    -- Bestellung(ldsdoktxt) löschen
    IF NOT EXISTS(SELECT true FROM ldsdok WHERE ld_code = old.ld_code AND ld_auftg = old.ld_auftg) THEN --Zusatztexte zum Bestell!
        DELETE FROM ldsdoktxt WHERE ldt_code = old.ld_code AND ldt_auftg = old.ld_auftg;
    END IF;
    --

    -- Bestelldokument löschen, wenn es keine Positionen mehr enthält
    IF new.ld_dokunr IS NULL AND old.ld_dokunr IS NOT NULL THEN
        IF NOT EXISTS(SELECT true FROM ldsdok WHERE ld_dokunr = old.ld_dokunr) THEN --Zusatztexte zum Bestell (Dokument)!
            DELETE FROM ldsdokdokutxt WHERE ltd_dokunr = old.ld_dokunr;
        END IF;
    END IF;
    --
    PERFORM enablemodified();
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_12_u
    AFTER UPDATE
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__a_12_u();
 --

 -- Bei Änderung von ME und/oder Menge auch Mengen der Bedarfsverursacher-Liste neu berechnen.
 CREATE OR REPLACE FUNCTION ldsdok__a_20_u__ld_mce__ldsauftg_uf1() RETURNS TRIGGER AS $$
  BEGIN
    IF new.ld_stk <> old.ld_stk THEN
        -- ME + Menge in Bestellung wird geändert (Option xtt6101: Preis / Mengen nach neuen Umrechnungsfaktor umrechnen? - Ja).
        UPDATE ldsauftg
           SET la_stk = NULL, -- Menge in ME zurücksetzen. Wird neu berechnet per ldsauftg__b_10_iu__uf1.
               la_mce = new.ld_mce
         WHERE la_ld_id = new.ld_id
           AND la_mce <> new.ld_mce;
    ELSE
       -- Nur ME in Bestellung wird geändert (Option xtt6101: Preis / Mengen nach neuen Umrechnungsfaktor umrechnen? - Nein).
        UPDATE ldsauftg
           SET la_mce = new.ld_mce -- Menge in ME bleibt erhalten. Mengen in GME wird neu berechnet per ldsauftg__b_10_iu__uf1.
         WHERE la_ld_id = new.ld_id
           AND la_mce <> new.ld_mce;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_20_u__ld_mce__ldsauftg_uf1
    AFTER UPDATE
    OF ld_mce
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__a_20_u__ld_mce__ldsauftg_uf1();
 --

 -- Teillieferungen, Mengen und Termine der Restposition nachsetzen
 CREATE OR REPLACE FUNCTION ldsdok__a_30_u__updateteillieferung() RETURNS TRIGGER AS $$
  DECLARE ldrest  NUMERIC;
          rows    INTEGER;
  BEGIN

   -- Wenn es keine Teillieferungen gibt => Raus
   IF NOT EXISTS (SELECT true FROM ldslieferung WHERE ldl_ld_id = new.ld_id) THEN RETURN new; END IF;

   -- Geschlossene Position => Raus
   IF (new.ld_done AND old.ld_done) THEN RETURN new; END IF;

   -- Gerade geschlossen oder Position nochmal geöffnet => Status an die Teillieferungen weitergeben
   IF (new.ld_done IS DISTINCT FROM old.ld_done) OR (new.ld_storno IS DISTINCT FROM old.ld_storno) THEN
     UPDATE ldslieferung SET ldl_done = new.ld_done WHERE ldl_ld_id = new.ld_id;
     PERFORM ldslieferung_update_stkl(new.ld_id);
   END IF;

   IF new.ld_stkl IS DISTINCT FROM old.ld_stkl THEN
     PERFORM ldslieferung_update_stkl(new.ld_id);
   END IF;

   -- Terminverschiebung wird in die Rest-Position weitergegeben
   IF   (new.ld_terml   IS DISTINCT FROM old.ld_terml)
     OR (new.ld_term    IS DISTINCT FROM old.ld_term)
     OR (new.ld_stk     IS DISTINCT FROM old.ld_stk )
     OR (new.ld_stk_uf1 IS DISTINCT FROM old.ld_stk_uf1 )
     THEN
     PERFORM ldslieferung_update_restpos(new.ld_id);
   END IF;

   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdok__a_30_u__updateteillieferung
   AFTER UPDATE OF ld_done, ld_storno, ld_stk, ld_stkl, ld_stk_uf1, ld_term, ld_terml, ld_termweek, ld_termweekl
   ON ldsdok
   FOR EACH ROW
   EXECUTE PROCEDURE ldsdok__a_30_u__updateteillieferung();
 --

 -- #10157 bei FolgeABK ldsdokE.ld_nbedarf := true
CREATE OR REPLACE FUNCTION ldsdok__b_70_iu__ld_folgeap_op_ix() RETURNS TRIGGER AS $$
 BEGIN
   new.ld_nbedarf := true;

   RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__b_70_iu__ld_folgeap_op_ix
    BEFORE INSERT OR UPDATE
    ON ldsdok
    FOR EACH ROW
    WHEN ((new.ld_folgeap_op_ix IS NOT NULL) AND (new.ld_code = 'E'))
    EXECUTE PROCEDURE ldsdok__b_70_iu__ld_folgeap_op_ix();
--

-- Materialliste: Beistellung mit Datum mitziehen!
CREATE OR REPLACE FUNCTION ldsdok__a_90_u__auftgi__beistelldatum() RETURNS TRIGGER
    AS $$
    BEGIN
        -- ACHTUNG: gleicher Code im F2 für Insert.!!!! (F2-Fenster Beistellung anlegen im Einkauf)
        UPDATE auftg
           SET ag_kdatum = timediff_substdays(coalesce(new.ld_terml, new.ld_term), ak_bfr + ac_auftgi_pre_float, true, true)
          FROM art JOIN artcod ON ak_ac = ac_n
         WHERE ak_nr = ag_aknr
           AND ag_parentabk = new.ld_abk
           -- AND TSystem.ENUM_GetValue(ag_stat, 'BL') ?? aktuell auskommentiert, da auch nicht BL Artikel aus der Stückliste als BL übernommen werden und diese sonst im Datum nicht aktaulisiert währen
           AND ag_kdatum IS DISTINCT FROM timediff_substdays(coalesce(new.ld_terml, new.ld_term), ak_bfr)
        ;

        RETURN new;
    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_90_u__auftgi__beistelldatum
    AFTER UPDATE
    OF ld_term, ld_terml
    ON ldsdok
    FOR EACH ROW
    WHEN (new.ld_abk IS NOT NULL AND new.ld_code = 'E')
    EXECUTE PROCEDURE ldsdok__a_90_u__auftgi__beistelldatum();


CREATE OR REPLACE FUNCTION teinkauf.auftg__folgebedarf__insert(
    IN _ld_id         integer,
    IN _ab_ix         integer,
    IN _ag_stk        numeric,
    IN _status        varchar,
       -- we-bezug: Vorgabecharge, Arbeitsgangbezug zB für Lagerbewegung UE, wo die Zugebuchte Charge auch abgebucht werden muss
    IN _w_wen         integer = null
    )
    RETURNS integer
    AS $$
    DECLARE _result integer;
            _w_a2_id integer;
            _w_lgchnr varchar;
    BEGIN
        -- #16363 Auslagern des Einfügens des Folgebedarfs in eine Funktion


        -- w_wen wird aktuell mitgegeben, wenn es ein lagerzugang UE ist um Arbeitsgangbezug sowie Charge zu ermitteln
        -- wenn das mal geändert / erweitert wird, muss hier entsprechend eine anpassung erfolgen
        IF     _w_wen IS NOT null
           AND NOT TSystem.ENUM_GetValue(_status, 'UE')
        THEN
           RAISE EXCEPTION 'if w_wen is set to get operations data - status has to be ue';
        END IF;

        -- Materialbedarf durch Lagerzugang UE. Somit ist die Vorgabecharge für die Ausbuchung mitzugeben
        IF _w_wen IS NOT null
        THEN
           SELECT w_a2_id, w_lgchnr INTO _w_a2_id, _w_lgchnr FROM wendat WHERE w_wen = _w_wen;

           IF _w_a2_id IS null THEN
              -- bei Lagerzugang UE MUSS ein Arbeigsang vorhanden sein.
              RAISE EXCEPTION 'wendat.w_a2_id IS null but process lagerzugang UE.';
           END IF;
        END IF;


        INSERT INTO auftg
                    ( ag_astat,
                      ag_parentabk, ag_mainabk,
                      ag_aknr, ag_stk,
                      ag_kontakt, ag_nbedarf,
                      ag_stat, ag_a2_id
                     )
             SELECT 'I',
                    _ab_ix, tabk.abk_main_abk(_ab_ix),
                    ld_aknr, _ag_stk,
                    ld_kontakt, true,
                    _status, _w_a2_id
               FROM ldsdok
              WHERE ld_id = _ld_id
          RETURNING ag_id INTO _result;

        -- wird durch lagerzugang UE vorgegeben damit exakt gleicher artikel bei weiterbearbeitung automatisch vorgeschlagen wird
        IF _w_lgchnr IS NOT null THEN
           UPDATE auftgmatinfo SET agmi_lg_chnr = _w_lgchnr WHERE agmi_ag_id = _result;
        END IF;

        RETURN _result;

    END $$ LANGUAGE plpgsql;


 -- FolgeABK bei externen Bestellungen auslösen
 CREATE OR REPLACE FUNCTION ldsdok__a_70_iu__ld_folgeap_op_ix() RETURNS TRIGGER AS $$
  DECLARE abix INTEGER;
          agid INTEGER;
  BEGIN
    -- #8618 - Bestellung Kaufteil mit automatischer ABK (FolgeABK) beim Lagerzugang (Kontrolle, Nacharbeit, usw.) - z.B. Platte kaufen aber Loch selbst bohren

    IF (TG_OP = 'UPDATE') THEN
      -- gleiche Daten abfangen
      IF new.ld_folgeap_op_ix IS NOT DISTINCT FROM old.ld_folgeap_op_ix THEN
        RETURN new;
      END IF;
    END IF;

     --1. ABK erstellen
         abix := TAbk.abk__create(new.ld_aknr, new.ld_folgeap_op_ix, new.ld_stk, NULL, NULL, NULL,'ldsdok', new.dbrid, 'F-ABK'); --Organisatorische ABK erstellen, welche uns selbst als Beistellung enthält
         --abix := TAbk.abk__create(new.ld_aknr, new.ld_folgeap_op_ix, new.ld_stk, new.ld_stk, NULL, NULL,'ldsdok', new.dbrid, 'F-ABK'); --Organisatorische ABK erstellen, welche uns selbst als Beistellung enthält, mit Sollmengen
     --2. uns selbst als Materialliste unter die neue ABK legen = wir sind gleichzeitig folgebedarf. Wenn der LZ des Lieferanten kommt ist sogleich ein Bedarf da.
         agid := teinkauf.auftg__folgebedarf__insert( new.ld_id, abix, new.ld_stk, 'F-ABK' );
     --3. Produktionsauftrag erstellen für Fertigbearbeitung von uns selbst, welcher Bezug zur Beistellung hat
         PERFORM TWaWi.LdsDokI__create__from__auftgi(agid, new.ld_stk, NULL, abix, 'F-ABK'); --setzt auch ab_ld_id
         --ldid := TWaWi.LdsDokI__create__from__auftgi(agid, new.ld_stk, new.ld_stk, abix, 'F-ABK'); -- mit Sollmengen
     /*
     --4. #10157; Die externe Bestellung auf "nicht bedarfsdeckend" (ldsdok__b_70_iu__ld_folgeap_op_ix) und uns in dessen ABK-Materialliste als "nicht bedarfswirksam" setzen,
     --   da ja hier sofort die Folge-ABK erzeugt wurde, deren Materialliste nochmal uns selbst als Bedarfe generiert und der PA den Bedarfe erneut deckt
     --   = doppelte "Menge bestellt" und doppelte "Menge Verkauft"
         UPDATE auftg
         SET
           ag_nbedarf = true
         WHERE
           (ag_id = agid) AND
           (NOT ag_nbedarf);
         --->>>> siehe oben bei Insert, ag_nbedarf wird direkt mitgegeben
     */
     --5. Hinweis-Meldung an Benutzer
         PERFORM PRODAT_HINT (lang_text(21095)); --'Folge-ABK'
     --Der Prozess geht weiter mit --> Lagerzugang Lieferant sowie Lagerabgang auf FolgeABK -- siehe #9096
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_70_iu__ld_folgeap_op_ix
    AFTER INSERT OR UPDATE
    ON ldsdok
    FOR EACH ROW
    WHEN ((new.ld_folgeap_op_ix IS NOT NULL) AND (new.ld_code = 'E'))
    EXECUTE PROCEDURE ldsdok__a_70_iu__ld_folgeap_op_ix();

  -- im Update-Fall die Mengen von zugehörigen Produktionsauftrag, ABK und Materialliste ändern;
  CREATE OR REPLACE FUNCTION ldsdok__a_71_u__ld_folgeap_op_ix() RETURNS TRIGGER AS $$
  DECLARE ldid_pa INTEGER;
          abix INTEGER;
          agid INTEGER;
  BEGIN
    -- #8618 - Bestellung Kaufteil mit automatischer ABK (FolgeABK) beim Lagerzugang (Kontrolle, Nacharbeit, usw.) - z.B. Platte kaufen aber Loch selbst bohren

    IF ((old.ld_folgeap_op_ix IS NULL) OR (old.ld_code <> 'E')) THEN -- quasi Trigger-WHEN
      RETURN new;
    END IF;

    SELECT
      pa.ld_abk,
      pa.ld_ag_id,
      pa.ld_id
    INTO
      abix,
      agid,
      ldid_pa
    FROM
      TWawi.ldsdoki__from__ldsdok__folgeabk(new.ld_id) AS pa;

    RAISE NOTICE '% ldsdok E = %; abk = %; ldsdok I = %; auftg I = %', TG_OP, new.ld_id, abix, ldid_pa, agid;

    -- UPDATE von ldsdok I, auftg I und abk
      --1. Produktionsauftrag
      UPDATE ldsdok SET ld_stk = new.ld_stk WHERE ((ld_id = ldid_pa) AND (ld_stk <> new.ld_stk));
      --2. zugehörige Materialliste unter der ABK
      UPDATE auftg SET ag_stk = new.ld_stk WHERE ((ag_id = agid) AND (ag_stk <> new.ld_stk));
      --3. erstelle ABK
      UPDATE abk SET ab_st_uf1 = new.ld_stk WHERE ((ab_ix = abix) AND (ab_st_uf1 <> new.ld_stk));
      --4. Der Prozess geht weiter mit --> Lagerzugang Lieferant sowie Lagerabgang auf FolgeABK -- siehe #9096
      RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_71_u__ld_folgeap_op_ix
    AFTER UPDATE
    OF ld_stk
    ON ldsdok
    FOR EACH ROW
    -- quasi Trigger-WHEN siehe oben: (old.ld_folgeap_op_ix IS NULL) OR (old.ld_code <> 'E')
    EXECUTE PROCEDURE ldsdok__a_71_u__ld_folgeap_op_ix();
 --

 CREATE OR REPLACE FUNCTION ldsdok__b_iu__lieferant_sperr() RETURNS TRIGGER
     AS $$
     DECLARE _r record;
             _nCheck record;
             _norm varchar;
     BEGIN

         SELECT a2_krz, a2_sperr,
                ak_norm
           INTO _r
           FROM adk2,
                art
          WHERE a2_krz = new.ld_kn
            AND ak_nr = new.ld_aknr
         ;


         --Normprüfung für Auftragsnorm bzw. Fertigungsnorm Artikel bei einem bestimmten Lieferanten (Nur Externbestellung)
         _norm := coalesce( new.ld_nident, _r.ak_norm );

         IF     (coalesce(_norm, '') <> '')
            AND (new.ld_code = 'E' )
         THEN
            SELECT * INTO _nCheck
              FROM TAdk.Check_EKZert( new.ld_kn, _norm)
            ;   --OUT isValid boolean, OUT isWarning boolean, OUT infotext varchar

            IF (NOT _nCheck.isValid) AND (NOT _nCheck.isWarning) THEN
               RAISE EXCEPTION '%', _nCheck.infotext;
            END IF;
         END IF;


         --Lieferantendaten gefunden ...
         IF     (_r.a2_krz IS NOT NULL)
            AND (new.ld_code = 'E')
         THEN
            IF     (_r.a2_sperr IS NOT NULL)
               AND (_r.a2_sperr <= current_date)
            THEN
               RAISE EXCEPTION '%', lang_text(13208) || ' ' || _r.a2_sperr::varchar ; --13208 = Der Lieferant ist laut Kreditorendaten gesperrt. Sperrdatum:
            END IF;
         END IF;

         RETURN new;
     END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__b_iu__lieferant_sperr
    BEFORE INSERT OR UPDATE
    OF ld_kn
    ON ldsdok
    FOR EACH ROW
    WHEN (new.ld_code = 'E')
    EXECUTE PROCEDURE ldsdok__b_iu__lieferant_sperr();

 -- Direkte Bestellanforderungen verlinken.
 CREATE OR REPLACE FUNCTION ldsdok__a_60_i__bestanfpos() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE bestanfpos SET
      bap_ld_id = new.ld_id
    WHERE bap_ld_id IS NULL
      AND NOT bap_done
      AND NOT bap_prognose
      AND bap_aknr = new.ld_aknr
      AND bap_banr = new.ld_auftg; -- direkt

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_60_i__bestanfpos
    AFTER INSERT
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__a_60_i__bestanfpos();

 -- Projektnummer weitergeben an Folgeprozesse (abk.ab_an_nr)
 CREATE OR REPLACE FUNCTION ldsdok__a_90_u__ld_an_nr() RETURNS TRIGGER AS $$
  BEGIN
   PERFORM disablemodified();
   UPDATE abk SET ab_an_nr=new.ld_an_nr WHERE ab_mainabk=new.ld_abk AND ab_an_nr IS DISTINCT FROM new.ld_an_nr;
   PERFORM enablemodified();
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldsdok__a_90_u__ld_an_nr
   AFTER UPDATE OF ld_an_nr
   ON ldsdok
   FOR EACH ROW
   EXECUTE PROCEDURE ldsdok__a_90_u__ld_an_nr();


-- Automatische Verknüpfung mit Kopfposition und Übernahme von Kopfstatus
--   und Kopfposition der Bestellung schliessen, wenn nötig
CREATE OR REPLACE FUNCTION ldsdok__a_iu__demontage() RETURNS TRIGGER AS $$
  DECLARE
    _hpos SMALLINT;
    _stat VARCHAR;
  BEGIN
    IF tg_op = 'INSERT' THEN
      SELECT
        ld_pos, ld_stat
      FROM
        ldsdok
      WHERE
        ld_auftg = (SELECT ld_auftg FROM ldsdok WHERE ld_id = new.ld_id)
        AND ld_id <> new.ld_id
        AND ld_hpos IS NULL                          --Kopfsposition
        AND TQS.ldsdok__demontage__is(ld_id)
        AND ld_abk IS NOT NULL                        --hat ABK
      ORDER BY
        ld_pos
      LIMIT 1
      INTO
        _hpos, _stat;
      --
      UPDATE
        ldsdok
      SET
        ld_hpos = COALESCE(_hpos, new.ld_hpos),             --Verknüpfen mit Kopfposition
        ld_stat = COALESCE(_stat, new.ld_stat),             --und übernehmen Kopfstatus
        ld_nbedarf = COALESCE(new.ld_nbedarf, new.ld_hpos IS NULL
                                              AND TSystem.ENUM_GetValue(new.ld_stat, 'DM')
                             ) --Standardwerte für Hauptposition, wenn undefiniert (#17972, #17982)
      WHERE
        ld_id = new.ld_id;
    END IF;
    --
    IF    tg_op = 'UPDATE'
      AND new.ld_stat IS NOT NULL
    THEN
      IF    new.ld_hpos IS NOT NULL   --wenn es keine Kopfposition ist
        AND new.ld_done IS TRUE       --und eine von Bestellpositionen wird bereit geschlossen
      THEN
        --Kopfposition der Bestellung schliessen, wenn nötig
        PERFORM TQS.ldsdok__demontage_head_done__set(new.ld_id);
      END IF;

      --Terminierungsdatum vom Kopf auf für Unterpositionen übernehmen (bei der Terminierung oder direkte Anpassung)
      IF     new.ld_hpos IS NULL          --wenn es die Kopfposition ist
        AND (   new.ld_term IS NOT NULL   --und wurde gerade terminiert
             OR new.ld_terml IS NOT NULL
            )
      THEN
        UPDATE
          ldsdok
        SET
          ld_term  = IFTHEN(old.ld_term  IS DISTINCT FROM new.ld_term,  new.ld_term,  ld_term),
          ld_terml = IFTHEN(old.ld_terml IS DISTINCT FROM new.ld_terml, new.ld_terml, ld_terml)
        WHERE
          ld_id IN (SELECT * FROM teinkauf.ldsdok_do_ldsdoksubpos(new.ld_id));
      END IF;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

--
  CREATE TRIGGER ldsdok__a_iu__demontage
   AFTER INSERT OR UPDATE
     OF ld_done, ld_stat, ld_term, ld_terml
     ON ldsdok
   FOR EACH ROW
   WHEN (    new.ld_code = 'I'
         AND (   new.ld_stat IS NULL
              OR TQS.ldsdok__demontage__is(new.ld_id)
             )
     )
   EXECUTE PROCEDURE ldsdok__a_iu__demontage();
--


-- After STATEMENT: Bedarfsberechnung
 CREATE OR REPLACE FUNCTION ldsdok__as__a_iu() RETURNS TRIGGER AS $$
  BEGIN
  PERFORM do_artikel_bedarf();
  RETURN NULL;
  END $$ LANGUAGE plpgsql;
 --
 CREATE TRIGGER ldsdok__as__a_iu
  AFTER INSERT OR UPDATE
  ON ldsdok
  FOR EACH STATEMENT
  EXECUTE PROCEDURE ldsdok__as__a_iu();
 --

 --
 CREATE OR REPLACE FUNCTION ldsdok__a_d() RETURNS TRIGGER AS $$
  DECLARE
      res NUMERIC;
  BEGIN

      IF old.ld_dokunr IS NOT NULL THEN
          RAISE EXCEPTION 'xtt3654';
      END IF;

      PERFORM disablemodified();

      DELETE FROM stvtrs WHERE resid = 'ldsdok_ld_id_' || old.ld_id;

      -- Zusatztexte zum Auftrag!
      IF NOT EXISTS( SELECT true FROM ldsdok WHERE ld_auftg = old.ld_auftg AND ld_code = old.ld_code ) THEN
          DELETE FROM ldsdoktxt WHERE ldt_auftg = old.ld_auftg AND ldt_code = old.ld_code;
      END IF;

      -- Zusatztexte zum Bestell (Dokument)!
      IF (
              old.ld_dokunr IS NULL
          AND NOT EXISTS( SELECT true FROM ldsdok WHERE ld_dokunr = old.ld_dokunr )

      ) THEN

          DELETE FROM ldsdokdokutxt WHERE ltd_dokunr = old.ld_dokunr;
      END IF;

      --- #13244
      UPDATE bestvorschlagpos
         SET bvp_einkauf_p_id = NULL
       WHERE bvp_einkauf_p_id = old.ld_id;
      ---
      IF ( old.ld_code = 'R' ) OR ( old.ld_pos = 0 ) THEN
          DELETE FROM rahmenlieferant WHERE rhl_nr = old.ld_auftg || '/' || old.ld_pos;
      END IF;
      --
      PERFORM tartikel.bedarf__make_bedarf(old.ld_aknr);
      PERFORM tartikel.bestand_abgleich(old.ld_aknr);
      --
      PERFORM enablemodified();

      RETURN old;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_d
    AFTER DELETE
    ON ldsdok
    FOR EACH ROW
    EXECUTE PROCEDURE ldsdok__a_d();
 --

 -- Eintrag von Ausschuss in ABK-Eigenschaften bei
 -- 1. Änderung der Fertigungsmenge; 2. Rücklieferungen von Auswärtsvergaben.
 -- Achte auf Auschluss von KS: TSystem.Settings__Get('Keine.Ausschuss-Steuerung.fuer.KS')
 CREATE OR REPLACE FUNCTION ldsdok__a_u_ausschuss() RETURNS TRIGGER AS $$
  BEGIN
    IF new.ld_code = 'I' AND new.ld_abk IS NOT NULL THEN -- Fertigungsbestellung
        IF (new.ld_stk_uf1 IS DISTINCT FROM old.ld_stk_uf1) OR (new.ld_stk_soll_uf1 IS DISTINCT FROM old.ld_stk_soll_uf1) THEN -- Bei Änderung der Fertigungsmengen den Eintrag von Ausschuss neu bewerten.
            PERFORM tabk.set_abkrecno_unterproduktion(new.ld_abk);
        END IF;
    ELSIF new.ld_code = 'E' AND new.ld_a2_id IS NOT NULL THEN -- Auswärstvergabe
        IF new.ld_stkl IS DISTINCT FROM old.ld_stkl THEN -- Bei Änderung der rückgelieferten AW-Menge den Eintrag von Aussschuss neu bewerten.
            PERFORM tabk.set_abkrecno_unterproduktion((SELECT a2_ab_ix FROM ab2 WHERE a2_id = new.ld_a2_id));
        END IF;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_u_ausschuss
    AFTER UPDATE OF ld_stk, ld_stk_uf1, ld_stk_soll, ld_stk_soll_uf1, ld_stkl
    ON ldsdok
    FOR EACH ROW
    WHEN ((new.ld_code = 'I' AND new.ld_abk IS NOT NULL) OR (new.ld_code = 'E' AND new.ld_a2_id IS NOT NULL))
    EXECUTE PROCEDURE ldsdok__a_u_ausschuss();
 --

 -- DMS - Verschlagwortung der Auftragsbestätigung des Lieferanten
  CREATE OR REPLACE FUNCTION ldsdok__a_iu_keywords_dms() RETURNS TRIGGER AS $$
  BEGIN
    -- WHEN (new.ld_abnr IS NOT NULL)
    IF (new.ld_abnr IS NOT null) THEN
        -- Dokument-ID der neuen AB suchen
        -- weiterhin alle Dokumente, die durch die Dokumentnummer gleich zugewiesen sind aktualisieren (zB Auswärtsbestellung - immer unterschiedliche Bestellnummern auf einem Dokument)

        PERFORM TDMS.dokument__keywords__update__by__pd_dokident_doktype(
                              ld_id::varchar,
                              'bestblief',
                              'ldsdoktxt'
                              )
           FROM ldsdok l1
          WHERE Equals(l1.ld_dokunr, new.ld_dokunr) -- Equals: kann null sein
                -- alle Positionen, die die gleiche ABNR vorher hatten mitziehen
            AND l1.ld_abnr = new.ld_abnr -- muss da sein und gleich
        ;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_iu_keywords_dms
    AFTER INSERT OR UPDATE
    OF ld_abnr
    ON ldsdok
    FOR EACH ROW
    WHEN (new.ld_abnr IS NOT null)
    EXECUTE PROCEDURE ldsdok__a_iu_keywords_dms();
 --

 CREATE OR REPLACE FUNCTION ldsdok__a_u__ld_lkontaktkrzl() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE ldsdokdokutxt
       SET ltd_apkrzl = new.ld_lkontaktkrzl, ltd_ap = new.ld_lkontakt
     WHERE ltd_dokunr = new.ld_dokunr
       AND ltd_apkrzl IS null
       AND ltd_ap IS null;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_u__ld_lkontaktkrzl
   AFTER UPDATE OF ld_lkontaktkrzl, ld_lkontakt
   ON ldsdok
   FOR EACH ROW
   WHEN (new.ld_dokunr IS NOT null)
   EXECUTE PROCEDURE ldsdok__a_u__ld_lkontaktkrzl();


--

CREATE OR REPLACE FUNCTION ldsdok__a_50_iu_folgeabk() RETURNS TRIGGER AS $$ -- #9096 - Folgearbeit: Lagerzugang Lieferant sowie Lagerabgang auf FolgeABK
  DECLARE term_date date;
          abix integer;
  BEGIN
    -- Ist die Bestellposition ein Artikel mit FolgeABK (also ein unfertiger Artikel) so wird beim
    -- Bestätigen des Lieferdatums die zum Artikel gehörige FolgeABK automatisch vorwärtsterminiert.
    term_date := NULL;
    --
    IF coalesce(new.ld_terml, new.ld_term) IS NOT NULL THEN
       term_date := coalesce(new.ld_terml, new.ld_term);
    ELSIF coalesce(new.ld_termweekl, new.ld_termweek) IS NOT NULL THEN
       term_date := termweek_to_date(coalesce(new.ld_termweekl, new.ld_termweek), false);
    END IF;
    --
    abix := ab_ix FROM abk WHERE ab_dbrid = new.dbrid AND TSystem.ENUM_GetValue(ab_stat, 'F-ABK');
    --
    IF term_date IS NOT NULL THEN
       --RAISE EXCEPTION 'abix=%, date=%', abix, term_date;    abix=150734, date=2019-01-08
       PERFORM tplanterm.abk_term(abix, timediff_adddays(term_date, 5, True, True)::DATE, true, true);
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ldsdok__a_50_iu_folgeabk
    AFTER INSERT OR UPDATE
    OF ld_termweekl, ld_terml, ld_termweek, ld_term
    ON ldsdok
    FOR EACH ROW
    WHEN ((new.ld_code = 'E') AND TSystem.ENUM_GetValue(new.ld_stat, 'F-ABK'))
    EXECUTE PROCEDURE ldsdok__a_50_iu_folgeabk();
--

--Hilfsfunktionen  + Summenberechnung Bestellung
CREATE OR REPLACE FUNCTION ldsdok_pos_wert_calc(ldid INTEGER, offen BOOL, basis_w BOOL) RETURNS NUMERIC(12,4) AS $$
  DECLARE wert   NUMERIC;
          menge  NUMERIC;
          pospreis NUMERIC;
          arab   NUMERIC(12,4);
          grab   NUMERIC(12,4);
          abzu   NUMERIC(12,4);
          --optw   NUMERIC(12,4);
          done   BOOL;
          kurs   NUMERIC(7,4);
          result NUMERIC;
  BEGIN
    --caching
    SELECT c_resultn INTO result FROM tcache.function_cache WHERE c_funcname='ldsdok_pos_wert_calc' AND c_param0=ldid AND c_param1::BOOL=offen AND c_param2::BOOL=basis_w AND NOT c_dirty;
    IF result IS NOT NULL THEN
        RETURN result;
    END IF;
    --end caching
    SELECT IFTHEN(offen, ld_stk_uf1-GREATEST(ld_stkl, ld_stkf, 0), ld_stk_uf1), ld_ep_uf1, ld_kurs, ld_arab, ltd_gesrab, ld_done
    INTO menge, pospreis, kurs, arab, grab, done
    FROM ldsdok LEFT JOIN ldsdokdokutxt ON ltd_dokunr=ld_dokunr WHERE ld_id=ldid;
    --
    IF offen AND done THEN
        --caching schreiben
        PERFORM tcache.function_cache_setcache_ldsdok_pos_wert_calc(ldid, offen, basis_w, 0);
        --end caching schreiben
        RETURN 0;
    END IF;
    --
    abzu:=twawi.ldsdok__abzu__netto__by__ld_id(ldid); --
    --SELECT SUM(ldak_ep) INTO optw FROM ldsartkonf WHERE ldak_ld_id=ldid;
    --
    --pospreis:=pospreis+COALESCE(optw,0);
    --
    IF offen AND menge<0 THEN
        --caching schreiben
        PERFORM tcache.function_cache_setcache_ldsdok_pos_wert_calc(ldid, offen, basis_w, 0+COALESCE(abzu,0));
        --end caching schreiben
        RETURN 0+COALESCE(abzu,0);
    END IF;
    --
    wert:=pospreis*(1-COALESCE(arab,0)/100)*(1-COALESCE(grab,0)/100);
    --
    result:=CAST((wert*menge+COALESCE(abzu,0))*IFTHEN(basis_w, kurs, 1) AS NUMERIC(12,4));
    --caching schreiben
    PERFORM tcache.function_cache_setcache_ldsdok_pos_wert_calc(ldid, offen, basis_w, result);
    --end caching schreiben
    RETURN result;
  END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION ldsdok_pos_wert_offen_basis_w(ldid INTEGER) RETURNS NUMERIC(12,4) AS $$
  BEGIN
    RETURN ldsdok_pos_wert_calc(ldid, true, true);
  END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION ldsdok_pos_wert_offen(ldid INTEGER) RETURNS NUMERIC(12,4) AS $$
  BEGIN
    RETURN ldsdok_pos_wert_calc(ldid, true, false);
  END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION ldsdok_pos_wert_basis_w(ldid INTEGER) RETURNS NUMERIC(12,4) AS $$
  BEGIN
    RETURN ldsdok_pos_wert_calc(ldid, false, true);
  END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION ldsdok_pos_wert(ldid INTEGER) RETURNS NUMERIC(12,4) AS $$
  BEGIN
    RETURN ldsdok_pos_wert_calc(ldid, false, false);
  END $$ LANGUAGE plpgsql STABLE;
--

--Summe Einkauf, Positionsrabatte und Ab/Zuschläge eingerechnet
 CREATE OR REPLACE FUNCTION sum_ldsdok(IN ldcode VARCHAR,IN ldauftg VARCHAR) RETURNS NUMERIC AS $$
 BEGIN
  RETURN SUM(ldsdok_pos_wert(ld_id)) FROM ldsdok WHERE ld_code=ldcode AND ld_auftg=ldauftg AND (ld_pos>0 OR twawi.ldsdok__ld_pos0defini()) AND NOT ld_storno;
 END$$LANGUAGE plpgsql STABLE;

 --Summe über Einkaufsdokument, inkl. Positionsrabatt, Gesamtrabatt und Ab/Zuschläge
 CREATE OR REPLACE FUNCTION sum_ldsdok_dokunr(IN dokunr INTEGER, brutto BOOL DEFAULT FALSE, IN BASIS_W BOOLEAN DEFAULT FALSE) RETURNS NUMERIC AS $$
 DECLARE summe NUMERIC;
         r RECORD;
         summe_netto NUMERIC;
 BEGIN
   IF COALESCE(dokunr,0)=0 THEN
        RETURN 0;
   END IF;

   summe:=0;
   summe_netto:=0;

   FOR r in
       SELECT
          sum(ldaz_anz*ldaz_betr) AS abzupos_netto,
          sum(ldaz_anz*ldaz_betr*(ldaz_steuproz/100+1)) AS abzupos_brutto,
          IFTHEN(BASIS_W,ldsdok_pos_wert_basis_w(ld_id),ldsdok_pos_wert(ld_id)) as pos_netto,
          ld_steuproz
       FROM ldsdok
       LEFT JOIN ldsabzu ON ld_id=ldaz_ld_id
       WHERE ld_dokunr=dokunr AND NOT ld_storno
       GROUP BY ld_id,ld_steuproz
    LOOP
       summe_netto:=summe_netto+r.pos_netto;
       summe:=summe+COALESCE(r.abzupos_brutto,0)+(r.pos_netto-COALESCE(r.abzupos_netto,0))*(r.ld_steuproz/100+1);
   END LOOP;

   IF NOT brutto THEN
        summe:=summe_netto;
   END IF;
   RETURN CAST(COALESCE(summe,0) AS NUMERIC(12,2));
 END$$LANGUAGE plpgsql STABLE;

 CREATE OR REPLACE FUNCTION sum_ldsdok_dokunr_werech(IN dokunr INTEGER, IN BASIS_W BOOLEAN DEFAULT FALSE) RETURNS NUMERIC AS $$
 DECLARE summe NUMERIC;
 BEGIN
   IF COALESCE(dokunr,0)=0 THEN
        RETURN 0;
   END IF;
   IF BASIS_W THEN
        summe:= COALESCE(SUM(belp_netto_basis_w) ,0)
                FROM ldsdok JOIN belegpos ON belp_ld_id=ld_id
                WHERE ld_dokunr=dokunr;
   ELSE
        summe:= COALESCE(SUM(belp_netto) ,0)
                FROM ldsdok JOIN belegpos ON belp_ld_id=ld_id
                WHERE ld_dokunr=dokunr;
   END IF;
   RETURN COALESCE((summe),0);
 END$$LANGUAGE plpgsql STABLE;


CREATE OR REPLACE FUNCTION ldsdok__lief_rech_data(IN ldid INTEGER, OUT liefNrDat TEXT, OUT liefRechDone BOOLEAN, OUT rechAnzNr VARCHAR(50), OUT rechNrDat TEXT, OUT rechDone BOOLEAN) AS $$
DECLARE
 anz INTEGER;
 rechNr VARCHAR(50);
BEGIN
  --Letzte Wareneingangsnumer und Datum
  SELECT CAST(w_wen AS VARCHAR) || e'\n' ||COALESCE(to_char(w_zug_dat, 'DD.MM.YY'), ''), COALESCE(w_rech_eing, false)
      INTO liefNrDat, liefRechDone
  FROM wendat
  WHERE w_lds_id = ldid
  ORDER BY w_wen DESC LIMIT 1;

  --Letzte Eingangsrechnung und Datum
  SELECT
    beld_dokunr, beld_dokunr || e'\n' ||COALESCE(to_char(beld_erstelldatum, 'DD.MM.YY'), ''), beld_verbucht
    INTO rechNr, rechNrDat, rechDone
  FROM eingrech JOIN eingrech_pos ON belp_dokument_id = beld_id
  WHERE belp_ld_id = ldid
  ORDER BY beld_dokunr DESC LIMIT 1;
  --
  SELECT count(1) INTO anz FROM wendat WHERE w_lds_id = ldid;
  liefNrdat := '[' || CAST(anz AS VARCHAR) || '] ' || liefNrdat;
  SELECT count(1) INTO anz FROM eingrech JOIN eingrech_pos ON belp_dokument_id = beld_id WHERE belp_ld_id = ldid GROUP BY beld_dokunr;
  rechNrdat := '[' || CAST(anz AS VARCHAR) || '] ' || rechNrdat;
  rechanznr := '[' || CAST(anz AS VARCHAR) || '] ' || rechNr;
  --
  RETURN;
END $$ LANGUAGE plpgsql STABLE;


--Ab- und Zuschlaege zu einer Bestellung
CREATE TABLE ldsabzu (                                                                       -- VIEWFELDER
  ldaz_id            SERIAL PRIMARY KEY,                                                       -- ID des Zuschlags
  ldaz_type          VARCHAR(1)  DEFAULT 'E',                                                  -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
  ldaz_pos           INTEGER,                                                                  -- Position
  ldaz_abz_id        INTEGER NOT NULL REFERENCES abzu,                                         -- ID der Vorgabe
  ldaz_ld_id         INTEGER NOT NULL REFERENCES ldsdok ON UPDATE CASCADE ON DELETE CASCADE,   -- ID des Datensatzes an dem der Zuschlag hängt
  ldaz_anz           NUMERIC(12,4) NOT NULL DEFAULT 1,                                         -- Anzahl / Menge
  ldaz_betr          NUMERIC(12,4) NOT NULL DEFAULT 0,                                         -- Betrag in Währung des Parent-Datensatzes
  ldaz_proz          NUMERIC(12,4),                                                            -- Prozentualer Zuschlag auf Basis des Parent-Betrags
  ldaz_canSkonto     BOOLEAN NOT NULL DEFAULT TRUE,                                            -- Gilt Skonto für den Zuschlag?
  ldaz_steucode      INTEGER REFERENCES steutxt,                                               -- Steuercode (meist gleich Parent)
  ldaz_steuproz      NUMERIC(5,2) NOT NULL DEFAULT 0,                                          -- Prozentsatz der Steuer
  ldaz_konto         VARCHAR(25),                                                              -- Kontierung
  ldaz_visible       BOOLEAN NOT NULL DEFAULT TRUE,                                            -- Auf Dokument sichtbar oder nicht?
  ldaz_zutxt         TEXT,                                                                     -- Zusätzlicher Hinweistext
  ldaz_zutxt_rtf     TEXT,                                                                     -- Zusätzlicher Hinweistext (RTF)
  ldaz_zutxt_int     TEXT,                                                                     -- Interner zusatztext (erscheint nicht auf Dokumenten)
  ldaz_source_table  VARCHAR(40),                                                              -- Aus welcher Quelle wurde Abzu hierhin kopiert
  ldaz_source_dbrid  VARCHAR(32),                                                              -- Aus welchem Datensatz wurde Abzu hierhin kopiert
  --                                                                                         -- ZUSATZFELDER
  ldaz_done          BOOLEAN NOT NULL DEFAULT FALSE,                                           -- Gesamte Zuschlag wurde in eine Rechnung weitergegeben
  CHECK (ldaz_proz <> 0)   --ldsabzu_ldaz_proz_check
  );
--

-- Quell-Zuschläge mit Typ 'E' werden erledigt gesetzt bei Übernahme aus Rahmen
 --DROP FUNCTION IF EXISTS ldsabzu__a10_iud_srcabzu_done() CASCADE;
CREATE OR REPLACE FUNCTION ldsabzu__a10_iud_srcabzu_done() RETURNS TRIGGER AS $$
 BEGIN

  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    IF (new.ldaz_source_table='ldsabzu') AND (new.ldaz_type = 'E')  THEN
      PERFORM TWawi.Abzu_Set_Done(new.ldaz_source_table, new.ldaz_source_dbrid, TRUE, TRUE);
    END IF;
  ELSE
    IF (old.ldaz_source_table='ldsabzu') AND (old.ldaz_type = 'E')THEN
      -- TODO: Raise Notice beim wieder öffnen
      PERFORM TWawi.Abzu_Set_Done(old.ldaz_source_table, old.ldaz_source_dbrid, FALSE, TRUE);
   END IF;
  END IF;

  RETURN new;
 END $$ LANGUAGE plpgsql;
--
CREATE TRIGGER ldsabzu__a10_iud_srcabzu_done
 AFTER INSERT OR UPDATE OR DELETE
 ON ldsabzu
 FOR EACH ROW
 EXECUTE PROCEDURE ldsabzu__a10_iud_srcabzu_done();
--

-- Posistions-Werte neu bestimmen, warnen wenn Steuersatz ungültig ist.
CREATE OR REPLACE FUNCTION ldsabzu__a_iud() RETURNS TRIGGER AS $$
 DECLARE
 _ldsabzu RECORD; --?
        I INTEGER; --?
    _ldsid INTEGER;
 BEGIN
  /*----------------BEACHTEN-----------------------------------------------------------------------------------------------------------------------------------
    Wenn ldsdok-Updates entfallen sollten, "UPDATE ldsdok SET ld_netto = 0 WHERE ld_id = new/old.ldaz_ld_id" ausführen, damit Positionssumme aktualisiert wird.
   ------------------------------------------------------------------------------------------------------------------------------------------------------------*/
  --
  IF tg_op='DELETE' THEN
        _ldsid := old.ldaz_ld_id;
  ELSE
        _ldsid := new.ldaz_ld_id;
  END IF;
  --
  PERFORM tcache.function_cache_setdirty_1param('ldsdok_pos_wert_calc', _ldsid);
  --PERFORM tcache.function_cache_setdirty_1param('sum_ldsdok_dokunr', ld_dokunr) FROM ldsdok WHERE ld_id=_ldsid; gibt es keine cache

  -- Aktualisierung Positionssummen ldsdok
  IF TG_OP = 'UPDATE' THEN
        UPDATE ldsdok
           SET ld_netto = 0
         WHERE ld_id = _ldsid
           AND NOT (new.ldaz_betr <> old.ldaz_betr AND new.ldaz_proz IS NOT NULL);
        -- Bei Änderung des Betrag von außen (siehe ldsdok__b_iu), wenn prozentualer Abzu, dann KEINE Aktualiserung der ldsdok starten.
        -- Wenn Prozentsatz des Abzu geändert wird, findet Berechnung des Betrags hiermit in ldsdok__b_iu statt - läuft wieder hier hinein (UPDATE) und ignoriert Kreisaufruf durch Bedingung.
  ELSE -- INSERT, DELETE
        UPDATE ldsdok
           SET ld_netto = 0
         WHERE ld_id = _ldsid;
  END IF;

  --Meldung ausgeben,wennn Steuersatz ungültig
  IF NOT tg_op = 'DELETE' THEN
        IF new.ldaz_steucode = (SELECT steu_z FROM steutxt WHERE steu_z=new.ldaz_steucode AND steu_valid_to<current_date) THEN
                PERFORM PRODAT_TEXT(15810);
        END IF;
  END IF;

  IF tg_op = 'DELETE' THEN
    RETURN old;
  ELSE --INSERT, UPDATE
    IF current_user <> 'syncro' THEN
      IF new.ldaz_konto IS NULL AND TSystem.Settings__GetBool('lds_konto_required') THEN
        RAISE EXCEPTION 'null value in not-null "ldaz_konto"';
      END IF;
    END IF;
    RETURN new;
  END IF;
 END $$ LANGUAGE plpgsql;


 CREATE TRIGGER ldsabzu__a_iud
  AFTER INSERT OR UPDATE OR DELETE
  ON ldsabzu
  FOR EACH ROW
  EXECUTE PROCEDURE ldsabzu__a_iud();
--

-- Falls Steuersatz leer ist, aus Position übernehmen. Nur relevant, wenn per SQL angelegt wird. Die Delphi-Klasse macht das auch.
CREATE OR REPLACE FUNCTION ldsabzu__b_iu() RETURNS TRIGGER AS $$
 DECLARE
  steucode INTEGER;
  steuproz NUMERIC;
 BEGIN
  IF (new.ldaz_steucode IS NULL) OR (new.ldaz_steuproz IS NULL) THEN
    SELECT COALESCE(new.ldaz_steucode, ld_steucode), COALESCE(new.ldaz_steuproz,ld_steuproz) INTO new.ldaz_steucode, new.ldaz_steuproz
    FROM ldsdok
    WHERE ld_id = new.ldaz_ld_id;
  END IF;
  RETURN new;
 END $$ LANGUAGE plpgsql;

--
CREATE TRIGGER ldsabzu__b_iu
 BEFORE INSERT OR UPDATE
 ON ldsabzu
 FOR EACH ROW
 EXECUTE PROCEDURE ldsabzu__b_iu();
--

-- Teillieferungen zur einer Bestellposition
CREATE TABLE ldslieferung(
    ldl_id              SERIAL PRIMARY KEY,
    ldl_ld_id           INTEGER NOT NULL REFERENCES ldsdok ON UPDATE CASCADE ON DELETE CASCADE,
    ldl_stk             NUMERIC(12,4) NOT NULL DEFAULT 0, -- Anzahl
    ldl_stkl            NUMERIC(12,4) NOT NULL DEFAULT 0, -- Anzahl geliefert (beides in ME der Bestellposition)
    ldl_term            DATE,                             -- Liefertermin
    ldl_terml           DATE,                             -- Bestätigter Liefertermin
    ldl_done            BOOLEAN NOT NULL DEFAULT FALSE,   -- Erledigt Kennzeichen
    ldl_restpos         BOOLEAN NOT NULL DEFAULT FALSE,   -- Automatisch angelegte Restposition (Differenz aus Bestellposition und Teillieferungen)
    ldl_txt             TEXT,
    ldl_txt_rtf         TEXT
);



  -- Berechnen und aktualisieren der Restposition
  CREATE OR REPLACE FUNCTION ldslieferung_update_restpos(IN ldid INTEGER) RETURNS VOID AS $$
   DECLARE r       RECORD;
           rows    INTEGER;
   BEGIN

    -- Übergebliebene Restposition, die nehmen wir raus - es gibt keine Teillieferungen (mehr)
    IF NOT EXISTS (SELECT true FROM ldslieferung WHERE ldl_ld_id = ldid AND NOT ldl_restpos) THEN
      DELETE FROM ldslieferung WHERE ldl_ld_id = ldid AND ldl_restpos;
      RETURN;
    END IF;


    SELECT TEinkauf.Sum_Teillieferung(ldid) as ldl_stk, ld_stk, ld_stkl, ld_term, ld_terml INTO r
      FROM ldsdok WHERE ld_id = ldid;

    -- Restmenge <= 0, dann Restposition rausnehmen
    IF (r.ld_stk - r.ldl_stk) <= 0 THEN
      DELETE FROM ldslieferung WHERE ldl_ld_id = ldid AND ldl_restpos;
      RETURN;
    END IF;

    -- Restdatensatz aktualisieren ...
    UPDATE ldslieferung SET ldl_stk = (r.ld_stk - r.ldl_stk), ldl_term = r.ld_term, ldl_terml = r.ld_terml WHERE ldl_ld_id = ldid AND ldl_restpos;
    GET DIAGNOSTICS rows = ROW_COUNT;

    IF rows = 0 THEN -- ... oder anlegen, falls es noch keinen gab.
      INSERT INTO ldslieferung (ldl_ld_id, ldl_stk, ldl_stkl, ldl_term, ldl_terml,ldl_restpos,ldl_txt)
        SELECT ldid, (r.ld_stk - r.ldl_stk), 0, r.ld_term, r.ld_terml, true, lang_text(13241);
    END IF;

    RETURN;
   END $$ LANGUAGE plpgsql VOLATILE RETURNS NULL ON NULL INPUT;
  --



  -- Berechnen der Aufteilung der Liefermenge auf Bestellposition
  CREATE OR REPLACE FUNCTION ldslieferung_update_stkl(IN ldid INTEGER) RETURNS VOID AS $$
   DECLARE ldsrec  RECORD;
         ldlrec  RECORD;
         stkrest NUMERIC;
         stkl    NUMERIC;
   BEGIN

    SELECT ld_stkl, ld_done INTO ldsrec FROM ldsdok WHERE ld_id = ldid;
    stkrest:= ldsrec.ld_stkl; -- Noch aufzuteilende Menge

    PERFORM disablemodified(); -- Über Teillieferungen laufen und bereits gelieferte Bestellmenge fortlaufend aufteilen

    FOR ldlrec IN (SELECT ldl_id, ldl_ld_id, ldl_stk FROM ldslieferung WHERE ldl_ld_id = ldid ORDER BY COALESCE(ldl_terml,ldl_term,current_date), ldl_id) LOOP

      stkl := MIN(ldlrec.ldl_stk, stkrest); -- Entweder volle Teillieferungsmenge oder nur den Rest der schon auf die ldsdok-pos. gelieferten Menge

      UPDATE ldslieferung SET
        ldl_stkl = stkl,
        ldl_done = ldsrec.ld_done OR (stkl >= ldlrec.ldl_stk)
      WHERE ldl_id = ldlrec.ldl_id
         AND ( ( ldl_stkl <> stkl ) OR (ldl_done <> ldsrec.ld_done OR (stkl >= ldlrec.ldl_stk)));

      stkRest:=stkRest - stkl;

    END LOOP;
    PERFORM enablemodified();
    RETURN;
   END $$ LANGUAGE plpgsql VOLATILE RETURNS NULL ON NULL INPUT;
  --

  -- Liefermengen- / Restpositionen updaten / Bedarfsberechnung
  CREATE OR REPLACE FUNCTION ldslieferung__a_iu() RETURNS TRIGGER AS $$
   DECLARE aknr          VARCHAR;
   BEGIN

    --RAISE NOTICE 'ENTER ID: %, LD_ID: %, STK: %, RestPos: % ', new.ldl_id, new.ldl_ld_id, new.ldl_stk, new.ldl_restpos;

    -- Die Restposition wird immer aktualisiert
    PERFORM ldslieferung_update_restpos(new.ldl_ld_id);

    --Nachziehen der Liefermengen
    IF (tg_op = 'INSERT') AND ((new.ldl_stk > 0 ) OR (new.ldl_stkl >0 )) THEN
        PERFORM ldslieferung_update_stkl(new.ldl_ld_id); -- Aufteilung der Liefermengen neu durchrechnen
    END IF;

    IF (tg_op = 'UPDATE') THEN
      IF (old.ldl_stk <> new.ldl_stk) OR (old.ldl_stkl <> new.ldl_stkl) THEN
        PERFORM ldslieferung_update_stkl(new.ldl_ld_id); -- Aufteilung der Liefermengen neu durchrechnen
      END IF;
    END IF;



    -- Verfügbarkeitsberechnung anstoßen da sich Liefertermine und Liefermengen geändert haben können
    SELECT ld_aknr INTO aknr FROM ldsdok WHERE ld_id = new.ldl_ld_id;
    PERFORM tartikel.prepare_artikel_bedarf(aknr, false);

   --RAISE NOTICE 'EXIT: ID: %, LD_ID: %, STK: %, RestPos: % ', new.ldl_id, new.ldl_ld_id, new.ldl_stk, new.ldl_restpos;
    RETURN new;
   END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldslieferung__a_iu
   AFTER INSERT OR UPDATE
   ON ldslieferung
   FOR EACH ROW
   WHEN (NOT new.ldl_restpos)
   EXECUTE PROCEDURE ldslieferung__a_iu();
  --

  --
  CREATE OR REPLACE FUNCTION ldslieferung__a_d() RETURNS TRIGGER AS $$
   DECLARE aknr          VARCHAR;
   BEGIN

    -- Die Restposition wird immer aktualisiert
    PERFORM ldslieferung_update_restpos(old.ldl_ld_id);

    -- Nachziehen der Liefermengen
    PERFORM ldslieferung_update_stkl(old.ldl_ld_id); -- Aufteilung der Liefermengen neu durchrechnen

    -- Verfügbarkeitsberechnung anstoßen da sich Liefertermine und Liefermengen geändert haben können
    SELECT ld_aknr INTO aknr FROM ldsdok WHERE ld_id = old.ldl_ld_id;
    IF aknr IS NOT NULL THEN
      PERFORM tartikel.prepare_artikel_bedarf(aknr, false);
    END IF;

   RETURN old;
   END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER ldslieferung__a_d
   AFTER DELETE
   ON ldslieferung
   FOR EACH ROW
   WHEN (NOT old.ldl_restpos)
   EXECUTE PROCEDURE ldslieferung__a_d();
  --

 --
 CREATE OR REPLACE FUNCTION ldslieferung__as__a_iud() RETURNS TRIGGER AS $$
  BEGIN
   PERFORM do_artikel_bedarf();
   RETURN NULL;
  END $$ LANGUAGE plpgsql;
 --
 CREATE TRIGGER ldslieferung__as__a_iud
  AFTER INSERT OR UPDATE OR DELETE
  ON ldslieferung
  FOR EACH STATEMENT
  EXECUTE PROCEDURE ldslieferung__as__a_iud();
 --

--

--
-- ************************** Terminverschiebungen für Bestellungen (Einkauf) UND Aufträge (Verkauf)! ******************************
 CREATE TABLE terminverschiebung (
    tver_id               SERIAL PRIMARY KEY,

    -- betroffenes Artefakt
    tver_kategorie_enum   text,
    tver_ld_id            INTEGER REFERENCES ldsdok ON DELETE CASCADE,
    tver_ag_id            INTEGER REFERENCES auftg ON DELETE CASCADE,

    -- der ursprüngliche, nun nicht mehr aktuelle Termin
    tver_termin_alt       DATE NOT NULL,

    -- der nun neu vereinbarte Termin
    tver_termin_neu       DATE,

    -- der Grund für diese Terminverschiebung
    tver_ursache_enum     text,

    -- enthält ggf. Verweis auf die auslösende Terminverschiebung
    tver_ursache_tver_id  INTEGER REFERENCES terminverschiebung,

    -- welche Partei(en) haben die Terminverschiebung verursacht?
    tver_verursacher_enum text,

    -- was sind die Folgen der TErminverschiebung?
    tver_auswirkung_enum  text,

    -- wer hat über das weitere Vorgehen entschieden?
    tver_entscheider_enum text,

    -- was es sonst noch zu der Terminverschiebung zu sagen gibt
    tver_bemerkung_txt    text

    -- Tabelle, in der das betroffene Artefakt gespeichert ist
    -- tver_tabelle       VARCHAR(32),

    -- ID des betroffenen Artefakts
    -- tver_dbrid       VARCHAR(30),
 );

 CREATE INDEX terminverschiebung__ldl_ld_id ON terminverschiebung(tver_ld_id);

-- automatische Übernahme von ldsdok
-- #13325, #13286 die TV-Kategorie wird nicht mehr automatisch gesetzt,
--   Änderungen des bestätigten und u.U. des geplanten Datums führen auch zur Anlage einer Terminverschiebung,
--   die Funktionen des Anwendungsfalls werden in einem Trigger zusammengefasst
CREATE OR REPLACE FUNCTION ldsdok__a_50_u__terminverschiebung() RETURNS TRIGGER AS $$
  DECLARE
      _term_alt               date;
      _term_neu               date;
      _datum_nicht_bestaetigt boolean;
      _term_bemerkung         varchar = '';
      _geaendert              boolean = false;
  BEGIN

      -- Terminverschiebungen nur für externe Bestellungen interessant https://redmine.prodat-sql.de/issues/15222
      IF
            new.ld_dokunr IS null
         OR new.insert_date = current_date
      THEN
          RETURN new;
      END IF;

      _datum_nicht_bestaetigt :=
            new.ld_terml IS null
        AND new.ld_termweekl IS null
        AND new.ld_termv IS null;

      -- verschobener Liefertermin: wird entweder erneut verschoben, oder bisher gab es nur den Wunschtermin,
      -- welchen wir als bestätigt betrachten und es wird sofort ein Termin verschoben eingetragen.
      IF
          old.ld_termv IS DISTINCT FROM new.ld_termv
      THEN
          _term_alt :=
              coalesce(
                  old.ld_termv,
                  old.ld_terml,
                  termweek_to_date( old.ld_termweekl ),
                  old.ld_term,
                  termweek_to_date( old.ld_termweek )
              )
          ;

          _term_neu := new.ld_termv;
          -- verschoben
          _term_bemerkung := _term_bemerkung || lang_text( 28929 );
          _geaendert := true;
      END IF;

      -- bestätigter Termin wird verschoben
      IF
             old.ld_terml IS DISTINCT FROM new.ld_terml
         AND NOT _geaendert
      THEN
          _term_alt := old.ld_terml;
          _term_neu := new.ld_terml;
          -- bestätigt
          _term_bemerkung := _term_bemerkung || lang_text( 28930 );
          _geaendert := true;
      END IF;

      -- bestätigter Wochentermin wird verschoben
      IF
            old.ld_termweekl IS DISTINCT FROM new.ld_termweekl
        AND NOT _geaendert
      THEN
          _term_alt := termweek_to_date( old.ld_termweekl );
          _term_neu := termweek_to_date( new.ld_termweekl );
          -- bestätigt
          _term_bemerkung := _term_bemerkung || lang_text( 28930 );
          _geaendert := true;
      END IF;

      -- geplanter Termin wird verschoben, nur ohne bestätigten Termin interessant
      IF
            old.ld_term IS DISTINCT FROM new.ld_term
        AND _datum_nicht_bestaetigt
        AND NOT _geaendert
      THEN
          _term_alt := old.ld_term;
          _term_neu := new.ld_term;
          -- geplant
          _term_bemerkung := _term_bemerkung || lang_text( 28931 );
          _geaendert := true;
      END IF;

      -- geplanter Wochentermin wird verschoben, nur ohne bestätigten Termin interessant
      IF
            old.ld_termweek IS DISTINCT FROM new.ld_termweek
        AND _datum_nicht_bestaetigt
        AND NOT _geaendert
      THEN
          _term_alt := termweek_to_date( old.ld_termweek );
          _term_neu := termweek_to_date( new.ld_termweek );
          -- geplant
          _term_bemerkung := _term_bemerkung || lang_text( 28931 );
      END IF;

      -- Terminverschiebung wird nur gespeichert, wenn wirklich etwas verschoben wurde
      IF
            _term_alt IS NOT null
        AND _term_alt IS DISTINCT FROM _term_neu
      THEN
          INSERT INTO terminverschiebung( tver_ld_id, tver_termin_alt, tver_termin_neu, tver_bemerkung_txt )
          VALUES                        ( new.ld_id,  _term_alt,        _term_neu,      _term_bemerkung    );

          PERFORM prodat_hint(
              concat(
                  --Neue Terminverschiebung
                  lang_text( 28959 ),
                  ': ',
                  _term_alt,
                  ' -> ',
                  coalesce(
                      _term_neu::varchar,
                      --unbestimmter Termin
                      lang_text( 28945 )
                  ),
                  ' - ',
                  _term_bemerkung
              )
          );
      END IF;

      RETURN new;
  END $$ LANGUAGE plpgsql;


  CREATE TRIGGER ldsdok__a_50_u__terminverschiebung
    AFTER UPDATE
    OF ld_termv, ld_terml, ld_termweekl, ld_term, ld_termweek
    ON ldsdok
    FOR EACH ROW
    -- Terminverschiebungen nur für externe Bestellungen interessant
    WHEN ( new.ld_code = 'E' )
    EXECUTE PROCEDURE ldsdok__a_50_u__terminverschiebung();
--

--
CREATE TABLE lbw
  (lb_note              INTEGER PRIMARY KEY,
   lb_bez               VARCHAR(50),
   lb_punkte            INTEGER NOT NULL DEFAULT 0, --Punkte für diese Bewertung. 100=volle Punktzahl(ohne Mängel) 0=totalschaden
   lb_sperr             BOOL NOT NULL DEFAULT FALSE, --Wenn Wahr, wird Artikel für Lagereingang gesperrt
   lb_makeqab           BOOL NOT NULL DEFAULT FALSE  --Wenn Wahr, wird automatisch Qualitäts.bericht erstellt
  );
--

--
CREATE TABLE lbwwe (
  lbwwe_id INTEGER PRIMARY KEY,
  lbwwe_bez VARCHAR(50),
  lbwwe_punkte INTEGER NOT NULL DEFAULT 0,
  lbwwe_abw INTEGER NOT NULL
);
--

--
CREATE TABLE lbwnote
  (lbn_note             VARCHAR PRIMARY KEY,
   lbn_bpunkte          INTEGER NOT NULL --diese Note gibt es bis Punkte
  );
--

--
CREATE TABLE epreiskat (
  -- m:n-Tablle für die Bezeihung Lieferant - Lieferantenkategorie

  ek_id         SERIAL PRIMARY KEY,

  -- Ticket 14795, Absicherung der Beziehung Lieferant-Kategorie durch FKEY
  ek_awk_bez    VARCHAR(50) NOT null, -- ref auf auswkategorie

  ek_ad_krz     VARCHAR(21) NOT null
      REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE

);
--


--
CREATE TABLE rahmenlieferant--rahmenverträge
  (rhl_nr               VARCHAR(30) NOT NULL PRIMARY KEY,                        -- Ist zusammengesetzt aus ld_auftg||'/'||ld_pos.
   rhl_krz              VARCHAR(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,
   rhl_vtr_nr           VARCHAR(40),--REFERNCES vertrag (X Constraints)
   rhl_ak_ac            VARCHAR(9),--REFERENCES artcod (X)
   rhl_ak_nr            VARCHAR(40) REFERENCES art ON UPDATE CASCADE,
   rhl_mgc              INTEGER REFERENCES artmgc ON UPDATE CASCADE,
   rhl_stk              NUMERIC(12,2),
   rhl_stk_uf1          NUMERIC(12,4),
   rhl_ep               NUMERIC(12,4),
   rhl_rab              NUMERIC(5,2),
   rhl_wert             NUMERIC(12,2),
   --rhl_proz           NUMERIC(5,2),
   rhl_datv             DATE,
   rhl_datb             DATE,
   rhl_done             BOOL NOT NULL DEFAULT FALSE,
   rhl_txt              TEXT,
   rhl_kond             TEXT
  );

  CREATE INDEX rahmenlieferant_ak_nr        ON rahmenlieferant (rhl_ak_nr);
  CREATE INDEX rahmenlieferant_rhl_krz      ON rahmenlieferant (rhl_krz);
  CREATE INDEX rahmenlieferant_rhl_krz_like ON rahmenlieferant (rhl_krz varchar_pattern_ops);

 CREATE OR REPLACE FUNCTION rahmenlieferant__b_iu() RETURNS TRIGGER AS $$
 BEGIN
  new.rhl_stk_uf1:=tartikel.me__menge__in__menge_uf1(new.rhl_mgc, new.rhl_stk);
  IF new.rhl_ak_nr IS NOT NULL THEN
        new.rhl_ak_ac:=ak_ac FROM art WHERE ak_nr=new.rhl_ak_nr;
  END IF;
  --
  IF tg_op='UPDATE' THEN
        IF new.rhl_done AND NOT old.rhl_done THEN
                PERFORM msg_SendMsg(CAST(current_user AS VARCHAR), 'Rahmenbestellung', 'Rahmenbestellung erledigt :'||new.rhl_nr, CAST(current_user AS VARCHAR));
        END IF;
  END IF;
  --
  RETURN new;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER rahmenlieferant__b_iu
 BEFORE INSERT OR UPDATE
 ON rahmenlieferant
 FOR EACH ROW
 EXECUTE PROCEDURE rahmenlieferant__b_iu();


 --"Passendste" Rahmenvertragsnummer zu einem Lieferanten suchen, Alternativlieferanten und Rahmen suchen
 CREATE OR REPLACE FUNCTION checkrahmen_ldsdok(
                                        IN krz  VARCHAR,                        -- Lieferant bei dem wir einen Rahmen suchen (kann NULL oder '' sein)
                                        IN aknr VARCHAR,                        -- Artikelnummer für die wir einen Rahmen suchen
                                        --IN ac   VARCHAR,                      -- Artikelcode (obsolet, wird nicht mehr unterstützt (LG, 02 / 2014))
                                        --
                                        OUT _rahmen_ld_id       INTEGER,        -- LD_ID der Rahmenposition
                                        OUT _lieferant          VARCHAR,        -- Lieferant bei dem wir Rahmen gefunden haben
                                        OUT _rahmennr           VARCHAR(30),    -- Nummer des Rahmenvertrag (in Tabellle Rahmenlieferant)
                                        OUT _preis              NUMERIC,
                                        OUT _rabatt             NUMERIC,
                                        OUT _mgc                INTEGER,
                                        OUT _ld_bem             VARCHAR(50),    -- Bemerkung zum Rahmenvertrag
                                        OUT _isDiffRahmen       BOOLEAN,        -- True, wenn wir nach Rahmen bei bestimmten Lieferant gesucht haben und dort keiner gefunden wurde.
                                                                                -- Dann bezieht sich der zurückgegebene Satz auf den ersten Alternativlieferanten wo es einen Rahmen gab.
                                                                                -- False, wenn Rahmen von gewünschtem Lieferant stammt oder kein Lieferant angegeben war
                                        OUT _hasAbzu            BOOLEAN,        -- Flag, ob Ab- und Zuschläge am Rahmenvertrag hängen
                                        OUT _EkLos              NUMERIC(12,4),  -- Losgröße aus Rahmenbestellung, wird in Abruf weitergegeben
                                        OUT _alternativen VARCHAR(200)   -- Text der eventuelle Alternativrahmen enthält
 ) RETURNS RECORD AS $$
 DECLARE rec    RECORD;
        pos     INTEGER;
 BEGIN

  rec:=NULL;
  pos:=0;

  -- Suche aller Rahmen zum Artikel ...
  FOR rec IN (SELECT rhl_krz, rhl_nr, rhl_ep, rhl_rab, rhl_mgc, rhl_datb, ld_id, ld_bem, ld_eklos
              FROM rahmenlieferant JOIN ldsdok ON ( (ld_code='R' OR ld_code='E') AND (ld_auftg || '/' || ld_pos) = rhl_nr)
              WHERE  ( NOT rhl_done) AND ( rhl_ak_nr = COALESCE(aknr,''))
              ORDER BY COALESCE(KRZ,'') = rhl_krz DESC, rhl_datb ) LOOP         -- ... den beim Wunschlieferant als erstes, falls einer angegeben war

    IF (Pos=0) THEN -- Den Rahmen schlagen wir vor.
      _rahmen_ld_id :=rec.ld_id;
      _lieferant:= rec.rhl_krz;
      _rahmennr := rec.rhl_nr;
      _preis    := rec.rhl_ep;
      _rabatt   := rec.rhl_rab;
      _mgc      := rec.rhl_mgc;
      _ld_bem   := rec.ld_bem;
      _EkLos    := rec.ld_eklos;
      -- Wir wollten bei bestimmten Lieferanten, haben aber nur anderen gefunden ... markieren, dass das nicht der eigentlich gesuchte Rahmen ist.
      _isDiffRahmen:= (COALESCE(krz,'') <> '' ) AND (krz <> rec.rhl_krz);

      --Prüfen ob das Ab- und Zuschläge dranhängen
      SELECT true INTO _hasAbzu FROM ldsabzu WHERE ldaz_ld_id = _rahmen_ld_id;
    END IF;

    IF (Pos>0) THEN
      IF (_alternativen IS NOT NULL) THEN -- Lieferantenkürzel und Rahmenvertragsnummer anzeigen, getrennt durch |
        _alternativen := _alternativen || ', ';
      END IF;
      _alternativen := COALESCE(_alternativen,'') || 'L: ' || rec.rhl_krz || ' (R-Nr: ' || rec.rhl_nr || ')';
    END IF;

    pos:=pos+1;

  END LOOP;

  RETURN;
 END $$ LANGUAGE plpgsql STABLE;
--


--Lieferantendaten bzw. Lieferantepreise
CREATE TABLE epreis (
  e_id                              serial PRIMARY KEY,
  e_aknr                            varchar(40) NOT NULL REFERENCES art ON UPDATE CASCADE,  -- Einzukaufender Artikel oder Dienstleistung (APaket "Glühen")
  e_fertaknr                        varchar(40) REFERENCES art ON UPDATE CASCADE,           -- Bei APaket "Glühen", zu glühender Artikel zur genaueren Unterteilung von Auswärtskosten nach Fertigungsartikel
  e_lkn                             varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,
  e_best                            varchar(40), --Eigentlich Art.Nummer des Lieferanten. Bisher gelegentlich für ABK-Index aus zurückschreiben NK benutzt.
  e_herkunft                        varchar(120), --Woher kommt der Preis? NK auf ABK? Eingangsrechnung? Anfrage? <= LG, Mai 2012, eigentlich veraltet, die Preise kommen nicht mehr aus NK / Eingrech.
  e_preis                           numeric(16,4)  NOT NULL DEFAULT 0,       -- Preis unter Berücksichtung der Preiseinheit, Bsp: 4,99 pro 100 Stk. => http://redmine.prodat-sql.de/issues/6447
  e_preiseinheit                    numeric(14,4)  NOT NULL DEFAULT 1 CONSTRAINT epreis__chk__preiseinheit CHECK ( e_preiseinheit > 0),      -- Menge, auf die sich die Preisangabe bezieht, Bsp: 100 Stk.
  e_ep                              numeric(20,8) NOT NULL DEFAULT 0,       -- Preis pro Mengeneinheit. Bsp: 0,0499
  e_ep_uf1                          numeric,                                -- Preis in Grundmengeneinheit
  e_ep_uf1_basis_w                  numeric,                                -- Preis in Eigenwährung und Grundmengeneinheit
  e_waer                            varchar(3) NOT NULL DEFAULT TSystem.Settings__Get('BASIS_W') REFERENCES bewa,
  e_rab                             numeric,
  e_stk                             numeric NOT NULL DEFAULT 1,             -- Das ist die Losgröße. Preis versteht sich pro Stück ist also NICHT auf die Losgröße bezogen (bzw. pro 1 ME)
  e_stk_uf1                         numeric,                                -- Das ist die Losgröße in Grundmengeneinheit.
  e_rahmen_stk                      numeric(12,6),                          -- Rahmenvertragsmenge, die Lieferant erwartet. e_stk ist dann das Abruflos.
  e_mcv                             integer NOT NULL REFERENCES artmgc,
  e_lfzt                            integer NOT NULL DEFAULT TSystem.Settings__GetInteger('EK_Lieferfrist_Default', 1),
  e_gdatum                          date DEFAULT current_date,
  e_bisdatum                        date,
  e_stal                            boolean DEFAULT false, --Standard-/Stammlieferant
  e_lkn_lg_anztot                   numeric(12,4),                          -- Beim Lieferanten lagernde Menge
  e_preis_last_updatetime           timestamp,                              -- Zeitpunkt wann Preis zuletzt aktualisiert wurde
  e_url                             varchar,                                -- URL zur Produktseite des Lieferanten
  -- #15071 Statusfeld für bspw. Ablage eines fixierten Stammlieferanten
  e_stat                            varchar(40),
  e_bewer                           integer REFERENCES lbw,
  e_txt                             text,
  e_txt_rtf                         text,
  -- ACHTUNG: _abzu-Spalten INKL Rabatt (Siehe Berechnung ag_ep_netto)
  e_ep_uf1_basis_w_abzu             numeric(12,4),  -- mit Rabatt und Ab/Zuschlägen, ohne Steuern. Alle Abzuschläge, auch solche die NICHT in Selbstkosten kommen, siehe https://ci.prodat-sql.de/sources/tests/suite/12/runner/456
  e_ep_uf1_basis_w_abzu_selbstko    numeric(12,4),  -- mit Rabatt und Ab/Zuschlägen (die AUSSCHLIEßLICH in Selbstkosten sollen), ohne Steuern, z.B. für Übergabe an Selbstkosten Artikelstamm
  e_ep_abzu                         numeric(12,4),

  e_kurs                            numeric NOT NULL DEFAULT 1,
  e_folgeap_op_ix                   integer REFERENCES opl ON UPDATE CASCADE ON DELETE CASCADE,
  e_folgeap_op_ix__disabled         boolean NOT NULL DEFAULT false,

  CHECK(e_stk > 0)    -- #12808 Losgröße 0 macht keinen Sinn, daher statt >=0 nur noch >0
  );
--

--
CREATE OR REPLACE FUNCTION epreis__a_iud_keywordsearch() RETURNS TRIGGER AS $$
  DECLARE krz VARCHAR;
  BEGIN
    IF tg_op='DELETE' THEN
        krz:=old.e_aknr;
    ELSE
        krz:=new.e_aknr;
    END IF;
    PERFORM TSystem.kws_create_keywords(art) FROM art WHERE ak_nr=krz;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER epreis__a_iud_keywordsearch
    AFTER INSERT OR DELETE OR UPDATE
    OF e_aknr, e_lkn, e_best
    ON epreis
    FOR EACH ROW
    EXECUTE PROCEDURE epreis__a_iud_keywordsearch();
--

-- Indizes
  CREATE INDEX epreis_ak_nr ON epreis (e_aknr);
  CREATE INDEX epreis_ak_nr_like ON epreis (e_aknr varchar_pattern_ops);

  CREATE INDEX epreis_fertak_nr ON epreis (e_fertaknr);
  CREATE INDEX epreis_fertak_nr_like ON epreis (e_fertaknr varchar_pattern_ops);

  CREATE INDEX epreis_e_lkn      ON epreis (e_lkn);
  CREATE INDEX epreis_e_mcv      ON epreis ( e_mcv );
  CREATE INDEX epreis_e_lkn_like ON epreis (e_lkn varchar_pattern_ops);
--
-- Trigger

  --
  CREATE OR REPLACE FUNCTION epreis__b_01_iu() RETURNS TRIGGER AS $$
    DECLARE updatedat BOOLEAN;
    BEGIN
      new.e_preiseinheit := COALESCE(new.e_preiseinheit,1);

      IF (tg_op = 'INSERT') THEN
        -- Kein manueller Preis angegeben, e_ep vom System irgendwoher gefüllt -> e_preis zurückrechnen.
        IF (new.e_preis = 0) AND (new.e_ep <> 0) THEN
          new.e_preis := new.e_ep * new.e_preiseinheit;
        ELSE -- e_preis wurde angegeben oder alles ist 0
          new.e_ep    := new.e_preis / Do1If0(new.e_preiseinheit);
        END IF;
      END IF;

      IF (tg_op = 'UPDATE' ) THEN
        -- Preis / PE geändert
        IF (new.e_preis IS DISTINCT FROM old.e_preis) OR (new.e_preiseinheit IS DISTINCT FROM old.e_preiseinheit) THEN
            new.e_ep := new.e_preis / Do1If0(new.e_preiseinheit);
        ELSE IF (new.e_ep <> old.e_ep) THEN -- e_ep geändert und Preis / PE gleich -> Preis zurückrechnen.
                 new.e_preis := new.e_ep * new.e_preiseinheit;
             END IF;
        END IF;
      END IF;

      -- Ablaufdatum vorhandener Sätze prüfen
      updatedat:=FALSE;
      IF TG_OP='INSERT' THEN
          updatedat:= new.e_gdatum IS NOT NULL;
      ELSE
          updatedat:= (new.e_gdatum IS DISTINCT FROM old.e_gdatum) AND (new.e_gdatum IS NOT NULL);
      END IF;

      IF updatedat THEN
          -- Lieferant, Artikel, Fertigungsartikel und Losgröße passen => Preis für gleichen Artikel => alten Preis ungültig setzen ab Datum neuem Preis
          UPDATE epreis SET e_bisdatum = new.e_gdatum-1
          WHERE e_aknr = new.e_aknr
            AND e_lkn = new.e_lkn
            AND COALESCE(e_fertaknr,'') = COALESCE(new.e_fertaknr,'')
            AND e_bisdatum IS NULL
            AND e_stk = new.e_stk
            AND coalesce(new.e_herkunft,'') LIKE 'API-%' -- Wenn neuer Preis durch API angelegt wird, dann sollen Bestandspreise nicht verändert werden
            AND e_id <> new.e_id;
      END IF;

      RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER epreis__b_01_iu
      BEFORE INSERT OR UPDATE
      ON epreis
      FOR EACH ROW
      EXECUTE PROCEDURE epreis__b_01_iu();
  --

 --Änderung am Artikel
 CREATE OR REPLACE FUNCTION epreis__b_01_iu__aknr() RETURNS TRIGGER AS $$
    BEGIN
        -- INSERT
        IF new.e_mcv IS NULL THEN --Standard ME für Artikel
           new.e_mcv := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(new.e_aknr);
        END IF;
        --
        IF tg_op = 'UPDATE' THEN
           -- die meid hat sich nicht geändert, obwohl sich der Artikel geändert hat!
           IF (new.e_aknr IS DISTINCT FROM old.e_aknr) AND (new.e_mcv IS NOT DISTINCT FROM old.e_mcv)
           THEN /*wir müssen natürlich auch den Mengencode mit nachziehen!*/
              new.e_mcv := tartikel.me__convertme_for_art__by__mid(new.e_aknr, old.e_mcv, true);
           END IF;
        END IF;
        --

        -- Der Datensatz wurde mit einer für den Artikel ungültigen Mengeneinheit gespeichert. Tabelle: %, ID: %, Feld: %, ART-Nr.: %, Artmgc-ID: %
        IF NOT TArtikel.me__art__artmgc__m_ids__valid( new.e_aknr, new.e_mcv )
        THEN
            RAISE EXCEPTION     '%', Format(lang_text(13795), 'epreis', new.e_id::VARCHAR, 'e_mcv'    , new.e_aknr, new.e_mcv::VARCHAR);
        END IF;
        --
        RETURN new;
    END $$ LANGUAGE plpgsql;

    --CREATE TRIGGER auftg__b_u
    CREATE TRIGGER epreis__b_01_iu__aknr
      BEFORE INSERT OR UPDATE
      OF e_aknr, e_mcv
      ON epreis
      FOR EACH ROW
      WHEN (new.e_aknr IS NOT null) -- wenn null, kommt NOT NULL CONSTRAINT
      EXECUTE PROCEDURE epreis__b_01_iu__aknr();

  --
  CREATE OR REPLACE FUNCTION epreis__b_05_iu__stkvkpuf1() RETURNS TRIGGER AS $$
    DECLARE
        abzu_rec record;
    BEGIN
      -- aktuellen Kurs annehmen
      IF TG_OP='INSERT' THEN
          IF new.e_waer <> TSystem.Settings__Get('BASIS_W') AND coalesce(new.e_kurs, 1) = 1 THEN
             SELECT waerkurs(new.e_waer) INTO new.e_kurs;
          END IF;
      ELSE -- UPDATE
          IF     new.e_waer IS DISTINCT FROM old.e_waer
             AND new.e_kurs IS NOT DISTINCT FROM old.e_kurs
          THEN  ---  #19766 Wechselkur soll auch neue geholt werden
              SELECT waerkurs(new.e_waer) INTO new.e_kurs;
          END IF;
      END IF;

      -- aus den Abzu-Daten 2 verschiedene Summen bilden (einmal Summe über alle, einmal nur über die Abzu für Selbstkosten)
      -- #13120 4 Verschiebene Daten abfragen - zur unterschiedlichen Handhabung der ABZU pro Menge und Pro Vorgang
      WITH
        data_abzu_m AS (
            SELECT eaz_betr * eaz_anz AS pos_betrag,
                   abz_inselbstko     AS inselbsko
              FROM epreisabzu
              JOIN abzu ON abz_id = eaz_abz_id
             WHERE eaz_type = 'M'
               AND eaz_e_id = new.e_id
        ),

        data_abzu_e AS (
            SELECT eaz_betr * eaz_anz AS pos_betrag,
                   abz_inselbstko     AS inselbsko
              FROM epreisabzu
              JOIN abzu ON abz_id = eaz_abz_id
             WHERE eaz_type = 'E'
               AND eaz_e_id = new.e_id
        )
      SELECT
        -- mengenbezogene Abzuschläge
          -- Summe über alle Abzu
          coalesce((SELECT sum(coalesce(pos_betrag, 0)) FROM data_abzu_m), 0)                 AS sum_alle_m,
          -- Summe über alle Abzu, die nur in Selbstkosten sollen
          coalesce((SELECT sum(coalesce(pos_betrag, 0)) FROM data_abzu_m WHERE inselbsko), 0) AS sum_inselbstko_m,

        -- einmalige Abzuschläge
          -- Summe über alle Abzu
          coalesce((SELECT sum(coalesce(pos_betrag, 0)) FROM data_abzu_e), 0)                 AS sum_alle_e,
          -- Summe über alle Abzu, die nur in Selbstkosten sollen
          coalesce((SELECT sum(coalesce(pos_betrag, 0)) FROM data_abzu_e WHERE inselbsko), 0) AS sum_inselbstko_e
      INTO abzu_rec;
      --

      new.e_stk_uf1 :=                        tartikel.me__menge__in__menge_uf1( new.e_mcv, new.e_stk );
      new.e_ep_uf1 :=                         tartikel.me__preis__in__preis_uf1( new.e_mcv, new.e_ep ); -- Da epreis__b_20_iu schon ausgeführt wurde, steckt hier die Preiseinheit mit drin.
      new.e_ep_uf1_basis_w :=                 round( new.e_ep_uf1 * new.e_kurs, 4 );

      new.e_ep_abzu :=                        ( new.e_ep * (1 - coalesce(new.e_rab, 0) / 100) )
                                            + ( abzu_rec.sum_alle_e / do1if0(new.e_stk) )
                                            + ( abzu_rec.sum_alle_m ) -- verwendet alle Abzu
      ;

      new.e_ep_uf1_basis_w_abzu :=            ( new.e_ep_uf1_basis_w * (1 - coalesce(new.e_rab, 0) / 100) )
                                            + ( abzu_rec.sum_alle_e / do1if0(new.e_stk_uf1) * new.e_kurs )
                                            + ( abzu_rec.sum_alle_m * new.e_kurs )
      ;

      -- Nur Abzuschläge, welche in Selbstkosten eingehen
      new.e_ep_uf1_basis_w_abzu_selbstko :=   ( new.e_ep_uf1_basis_w * (1 - coalesce(new.e_rab, 0) / 100) )
                                            + ( abzu_rec.sum_inselbstko_e / do1if0(new.e_stk_uf1) * new.e_kurs )
                                            + ( abzu_rec.sum_inselbstko_m * new.e_kurs )
      ;

      RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER epreis__b_05_iu__stkvkpuf1
      BEFORE INSERT OR UPDATE
      OF e_stk
         , e_aknr, e_mcv --, ag_vkp_mce
         , e_ep, e_preis, e_preiseinheit, e_rab, e_kurs, e_waer, e_id -- #13120 e_id hinzugefügt
      ON epreis
      FOR EACH ROW
      EXECUTE PROCEDURE epreis__b_05_iu__stkvkpuf1();
  --

  -- wenn sich am Lieferantendatensatz der Preis ändert, ist dieser wieder "ab heute" gültig.
  -- somit kann ein bestehender datensatz gepflegt werden und dieser wird nicht irgendwann älter als 5 jahre, wodurch er ungültig würde
  CREATE OR REPLACE FUNCTION epreis__b_90__u__gdatum__refresh() RETURNS TRIGGER AS $$
      BEGIN
          -- es hat sich etwas am Wert geändert, somit wieder neue Gültigkeit. Der Datensatz wurde aktualisiert.
          IF     new.e_ep_uf1_basis_w_abzu IS DISTINCT FROM old.e_ep_uf1_basis_w_abzu
                 -- und das Datum nicht manuell bereits geändert wurde
             AND Equals(new.e_gdatum, old.e_gdatum)
          THEN
             new.e_gdatum := today();
             -- RAISE NOTICE PRODAT_HINT
          END IF;
          --
          RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER epreis__b_90__u__gdatum__refresh
        BEFORE UPDATE
        ON epreis
        FOR EACH ROW
        WHEN (new.e_bisdatum IS NULL)
        EXECUTE PROCEDURE epreis__b_90__u__gdatum__refresh();

  -- http://redmine.prodat-sql.de/issues/4582  Lieferantenerklärung
  CREATE OR REPLACE FUNCTION epreis__b_75_iu__e_stal() RETURNS TRIGGER AS $$
   BEGIN
     -- Stammlieferant in anderen Datensätzen zurücksetzen
    IF new.e_stal THEN
        -- Ausnahme für Fertigungsartikel: unterschiedliche Fertigungsartikel können unterschiedlichen STAL haben.
        UPDATE epreis SET e_stal=FALSE WHERE e_aknr=new.e_aknr AND e_stal AND e_id <> new.e_id AND e_fertaknr IS NOT DISTINCT FROM new.e_fertaknr;
    END IF;
   -- anderer Lieferant ist aktuell Stammlieferant und besitzt für den Artikel eine Lieferantenerklärung
    IF new.e_stal AND EXISTS (SELECT TRUE FROM art JOIN epreis ON e_aknr=ak_nr
                              WHERE e_stal
                                AND e_lkn=ak_lerkl_ad_krz
                                AND e_lkn<>new.e_lkn
                                AND ak_nr=new.e_aknr ) THEN
        RAISE EXCEPTION '%', lang_text(15956);
    END IF;
    RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER epreis__b_75_iu__e_stal
    BEFORE INSERT OR UPDATE
    OF e_stal
    ON epreis
    FOR EACH ROW
    EXECUTE PROCEDURE epreis__b_75_iu__e_stal();
  -- Beschaffungsfrist aktualisieren
  CREATE OR REPLACE FUNCTION epreis__b_75_iu__Set_BFR() RETURNS TRIGGER AS $$
    DECLARE updatebfr BOOLEAN;
            fixBfr    BOOLEAN;
            curBfr    INTEGER;
            ac        VARCHAR;
    BEGIN

      --- #11261  new.e_lfzt:=COALESCE(new.e_lfzt,0);
      IF new.e_lfzt IS NULL THEN
          new.e_lfzt:=TSystem.Settings__GetInteger('EK_Lieferfrist_Default',1);
      END IF;

      -- Beschaffungsfrist fixieren?
      fixbfr := COALESCE(ain_fixbfr,FALSE) FROM artinfo WHERE ain_ak_nr = new.e_aknr;
      IF fixBfr THEN -- Die sollen wir nicht umschreiben
          RETURN new;
      END IF;

      -- Aktuelle Beschaffungsfrist laut Artikelstamm und AC laut Artikelstamm
      SELECT COALESCE(ak_bfr, 0), ak_ac INTO curBfr, ac FROM art WHERE ak_nr = new.e_aknr;

      -- Neu und Stammlieferant und BFR würde sich ändern => Eintragen
      updatebfr := (TG_OP = 'INSERT') AND (new.e_lfzt <> curBfr);

      IF (TG_OP='UPDATE') THEN
          -- Lieferzeit umgeschrieben oder neu zum Stammlieferant gemacht
          updatebfr := (new.e_lfzt IS DISTINCT FROM old.e_lfzt) OR (new.e_stal AND NOT old.e_Stal);
          updateBfr := updateBfr AND (new.e_lfzt <> curBfr); -- und es würde sich was ändern.
      END IF;

      -- Nur Fragen, wenn IC <> 50
      updatebfr := updatebfr AND NOT (ic_for_ac(ac) = 50);

      IF updatebfr THEN
          PERFORM PRODAT_MESSAGE_YES_NO(21239, 'Message.epreis.BeschFristAktual.yes', NULL, new.e_lfzt || ',' || new.e_aknr);
      END IF;

      RETURN new;
    END$$LANGUAGE plpgsql;

    CREATE TRIGGER epreis__b_75_iu__Set_BFR
      BEFORE INSERT OR UPDATE OF e_stal, e_lfzt
      ON epreis
      FOR EACH ROW
      WHEN (new.e_stal)
      EXECUTE PROCEDURE epreis__b_75_iu__Set_BFR();

  -- 15600 es darf nur einen fixierten Lieferanten geben
  -- unabhängig vom Stammlieferantenkennzeichen
  CREATE OR REPLACE FUNCTION epreis__b_80_iu__lkn_fixiert() RETURNS trigger AS $$
    BEGIN

        -- prüfen, ob bereits ein Lieferant des Artikels
        IF
            EXISTS(
              SELECT true
                FROM epreis
               WHERE e_aknr = new.e_aknr
                  -- abweichender Lieferant als der im bearbeiteten Datensatz
                 AND e_lkn <> new.e_lkn
                 -- gültig muss er sein
                 AND current_date BETWEEN e_gdatum AND coalesce( e_bisdatum, 'infinity' )
                 AND tsystem.enum_getvalue( e_stat, 'F' )
            )
        THEN
            -- »Es existiert bereits ein Lieferant mit dem Kennzeichen "fixiert".«
            RAISE EXCEPTION '%', lang_text( 32648 );
        END IF;

        RETURN new;

    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER epreis__b_80_iu__lkn_fixiert
    BEFORE INSERT OR UPDATE OF e_stat
    ON epreis
    FOR EACH ROW
    WHEN (tsystem.enum_getvalue( new.e_stat, 'F' ))
    EXECUTE PROCEDURE epreis__b_80_iu__lkn_fixiert();

--- #19696
  CREATE OR REPLACE FUNCTION epreis__b_84_u__e_herkunft__null() RETURNS trigger AS $$
   BEGIN

      new.e_herkunft := '[updated]' || new.e_herkunft;

      RETURN new;

   END $$ LANGUAGE plpgsql;

  CREATE TRIGGER epreis__b_84_u__e_herkunft__null
    BEFORE UPDATE OF e_herkunft
    ON epreis
    FOR EACH ROW
    EXECUTE FUNCTION epreis__b_84_u__e_herkunft__null();

--- #18814
  CREATE OR REPLACE FUNCTION epreis__b_85_u__e_herkunft__null() RETURNS trigger AS $$
   BEGIN

      IF new.e_herkunft LIKE '[updated]%' then
        new.e_herkunft := replace(new.e_herkunft, '[updated]', '');
      ELSE
        new.e_herkunft := null;
      END IF;

      RETURN new;

   END $$ LANGUAGE plpgsql;

  CREATE TRIGGER epreis__b_85_u__e_herkunft__null
    BEFORE UPDATE OF e_herkunft, e_preis, e_rab, e_ep_uf1_basis_w_abzu
    ON epreis
    FOR EACH ROW
    EXECUTE PROCEDURE epreis__b_85_u__e_herkunft__null();

--Staffelpreise zum Epreis-Eintrag
CREATE TABLE epreisstaffel (
  est_id                       SERIAL PRIMARY KEY,
  est_e_id                     INTEGER REFERENCES epreis ON UPDATE CASCADE ON DELETE CASCADE,
  est_aArt_id                  INTEGER, -- siehe X_Tableconstraints.sql ALTER TABLE epreisstaffel ADD FOREIGN KEY (est_aArt_id)  REFERENCES anfArt    ON UPDATE CASCADE ON DELETE CASCADE,
  est_aAng_id                  INTEGER, -- siehe X_Tableconstraints.sql  ALTER TABLE epreisstaffel ADD FOREIGN KEY (est_anfangebot) REFERENCES anfangebot ON UPDATE CASCADE ON DELETE CASCADE;
  est_mengevon                 NUMERIC NOT NULL DEFAULT 0,     -- Mindestmenge. Keine gegeben => 0.
  est_mengebis                 NUMERIC,                        -- Mengenobergrenze für Preis, keine gegeben für letzte Preisstaffel
  est_rahmen_stk               NUMERIC(12,6),                  -- Rahmenvertragsmenge, die Lieferant erwartet. e_stk ist dann das Abruflos.
  est_ep                       NUMERIC,                        -- Einkaufspreis bei dieser Menge, analog e_preis also mit Preiseinheit (4,99€ per 100 Stk) -> 4,99€
  -- TODO: Epreis-Staffeln und Preiseinheiten?
  CHECK((est_aArt_id is not null and est_aAng_id is null     and est_e_id is null) OR  -- Anfragepositionsstaffel
        (est_aArt_id is null     and est_aAng_id is not null and est_e_id is null) OR  -- Angebotsstaffel
        (est_aArt_id is null     and est_aAng_id is null     and est_e_id is not null)) -- normale Preisstaffel
  );
--

CREATE INDEX epreisstaffel_aang_id ON epreisstaffel(est_aang_id) WHERE est_aang_id IS NOT null;
CREATE INDEX epreisstaffel_aArt_id ON epreisstaffel(est_aArt_id) WHERE est_aArt_id IS NOT null;


CREATE OR REPLACE FUNCTION epreisstaffel__a_iud() RETURNS trigger AS $$
  DECLARE
      _aang_id numeric;
      _aang record;
  BEGIN

      -- aktualisiert den Preis/ME eines Lieferantenangebots,
      -- wenn sich die zugehörige Mengenstaffellung ändert

      IF TG_OP IN ( 'INSERT', 'UPDATE' ) then
          _aang_id := new.est_aang_id;
      ELSIF TG_OP = 'DELETE' THEN
          _aang_id := old.est_aang_id;
      END IF;

      SELECT aang_id, aang_menge INTO _aang
        FROM anfangebot
       WHERE aang_id = _aang_id;

      IF _aang IS NOT null THEN
          PERFORM teinkauf.anfangebot__update__aang_epreis__epreisstaffel( _aang.aang_id, _aang.aang_menge );
      END IF;

      RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER epreisstaffel__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON epreisstaffel
    FOR EACH ROW
    EXECUTE PROCEDURE epreisstaffel__a_iud();
--

--Ab- und Zuschläge zum Einkaufspreis.
CREATE TABLE epreisabzu (                                                                   -- VIEWFELDER
  eaz_id            SERIAL PRIMARY KEY,                                                       --  ID des Zuschlags
  eaz_type          VARCHAR(1) DEFAULT 'E',                                                   --  Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
  eaz_pos           INTEGER,                                                                  --  Position
  eaz_abz_id        INTEGER NOT NULL REFERENCES abzu,                                         --  ID der Vorgabe
  eaz_e_id          INTEGER NOT NULL REFERENCES epreis ON UPDATE CASCADE ON DELETE CASCADE,   --  ID des Datensatzes an dem der Zuschlag hängt
  eaz_anz           NUMERIC NOT NULL DEFAULT 1,                                               --  Anzahl / Menge
  eaz_betr          NUMERIC,                                                                  --  Betrag in Währung des Parent-Datensatzes
  eaz_proz          NUMERIC,                                                                  --  Prozentualer Zuschlag auf Basis des Parent-Betrags
  eaz_canSkonto     BOOLEAN NOT NULL DEFAULT TRUE,                                            --  Gilt Skonto für den Zuschlag?
  eaz_steucode      INTEGER REFERENCES steutxt,                                               --  Steuercode (meist gleich Parent)
  eaz_steuproz      NUMERIC(5,2) NOT NULL DEFAULT 0,                                          --  Prozentsatz der Steuer
  eaz_konto         VARCHAR(25),                                                              --  Kontierung
  eaz_visible       BOOLEAN NOT NULL DEFAULT TRUE,                                            --  Auf Dokument sichtbar oder nicht?
  eaz_zutxt         TEXT,                                                                     --  Zusätzlicher Hinweistext
  eaz_zutxt_rtf     TEXT,                                                                     --  Zusätzlicher Hinweistext (RTF)
  eaz_zutxt_int     TEXT,                                                                     --  Interner zusatztext (erscheint nicht auf Dokumenten)
  eaz_source_table  VARCHAR(40),                                                              --  Aus welcher Quelle wurde Abzu hierhin kopiert
  eaz_source_dbrid  VARCHAR(32),                                                              --  Aus welchem Datensatz wurde Abzu hierhin kopiert
  CHECK (eaz_proz <> 0::numeric)
  );
--
CREATE INDEX epreisabzu__eaz_e_id ON epreisabzu(eaz_e_id);
--
CREATE OR REPLACE FUNCTION epreisabzu__a_iud() RETURNS TRIGGER AS $$
  BEGIN
    --Bei Änderung Ab-/Zuschläge Kosten in Epreis nachrechnen
    IF (tg_op = 'DELETE') THEN
        UPDATE epreis SET e_ep_uf1_basis_w_abzu = 0, e_id = old.eaz_e_id WHERE e_id = old.eaz_e_id;
    ELSE
        UPDATE epreis SET e_ep_uf1_basis_w_abzu = 0, e_id = new.eaz_e_id WHERE e_id = new.eaz_e_id;
    END IF;

    IF tg_op='DELETE' THEN
        RETURN old;
    ELSE
        RETURN new;
    END IF;
  END $$ LANGUAGE plpgsql;


  CREATE TRIGGER epreisabzu__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON epreisabzu
    FOR EACH ROW
    EXECUTE PROCEDURE epreisabzu__a_iud();
--
-- Zusatztexte zur Epreis
CREATE TABLE eprzutxt (
  ezt_id                 serial NOT NULL PRIMARY KEY,
  ezt_aknr               varchar(40) NOT NULL REFERENCES art ON UPDATE CASCADE ON DELETE CASCADE,
  ezt_lkn                varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE ON DELETE CASCADE,
  ezt_bestxt             boolean NOT null DEFAULT TSystem.Settings__GetBool('eprzutxt'),  -- der Text soll in die Bestellung gezogen werden. Einige Mankos siehe https://redmine.prodat-sql.de/issues/6440
  ezt_info               text
);
CREATE UNIQUE INDEX eprzutxt_aklif ON eprzutxt (ezt_aknr, ezt_lkn);
--

/* Mit Prodat V18.08.02.00 gedroppt. Wurden nur noch im Bestellvorschlag verwendet.
DROP FUNCTION IF EXISTS GetEPreisStaffel(INTEGER, NUMERIC);
DROP FUNCTION IF EXISTS GetBestEPreis(VARCHAR, VARCHAR, BOOLEAN, VARCHAR, NUMERIC);
DROP FUNCTION IF EXISTS getepreis_basis_w_uf(VARCHAR, NUMERIC, INTEGER, VARCHAR, VARCHAR, BOOLEAN);
*/

-- Gesammelte Rahmeninfos zum Rahmen mit der angegebenen Nummer. OUT Parameter nicht umbenennen, darauf werden Felder im Delphi erstellt.
CREATE OR REPLACE FUNCTION get_rahmeninfo_ldsdok(
    IN rhlnr VARCHAR,
    OUT ld_rldauftg VARCHAR, OUT ld_rldpos INTEGER, OUT ld_raknr VARCHAR, OUT ld_rac VARCHAR, OUT artcodbez VARCHAR, OUT rmengenbez VARCHAR,
    OUT ld_rstk     NUMERIC, OUT ld_rwert  NUMERIC,
    OUT ld_rstko    NUMERIC, OUT ld_rwerto NUMERIC,
    OUT ld_rstkl    NUMERIC, OUT ld_rwertl NUMERIC ) RETURNS RECORD AS $$
  DECLARE r RECORD;
  BEGIN

    IF NOT EXISTS( SELECT true FROM rahmenlieferant WHERE rhl_nr = rhlnr) THEN
        RETURN;
    END IF;

    SELECT ld_auftg, ld_pos, rhl_ak_nr, rhl_ak_ac, lang_artcodbez(rhl_ak_ac, prodat_languages.curr_lang()), lang_artcodbez(rhl_ak_ac, prodat_languages.curr_lang()),
           rhl_stk_uf1, rhl_wert,
           (rahmen_stk_ldsdok_offen(rhlnr)).stko , (rahmen_stk_ldsdok_offen(rhlnr)).werto,
           (rahmen_stk_ldsdok_liefer(rhlnr)).stkl, (rahmen_stk_ldsdok_liefer(rhlnr)).wertl
    INTO ld_rldauftg, ld_rldpos, ld_raknr, ld_rac, artcodbez, rmengenbez,
         ld_rstk, ld_rwert, ld_rstko, ld_rwerto, ld_rstkl, ld_rwertl
    FROM rahmenlieferant JOIN ldsdok ON ( (ld_code ='R') OR (ld_code = 'E')) AND ((ld_auftg||'/'||ld_pos) = rhl_nr)
    WHERE rhl_nr = rhlnr;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT;
--

-- Menge und Wert des Rahmens (Einkauf)
CREATE OR REPLACE FUNCTION rahmen_stk_ldsdok(IN rhmnr VARCHAR, OUT stk NUMERIC(12,2), OUT wert NUMERIC(12,2)) RETURNS RECORD AS $$
  BEGIN
    SELECT rhl_stk_uf1, rhl_wert INTO stk, wert FROM rahmenlieferant WHERE rhl_nr=rhmnr;
    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- offene Menge und Wert des Rahmens (Einkauf)
CREATE OR REPLACE FUNCTION rahmen_stk_ldsdok_offen(IN rhmnr VARCHAR, OUT stko NUMERIC(12,2), OUT werto NUMERIC(12,2)) RETURNS RECORD AS $$
  DECLARE stkw NUMERIC(12,2); -- Menge weg
          wertw NUMERIC(12,2); -- Wert weg
  BEGIN
    -- Menge aus Abrufen ermitteln
    -- Bei geschlossenem Abruf gilt die gelieferte Menge (Über- bzw. Unterlieferung).
    SELECT SUM(CASE WHEN ld_done THEN ld_stkl
                    ELSE ld_stk_uf1 -- sonst Abrufmenge
               END)
      INTO stkw
      FROM ldsdok
     WHERE ld_rhl_nr = rhmnr
       AND ld_pos > 0
       AND ld_code <> 'R'
       AND NOT ld_storno;

    SELECT SUM(ldsdok_pos_wert_calc(ld_id, FALSE, true))
      INTO wertw
      FROM ldsdok
     WHERE ld_rhl_nr = rhmnr
       AND ld_pos > 0
       AND ld_code <> 'R'
       AND NOT ld_storno;

    SELECT stk  - coalesce(stkw, 0)  INTO stko  FROM rahmen_stk_ldsdok(rhmnr);
    SELECT wert - coalesce(wertw, 0) INTO werto FROM rahmen_stk_ldsdok(rhmnr);

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- tatsächlich gelieferte Menge und Wert des Rahmens (Einkauf)
CREATE OR REPLACE FUNCTION rahmen_stk_ldsdok_liefer(IN rhmnr VARCHAR, OUT stkl NUMERIC(12,2), OUT wertl NUMERIC(12,2)) RETURNS RECORD AS $$
  BEGIN
    SELECT SUM(ld_stkl) INTO stkl FROM ldsdok WHERE ld_rhl_nr=rhmnr AND ld_pos>0 AND ld_code<>'R' AND NOT ld_storno;
    SELECT SUM(ldsdok_pos_wert_calc(ld_id, FALSE, true)/ld_stk_uf1*ld_stkl) INTO wertl FROM ldsdok WHERE ld_rhl_nr=rhmnr AND ld_pos>0 AND ld_code<>'R' AND ld_stk_uf1>0 AND ld_stkl>0 AND NOT ld_storno;
    --      Gesamtwert Position / Positionsmenge = Wert pro Einheit * Liefermenge = Wert geliefert
    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Artikel und AC des Rahmens (Einkauf)
CREATE OR REPLACE FUNCTION rahmen_aknr_ldsdok(IN rhmnr VARCHAR, OUT aknr VARCHAR(40), OUT ac VARCHAR(9)) RETURNS RECORD AS $$
  BEGIN
    SELECT rhl_ak_nr, rhl_ak_ac INTO aknr, ac FROM rahmenlieferant WHERE rhl_nr=rhmnr;
    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Anfrage nach Liste von Artikeln an Lieferanten
CREATE TABLE anfrage (
   anf_nr                   VARCHAR(30) PRIMARY KEY,
   anf_titel                VARCHAR(75),
   anf_bisDatum             DATE DEFAULT (timediff_adddays(current_date, 5, true, true)),                           -- Bis wann eine Antwort erwartet wird
   anf_termweek             VARCHAR(7),                     -- Terminwoche
   anf_txt                  TEXT,                           -- Bemerkung intern (Freier Text in Anfragekopfdaten)
   anf_txt_rtf              TEXT,
   anf_agnr                 VARCHAR(40),                    -- Freies Textfeld für Auftragsnummer
   anf_nident               VARCHAR(50) REFERENCES qsnorm,  -- Bindung einer Anfrage an eine bestimmte Norm
   anf_an_nr                VARCHAR(50) REFERENCES anl,     -- Projektnummer, genutzt für Zuordnung EInkauf
   anf_kalk                 BOOLEAN DEFAULT FALSE,          -- Anfrage erfolgt zu Kalkulationszwecken

   -- Interner Ansprechpartner / Zuständiger Mitarbeiter
   anf_apint                VARCHAR(50) DEFAULT tsystem.current_user_ll_db_usename(),
   anf_done                 BOOLEAN NOT NULL DEFAULT FALSE, -- Erledigt
   anf_storno               BOOLEAN NOT NULL DEFAULT FALSE, -- Storniert

   -- Kopftext des Dokuments (Anschreiben)
   anf_kopftext             TEXT DEFAULT (belarzu__zu_tit__gettxtrtf('DOKANFRAGE_TXT_KOPF', prodat_languages.curr_lang())).txt,
   anf_kopftext_rtf         TEXT DEFAULT (belarzu__zu_tit__gettxtrtf('DOKANFRAGE_TXT_KOPF', prodat_languages.curr_lang())).txtrtf,

   -- Fußtext des Dokuments (Schlußtext)
   anf_fusstext             TEXT DEFAULT (belarzu__zu_tit__gettxtrtf('DOKANFRAGE_TXT_FUSS', prodat_languages.curr_lang())).txt,
   anf_fusstext_rtf         TEXT DEFAULT (belarzu__zu_tit__gettxtrtf('DOKANFRAGE_TXT_FUSS', prodat_languages.curr_lang())).txtrtf,

   ----- Konditionen:
   anf_zak                  INTEGER,                        -- Zahlungsziel (in Tagen)
   anf_skv                  INTEGER,                        -- Skonto verfällt nach X Tagen
   anf_sks                  NUMERIC(5,2),           -- Skontosatz
   anf_zakbem               VARCHAR(40),            --Zahlungskond. Bemerkung
   anf_vers                 VARCHAR(75),            -- Versandart
   anf_versandbem           TEXT,                               -- Bemerkung zum Versand
   anf_versandbem_rtf       TEXT,

   -- System (tables__generate_missing_fields)
   dbrid                    VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq'),
   insert_date              DATE,
   insert_by                VARCHAR(32),
   modified_by              VARCHAR(32),
   modified_date            TIMESTAMP(0)
  );

-- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
  --AnfArt schließen/stornieren wenn Kopf geschlossen/storniert wird.
  CREATE OR REPLACE FUNCTION anfrage__a_iu_setAnfArtDoneStorno() RETURNS TRIGGER AS $$
    DECLARE
        done_old  BOOLEAN;
        storno_old BOOLEAN;
    BEGIN

        IF TG_OP = 'UPDATE' THEN

            done_old := old.anf_done;
            storno_old = old.anf_storno;

        ELSE
            -- INSERT
            done_old := false;
            storno_old := false;

        END IF;

        UPDATE anfart
        SET aArt_done = true
        WHERE
              aArt_anf_nr = new.anf_nr
          AND NOT aArt_done
          AND NOT aArt_storno
          AND new.anf_done
          AND NOT done_old;

        UPDATE anfart
        SET aArt_storno = true
        WHERE
              aArt_anf_nr = new.anf_nr
          AND NOT aArt_storno
          AND NOT aArt_done
          AND new.anf_storno
          AND NOT storno_old;

        RETURN new;

    END $$ LANGUAGE plpgsql;
    --
    CREATE TRIGGER anfrage__a_iu_setAnfArtDoneStorno
      AFTER INSERT OR UPDATE OF anf_done, anf_storno
      ON anfrage
      FOR EACH ROW
      EXECUTE PROCEDURE anfrage__a_iu_setAnfArtDoneStorno();
--

--Liste angefragter Artikel
CREATE TABLE anfart (
   aArt_id              serial PRIMARY KEY,
   aArt_pos             integer         NOT NULL,                       -- Positionsnummer in einer Anfrage
   aArt_ak_nr           varchar(40)     NOT NULL,                       -- Nachgefragter Artikel
   aArt_bez             varchar(100),
   aArt_aknr_idx        varchar(30),                                    -- ZeichnungsIndex
   aArt_anf_nr          varchar(30)     NOT NULL REFERENCES anfrage ON DELETE CASCADE ON UPDATE CASCADE,        -- Anfrage-ID
   aArt_menge           numeric(12,4)   NOT NULL,                       -- Gewünschte Menge
   aArt_m_id            integer         NOT NULL REFERENCES mgcode,     -- Mengeneinheit für Artikel
   aArt_termin          date,                                           -- Gewünschter Liefertermin
   aArt_termweek        varchar(7),                                     -- Terminwoche
   aArt_txt             text,
   aArt_txt_rtf         text,
   aArt_txtint          text,
   aArt_txtint_rtf      text,
   aArt_op_ix           integer REFERENCES opl ON UPDATE CASCADE,
   aArt_ab_ix           integer,
   aArt_o2_id           integer REFERENCES op2 ON UPDATE CASCADE,
   aArt_a2_id           integer, --References, aber erst später in XTableConstraints
   aArt_o2_n            integer,                                        -- Arbeitsgangnummer (aus ASK), interpretiert als Arbeitsgangnummer aus ABK, wenn ABK-Index angegeben ist
   aArt_ldid            integer REFERENCES ldsdok ON DELETE SET NULL,   -- Bestellung die für diesen Artikel ausgelöst wurde
   aArt_ks              varchar(9) REFERENCES ksv,                      -- Kostenstelle für die der Artikel bezogen wird
   aArt_konto           varchar(25),                                    -- Konto, analog ld_konto
   aArt_ref             varchar(40),
   aArt_bemerk          text,
   aArt_done            boolean NOT NULL DEFAULT FALSE,                 -- Position erledigt
   aArt_storno          boolean NOT NULL DEFAULT FALSE,                 -- Position storniert
   aArt_anfrage         boolean NOT NULL DEFAULT FALSE,                 -- Der Artikel darf nur angefragt werden, eine Bestellung wird unterbunden (Weitergegeben aus BANF)
   aArt_los             numeric(12,2) CONSTRAINT anfart__aart_los__positive CHECK (aart_los > 0), -- Losgröße
   aArt_alief_id        integer[],                                      -- Anzufragende Lieferanten
   aArt_alternativ_zu_aart_id integer[]                                 -- Die IDs zu den Positionen, zu denen die Position eine Alternativposition ist
  );

  CREATE UNIQUE INDEX anfartpos_anrnr ON anfart(aart_pos, aart_anf_nr);
  CREATE INDEX anfart_ak_nr           ON anfart(aart_ak_nr);
  CREATE INDEX anfart_anf_nr          ON anfart(aart_anf_nr);
  CREATE INDEX anfart_aart_alief_id   ON anfart USING GIN (aart_alief_id gin__int_ops);



  CREATE OR REPLACE FUNCTION anfart__b_d_alternativ() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE
      anfart
    SET
      aart_alternativ_zu_aart_id = CASE WHEN
                                     ARRAY[old.aArt_id] = aart_alternativ_zu_aart_id
                                   THEN
                                     NULL
                                   ELSE
                                     array_remove(aart_alternativ_zu_aart_id, old.aArt_id)
                                   END
    WHERE
          aart_anf_nr = old.aart_anf_nr
      AND array_position(aart_alternativ_zu_aart_id, old.aArt_id) IS NOT NULL;
    RETURN old;
  END $$ LANGUAGE plpgsql;


  CREATE TRIGGER anfart__b_d_alternativ
    BEFORE DELETE
    ON anfart
    FOR EACH ROW
    EXECUTE PROCEDURE anfart__b_d_alternativ();


  CREATE OR REPLACE FUNCTION anfart__b_iu() RETURNS TRIGGER AS $$
    BEGIN

        IF (
               new.aArt_konto IS NULL
            AND TSystem.Settings__GetBool('lds_konto_required')
        ) THEN

            RAISE EXCEPTION 'null value in not-null "aArt_konto"';

        END IF;

        IF (
               new.aArt_ks IS NULL
           AND TSystem.Settings__GetBool('lds_ks_required')
        ) THEN

            RAISE EXCEPTION 'null value in not-null "aArt_ks"';

        END IF;

        RETURN new;

    END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER anfart__b_iu
    BEFORE INSERT OR UPDATE
    ON anfart
    FOR EACH ROW
    EXECUTE PROCEDURE anfart__b_iu();
  --

  CREATE OR REPLACE FUNCTION anfart__a_05_iu_menge() RETURNS trigger AS $$
    BEGIN

        PERFORM anfangebot_menge_wert_recalculate( anfangebot )
        FROM anfangebot
        WHERE aang_aart_id = new.aArt_id;

        RETURN new;
    END $$ LANGUAGE plpgsql;

  --
  CREATE TRIGGER anfart__a_05_iu_menge
    AFTER INSERT OR UPDATE OF aArt_menge
    ON anfart
    FOR EACH ROW
    EXECUTE PROCEDURE anfart__a_05_iu_menge();
  --

  --
  CREATE OR REPLACE FUNCTION anfart__b_60_d__bap_done__reopen() RETURNS TRIGGER AS $$
    BEGIN
      UPDATE bestanfpos SET bap_done = FALSE WHERE bap_done AND bap_aArt_id = old.aArt_id;

      RETURN old;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER anfart__b_60_d__bap_done__reopen
     BEFORE DELETE
     ON anfart
     FOR EACH ROW
     EXECUTE PROCEDURE anfart__b_60_d__bap_done__reopen();
  --

  -- Setzt Anfrage Erledigt- und Stornostatus in Abhängigkeit der Unterpos AnfArt-Erledigtstatus.
  CREATE OR REPLACE FUNCTION anfart__a_iud_setAnfrageDone() RETURNS TRIGGER AS $$
    DECLARE
        _anfnr varchar;
        _all_anfart_done boolean;
        _all_anfart_storno boolean;
    BEGIN

        IF TG_OP = 'DELETE' THEN
            _anfnr := old.aArt_anf_nr;
        ELSE
            _anfnr := new.aArt_anf_nr;
        END IF;

        _all_anfart_storno := ( SELECT BOOL_AND( aArt_storno AND NOT aArt_done ) FROM anfart WHERE aArt_anf_nr = _anfnr );

        -- Wenn Storno gesetzt wird (alle Positionen sind storniert), dann kein Erledigt setzen
        _all_anfart_done := NOT _all_anfart_storno
                            AND ( SELECT BOOL_AND( aArt_done OR aArt_storno ) FROM anfart WHERE aArt_anf_nr=_anfnr ) ;

        -- INSERT, UPDATE(new), DELETE Fall
        UPDATE anfrage SET
          anf_done = _all_anfart_done,
          anf_storno = _all_anfart_storno
        WHERE
              anf_nr = _anfnr
          AND (
                 anf_storno <> _all_anfart_storno
              OR anf_done <> _all_anfart_done
          );

        -- UPDATE(old) Fall
        IF TG_OP = 'UPDATE' AND new.aArt_anf_nr <> old.aArt_anf_nr THEN

            -- s.o.
            _all_anfart_storno := ( SELECT BOOL_AND(aArt_storno AND NOT aArt_done) FROM anfrage WHERE aArt_anf_nr = old.aArt_anf_nr );
            _all_anfart_done := NOT _all_anfart_storno
                                AND ( SELECT BOOL_AND(aArt_done OR aArt_storno) FROM anfart WHERE aArt_anf_nr = old.aArt_anf_nr ) ;

            UPDATE anfrage SET
                anf_done = _all_anfart_done,
                anf_storno = _all_anfart_storno
            WHERE anf_nr = old.aArt_anf_nr
              AND ( anf_storno <> _all_anfart_storno OR anf_done <> _all_anfart_done );
        END IF;

        IF TG_OP = 'DELETE' THEN
            RETURN old;
        ELSE
            RETURN new;
        END IF;

    END $$ LANGUAGE plpgsql;

     CREATE TRIGGER anfart__a_iud_setAnfrageDone
      AFTER INSERT OR DELETE OR UPDATE OF aArt_anf_nr, aArt_done, aArt_storno
      ON anfart
      FOR EACH ROW
      EXECUTE PROCEDURE anfart__a_iud_setAnfrageDone();
  --


    -- Bestellanforderungen verlinken
    CREATE OR REPLACE FUNCTION anfart__a_i_bestanfpos() RETURNS TRIGGER AS $$
      BEGIN

          UPDATE bestanfpos
          SET bap_aArt_id = new.aArt_id
          WHERE bap_aArt_id IS NULL
            AND bap_aknr = new.aArt_ak_nr
            AND bap_banr = (SELECT anf_agnr FROM anfrage WHERE anf_nr = new.aArt_anf_nr);

          RETURN new;

      END $$ LANGUAGE plpgsql;
      --
      CREATE TRIGGER anfart__a_i_bestanfpos
      AFTER INSERT
      ON anfart
      FOR EACH ROW
      EXECUTE PROCEDURE anfart__a_i_bestanfpos();

  -- Schließt jeweilige AnfArt einer AnfNr, wenn Preise vorhanden oder kein Angebot mgl. ist.
  CREATE OR REPLACE FUNCTION anfart_setDone(IN inAnfNr VARCHAR) RETURNS VOID AS $$
    BEGIN

        -- nix vorhanden - nix machen.
        IF NOT EXISTS( SELECT TRUE FROM anfrage WHERE anf_nr = inAnfNr ) THEN
            RETURN;
        END IF;


        UPDATE anfart
        SET aArt_done = TRUE
        FROM (
            -- Prüfe alle Angebote der Anfrage je Artikel, ob Preise eingetragen sind oder kein Angebot mgl. ist.
            -- wenn bloß der Lieferant erstellt wird, existiert noch kein Angebots-Satz dafür, deshalb über Anfart und LEFT JOIN anfangebot, sodass man NULL-Sätze zurückbekommt.
            SELECT
                aArt_id,
                BOOL_AND(
                     aAng_preis IS NOT NULL
                  OR coalesce( aAng_ka, false ) )
                AS done

            FROM anfart
            JOIN anflief ON aLief_anf_nr = aArt_anf_nr
            LEFT JOIN anfangebot ON aAng_aart_id = aArt_id AND aAng_alief_id = aLief_id
            WHERE aArt_anf_nr = inAnfNr
              AND NOT aArt_storno
            GROUP BY aArt_id
        ) AS all_anfarts

        -- entsprechende AnfArt-Sätze schließen
        WHERE
              anfart.aArt_id=all_anfarts.aArt_id
          AND NOT anfart.aArt_done
          AND NOT anfart.aArt_storno
          AND all_anfarts.done;

        RETURN;

    END $$ LANGUAGE plpgsql;
  --


 -- Synchron halten von (ASK-Index + ABG Nummer) mit o2_id oder ABK-Index + ABG Nummer mit a2_id
 CREATE OR REPLACE FUNCTION anfart__b_iu_sync_abg() RETURNS TRIGGER AS $$
     DECLARE a2id_changed  BOOLEAN;
             o2id_changed  BOOLEAN;
               abg_changed   BOOLEAN;
     BEGIN
      -- Fall 0: op_ix, o2_n, ab_ix, o2_id und a2_id leer  => Nix machen
      -- Fall 1: o2_id gesetzt                => Anfrage auf ASK-Auswärtsarbeitsgang, op_ix und o2_n nachsetzen
      -- Fall 2: a2_id gesetzt                => Anfrage auf ABK-Auswärtsarbeitsgang, ab_ix und o2_n nachsetzen
      -- Fall 3: op_ix und o2_n gesetzt       => Anfrage auf ASK, o2_id nachsetzen
      -- Fall 4: ab_ix und o2_n gesetzt       => Anfrage auf ASK, a2_id nachsetzen
      -- Fall 5: o2_n gesetzt und o2_n = 0    => "Freie" Anfrage ohne Stammkarte oder ABK, die anderen Felder zurücksetzen

      --Fall 0
      IF (new.aart_op_ix IS NULL) AND (new.aart_o2_n IS NULL) AND (new.aart_ab_ix IS NULL) AND (new.aart_o2_id IS NULL) AND (new.aart_a2_id IS NULL) THEN
        RETURN new;
      END IF;

      IF (tg_op = 'INSERT') THEN
        o2id_changed:=(new.aart_o2_id IS NOT NULL);                  -- Fall 1
        IF NOT o2id_changed THEN
          a2id_changed :=(new.aart_a2_id IS NOT NULL);               -- Fall 2
          IF NOT a2id_changed THEN                                   -- Fall 3 und 4
            abg_changed:=(new.aart_o2_n IS NOT NULL) AND (new.aart_o2_n <> 0) AND ((new.aart_op_ix IS NOT NULL) OR (new.aart_ab_ix IS NOT NULL));  --Da haben wir einen Arbeitsgang und AB-IX oder OP-IX.
            IF NOT abg_changed THEN                                                 -- Fall 5, ist alles gleiche geblieben.
              RETURN new;
            END IF;
          END IF;
        END IF;
      END IF;

      IF (tg_op = 'UPDATE') THEN
        o2id_changed:=(new.aart_o2_id IS DISTINCT FROM old.aart_o2_id);     -- Fall 1
        IF NOT o2id_changed THEN
          a2id_changed:=(new.aart_a2_id IS DISTINCT FROM old.aart_a2_id);   -- Fall 2
          IF NOT a2id_changed THEN                                          -- Fall 3 + 4
            abg_changed := (new.aart_o2_n IS DISTINCT FROM old.aart_o2_n) OR (new.aart_op_ix IS DISTINCT FROM old.aart_op_ix) OR (new.aart_ab_ix IS DISTINCT FROM old.aart_ab_ix);
            IF NOT abg_changed THEN
              return new;                                                   -- Fall 5, Da ist nichts offensichtliches geändert.
            END IF;
          END IF;
        END IF;
      END IF;

      -- Behandlung Fall 1, ASK Index und ABG-Nummer aus o2-id holen
      IF o2id_changed THEN
        SELECT o2_ix, o2_n INTO new.aart_op_ix, new.aart_o2_n FROM op2 WHERE o2_id = new.aart_o2_id;
      END IF;

      -- Behandlung Fall 2, ABK Index und ABG-Nummer aus a2-id holen
      IF a2id_changed THEN
          SELECT a2_ab_ix, a2_n INTO new.aart_ab_ix, new.aart_o2_n FROM ab2 WHERE a2_id = new.aart_a2_id;
      END IF;

      IF abg_changed THEN

        -- Behandlung Fall 3
        IF (new.aart_op_ix IS NOT NULL) AND (new.aart_o2_n > 0) THEN
          SELECT o2_id INTO new.aart_o2_id FROM op2 WHERE o2_n = new.aart_o2_n AND o2_ix = new.aart_op_ix;
          new.aart_ab_ix:=NULL;
          new.aart_a2_id:=NULL;
        END IF;

        -- Behandlung Fall 4
        IF (new.aart_ab_ix IS NOT NULL) AND (new.aart_o2_n > 0) THEN
          SELECT a2_id INTO new.aart_a2_id FROM ab2 WHERE a2_n = new.aart_o2_n AND a2_ab_ix = new.aart_ab_ix;
          new.aart_op_ix:=NULL;
          new.aart_o2_id:=NULL;
        END IF;

        -- Behandlung Fall 5
        IF (new.aart_o2_n = 0)  OR (new.aart_o2_n IS NULL) THEN
          new.aart_op_ix := NULL;
          new.aart_ab_ix := NULL;
          new.aart_o2_id := NULL;
          new.aart_a2_id := NULL;
        END IF;
      END IF;

      -- Noch kein Arbeitsgangtext aus ASK übernommen (Fall 1 und 3)
      IF (new.aart_o2_id IS NOT NULL) AND (TRIM(COALESCE(new.aart_txt,'')) = '' ) THEN
        SELECT o2_txt, o2_txt_rtf INTO new.aart_txt, new.aart_txt_rtf FROM op2 WHERE o2_id = new.aart_o2_id;
      END IF;

      -- Noch kein Arbeitsgangtext aus ABK übernommen (Fall 2 und 4)
      IF (new.aart_a2_id IS NOT NULL) AND (TRIM(COALESCE(new.aart_txt,'')) = '' ) THEN
        SELECT a2_txt, a2_txt_rtf INTO new.aart_txt, new.aart_txt_rtf FROM ab2 WHERE a2_id = new.aart_a2_id;
      END IF;


      RETURN new;
     END $$ LANGUAGE plpgsql;

     CREATE TRIGGER anfart__b_iu_sync_abg
      BEFORE INSERT OR UPDATE OF aart_op_ix, aart_o2_n, aart_ab_ix, aart_o2_id, aart_a2_id
      ON anfart
      FOR EACH ROW
      EXECUTE PROCEDURE anfart__b_iu_sync_abg();
--


  CREATE OR REPLACE FUNCTION adk2__a2_waco__or__basis_w__by__a2_krz__get( _address_ident varchar ) RETURNS text AS $$
    DECLARE
        _result text;
    BEGIN

        _result := a2_waco FROM adk2 WHERE a2_krz = _address_ident;

        -- Fallback auf die Standardwährung
        _result := coalesce( _result, tsystem.settings__get( 'BASIS_W' ) );

        RETURN _result;

    END $$ LANGUAGE plpgsql STABLE;

-- Liste angefragter Lieferanten einer Anfrage.
CREATE TABLE anflief (
    alief_id                      serial PRIMARY KEY,

    -- Anfrage-ID
    alief_anf_nr                  varchar(30) NOT NULL REFERENCES anfrage ON DELETE CASCADE ON UPDATE CASCADE,
    alief_lkn                     varchar(21) NOT NULL REFERENCES adk ON UPDATE CASCADE,                                                  -- Lieferantenkürzel
    alief_lkontaktkrz             varchar(10),    -- Kurzname Ansprechpartner beim Lieferant
    alief_lkontakt                varchar(50),    -- Ansprechpartner beim Lieferant
    --
    alief_angNr                   varchar(30),    -- Angebotsnummer Lieferant
    alief_angtxt                  text,
    alief_angtxt_rtf              text,

    ----- Konditionen:
    alief_zak                     integer,        -- Zahlungsziel (in Tagen)
    alief_skv                     integer,        -- Skonto verfällt nach X Tagen
    alief_sks                     numeric(5,2),   -- Skontosatz
    alief_zakbem                  varchar(40),    -- Zahlungskond. Bemerkung
    alief_vers                    varchar(75),    -- Versandart
    alief_versandbem              text,           -- Bemerkung zum Versand
    alief_versandbem_rtf          text,

    -- Währung in der der Lieferant angefragt wurde
    alief_waer                    varchar(3) REFERENCES bewa,

    -- System (tables__generate_missing_fields)
    dbrid                         varchar(32) NOT NULL DEFAULT nextval( 'db_id_seq' ),
    insert_date                   date,
    insert_by                     varchar(32),
    modified_by                   varchar(32),
    modified_date                 timestamp(0)
);


 CREATE UNIQUE INDEX anflief_anfrage_lieferant_waerung ON anflief( alief_anf_nr, alief_lkn, alief_waer );
 CREATE INDEX anfLief_anf_nr ON anflief( alief_anf_nr );
 CREATE INDEX anfLief_lkn    ON anflief( alief_lkn );

CREATE OR REPLACE FUNCTION anflief__b_iu__default_waer__set() RETURNS trigger AS $$
  BEGIN

      IF new.alief_waer IS NULL THEN

          new.alief_waer := adk2__a2_waco__or__basis_w__by__a2_krz__get( new.alief_lkn );
      END IF;

      RETURN new;

  END $$ LANGUAGE plpgsql STABLE;

  CREATE TRIGGER anflief__b_iu__default_waer__set
  BEFORE INSERT OR UPDATE
  OF alief_waer
  ON anflief
  FOR EACH ROW EXECUTE PROCEDURE anflief__b_iu__default_waer__set();

  -- Trigger before Waehrung aus Stammdaten adk2

 -- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
 CREATE TRIGGER anflief_set_modified
  BEFORE INSERT OR UPDATE
  ON anflief
  FOR EACH ROW
  EXECUTE PROCEDURE table_modified();

 -- Öffnet alle Artikel der Anfrage wieder, falls ein neuer Lieferant hinzukommt
 CREATE OR REPLACE FUNCTION anflief__a_i_AnfArtSetDone() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE anfart SET
      aart_done = FALSE
   WHERE aart_anf_nr=new.aLief_anf_nr
     AND aart_done
     AND NOT aart_storno;

   RETURN new;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER anflief__a_i_AnfArtSetDone
  AFTER INSERT
  ON anflief
  FOR EACH ROW
  EXECUTE PROCEDURE anflief__a_i_AnfArtSetDone();
  --


 -- Entfernt man eine Lieferanten oder wird er umgehangen, werden die Erledigtstatus der AnfArt gesetzt.
 CREATE OR REPLACE FUNCTION anflief__a_ud_AnfArtSetDone() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP='UPDATE' AND new.aLief_anf_nr <> old.aLief_anf_nr THEN
        PERFORM anfart_setDone(old.aLief_anf_nr);
        PERFORM anfart_setDone(new.aLief_anf_nr);
        RETURN new;
    END IF;

    IF TG_OP='DELETE' THEN
        PERFORM anfart_setDone(old.aLief_anf_nr);
        RETURN old;
    END IF;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER anflief__a_ud_AnfArtSetDone
  AFTER DELETE OR UPDATE OF aLief_anf_nr
  ON anflief
  FOR EACH ROW
  EXECUTE PROCEDURE anflief__a_ud_AnfArtSetDone();
  --
--

-- Entfernt Lieferanten AnfArt.aart_alief_id wenn Lieferant von AnfLief gelöscht wird
CREATE OR REPLACE FUNCTION anflief__a_d__aart_alief_id__clean() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE
      anfart
    SET
      aart_alief_id = CASE
                        WHEN cardinality(aart_alief_id - ARRAY[old.alief_id]) = 0 THEN NULL
                      ELSE
                        aart_alief_id - ARRAY[old.alief_id]
                      END
    WHERE
          aart_alief_id IS NOT NULL
      AND aart_anf_nr = old.alief_anf_nr;

    RETURN old;
  END $$ LANGUAGE plpgsql;

 CREATE TRIGGER anflief__a_d__aart_alief_id__clean
  AFTER DELETE
  ON anflief
  FOR EACH ROW
  EXECUTE PROCEDURE anflief__a_d__aart_alief_id__clean();
--

 -- DMS - Verschlagwortung der Angebotsnummer des Lieferanten
  CREATE OR REPLACE FUNCTION anflief__a_iu_keywords_dms() RETURNS TRIGGER AS $$
  BEGIN
    -- WHEN (new.alief_angNr IS NOT NULL)
    IF (new.alief_angNr IS NOT NULL) THEN

        PERFORM TDMS.Dokument__keywords__update__by__pd_dbrid_dokident_doktype(
                              anfrage.dbrid,
                              'anglief',
                              'anfrage',
                              new.alief_id::varchar
                              )
           FROM anfrage
          WHERE anf_nr       = new.alief_anf_nr;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anflief__a_iu_keywords_dms
    AFTER INSERT OR UPDATE
    OF alief_angNr
    ON anflief
    FOR EACH ROW
    WHEN (new.alief_angNr IS NOT NULL)
    EXECUTE PROCEDURE anflief__a_iu_keywords_dms();

--Zahlungskonditionen zwischen anfrage und anflief vergleichen (True=gleich / False=unterschiedlich / NULL=keine vorhanden)
 CREATE OR REPLACE FUNCTION TEinkauf.anflief_CompareTermsOfPayment(aliefid integer) RETURNS boolean AS $$
  BEGIN
    IF       alief_zak IS null
         AND alief_skv IS null
         AND alief_sks IS null
         AND alief_zakbem IS null
         AND alief_vers IS null
         AND alief_versandbem IS null
         AND alief_versandbem_rtf IS null
        FROM anflief
       WHERE alief_id = aliefid
    THEN
        RETURN null;
    END IF;

    RETURN alief_zak IS NOT DISTINCT FROM anf_zak
       AND alief_skv IS NOT DISTINCT FROM anf_skv
       AND alief_sks IS NOT DISTINCT FROM anf_sks
       AND alief_zakbem IS NOT DISTINCT FROM anf_zakbem
       AND alief_vers IS NOT DISTINCT FROM anf_vers
       AND alief_versandbem IS NOT DISTINCT FROM anf_versandbem
       AND alief_versandbem_rtf IS NOT DISTINCT FROM anf_versandbem_rtf
      FROM anflief
      JOIN anfrage ON anf_nr = aLief_anf_nr
     WHERE alief_id = aliefid;
  END$$ LANGUAGE plpgsql;
--

--Zahlungskonditionen von anfrage in anflief übertragen
 CREATE OR REPLACE FUNCTION TEinkauf.anflief_InsertTermsOfPayment(aliefid integer, OnlyIfEmpty boolean DEFAULT True) RETURNS boolean AS $$
  BEGIN
    IF    NOT OnlyIfEmpty
       OR     TEinkauf.anflief_CompareTermsOfPayment(aliefid) IS null
    THEN
      UPDATE anflief
         SET alief_zak = anf_zak,
             alief_skv = anf_skv,
             alief_sks = anf_sks,
             alief_zakbem = anf_zakbem,
             alief_vers = anf_vers,
             alief_versandbem = anf_versandbem,
             alief_versandbem_rtf = anf_versandbem_rtf
        FROM anfrage
       WHERE anf_nr = aLief_anf_nr
         AND alief_id = aliefid;

      RETURN True;
    ELSE
      RETURN False;
    END IF;
  END$$ LANGUAGE plpgsql;
--


-- Eingegangene Angebote auf eine Anfrage
CREATE TABLE anfangebot
  (aang_id                  serial PRIMARY KEY,
   aang_aLief_id            integer NOT NULL REFERENCES anflief ON UPDATE CASCADE ON DELETE CASCADE, -- Lieferant der Angebot unterbreitet
   aang_aArt_id             integer NOT NULL REFERENCES anfart ON UPDATE CASCADE ON DELETE CASCADE,  -- Angefragter Artikel
   aang_preis               numeric,                                -- Angebotener Preis für Artikel
   aang_preiseinheit        numeric(14,4) NOT NULL DEFAULT 1 CONSTRAINT anfangebot__chk__preiseinheit CHECK ( aAng_preiseinheit > 0), -- Menge, auf die sich die Preisangabe bezieht, Bsp: 100 Stk.
   aang_ep                  numeric(20,8) NOT NULL DEFAULT 0,       -- Preis pro Mengeneinheit. Bsp: 0,0499
   aang_ep_basis_w          numeric(20,8) NOT NULL DEFAULT 0,       -- Preis in Eigenwährung
   aang_Rabatt              numeric NOT NULL DEFAULT 0,             -- Vorgeschlagener Rabatt für Artikel
   aang_Waer                varchar(3) NOT NULL REFERENCES bewa,    -- Währung für Preis --> Vorgabe im Trigger anfangebot__b_05_iu__stkvkpuf1
   aang_Netto               numeric(16,4) NOT NULL DEFAULT 0,       -- Positionswert inkl. AbZuschläge
   aang_Netto_Basis_w       numeric(16,4) NOT NULL DEFAULT 0,       -- Positionswert inkl. AbZuschläge in Basis Währung
   aang_datum               date DEFAULT current_date,
   aang_ka                  boolean DEFAULT FALSE,                  -- (Kein Angebot) Für diese Position kann kein Angebot unterbreitet werden
   aang_txt                 text,                                   -- Angebotstext, vorgefüllt aus Anfragepositionstext, bearbeitbar, übernommen in Bestellung
   aang_txt_rtf             text,
   aang_txtint              text,
   aang_txtint_rtf          text,
   aang_steucode            integer REFERENCES steutxt,             -- Steuertyp für Angebot
   aang_steuproz            numeric(5,2) NOT NULL DEFAULT 0,        -- Steuersatz in %
   aang_isInEpreis          boolean NOT NULL DEFAULT FALSE,         -- Das Angebot wurde schon in Epreis übernommen
   aang_isInAuswPreis       boolean NOT NULL DEFAULT FALSE,         -- Das Angebot wurde schon in Ausw.bearbeiter / Preise übernommen.
   aang_lieferzeit          integer NOT NULL DEFAULT 0,             -- Lieferzeit in Tagen die der Lieferant für das Teil braucht.
   aang_lieferdatumb        date,                                   -- Lieferdatum bestätigt vom Lieferanten
   aang_akref               varchar(40),                            -- Artikel-Ref.(Lieferant) -> e_best
   aang_los                 numeric(12,2) CONSTRAINT anflief__aang_los__positive   CHECK ( aang_los   > 0 ), -- Losgröße
   aang_menge               numeric(12,4) CONSTRAINT anflief__aang_menge__positive CHECK ( aang_menge > 0 ), -- Angebotsmenge
   aang_lkn_lg_anztot       numeric(12,4),                          -- beim Lieferanten lagernde Menge
   aang_ep_last_updatetime  timestamp,                              -- Zeitpunkt wann Preis zuletzt aktualisiert wurde
   aang_gdatum              date DEFAULT current_date,              -- Gültigkeit in Lieferantenangeboten Datum ab
   aang_bisdatum            date                                    -- Gültigkeit in Lieferantenangeboten Datum bis
  );

  CREATE INDEX anfangebot_alief_id ON anfAngebot(aang_alief_id);
  CREATE INDEX anfangebot_aart_id  ON anfAngebot(aang_aart_id);

  -- Setzt AnfArt-Erledigtstatus in Abhängigkeit der Angebotsstatus
  CREATE OR REPLACE FUNCTION anfangebot__a_iud_AnfArtSetDone() RETURNS TRIGGER AS $$
   BEGIN
    IF TG_OP='DELETE' THEN
        PERFORM anfart_setDone((SELECT aart_anf_nr FROM anfangebot JOIN anfart ON aart_id = aang_aart_id WHERE aang_id = old.aang_id));
        RETURN old;
    ELSE -- INSERT UPDATE
        PERFORM anfart_setDone((SELECT aart_anf_nr FROM anfangebot JOIN anfart ON aart_id = aang_aart_id WHERE aang_id = new.aang_id));
        IF TG_OP = 'UPDATE' AND new.aang_aart_id <> old.aang_aart_id THEN
            PERFORM anfart_setDone((SELECT aart_anf_nr FROM anfangebot JOIN anfart ON aart_id = aang_aart_id WHERE aang_id = old.aang_id));
        END IF;
        RETURN new;
    END IF;
   END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anfangebot__a_iud_AnfArtSetDone
   AFTER INSERT OR DELETE OR UPDATE OF aAng_preis, aAng_ka, aAng_aArt_id
   ON anfangebot
   FOR EACH ROW
   EXECUTE PROCEDURE anfangebot__a_iud_AnfArtSetDone();

  CREATE OR REPLACE FUNCTION anfangebot__b_05_iu__stkvkpuf1() RETURNS trigger AS $$
    BEGIN

        new.aAng_preiseinheit := coalesce( new.aang_preiseinheit, 1 );

        IF new.aang_waer IS null THEN

            -- währung aus Lieferrantenanfrage übernehmen
            new.aang_waer := alief_waer FROM anflief WHERE alief_id = new.aang_alief_id;

        END IF;

        IF ( TG_OP = 'INSERT' ) THEN

            -- Kein manueller Preis angegeben, aang_ep vom System irgendwoher gefüllt -> aang_preis zurückrechnen.
            IF new.aang_preis = 0 AND new.aang_ep <> 0 THEN
                new.aang_preis := new.aang_ep * new.aang_preiseinheit;
            ELSE
                -- aang_preis wurde angegeben oder alles ist 0
                new.aang_ep := coalesce( new.aang_preis, 0 ) / Do1If0( new.aang_preiseinheit );
            END IF;
        END IF;

        IF ( TG_OP = 'UPDATE' ) THEN

            -- Preis / PE geändert
            IF
                   new.aang_preis IS DISTINCT FROM old.aang_preis
                OR new.aang_preiseinheit IS DISTINCT FROM old.aang_preiseinheit
            THEN

                new.aang_ep := coalesce( new.aang_preis, 0 ) / Do1If0( new.aang_preiseinheit );
            ELSE
                 -- aang_ep geändert und Preis / PE gleich -> Preis zurückrechnen.
                 IF new.aang_ep <> old.aang_ep THEN
                     new.aang_preis := new.aang_ep * new.aang_preiseinheit;
                 END IF;

            END IF;
        END IF;

        RETURN new;

    END $$ LANGUAGE plpgsql;
  --

  CREATE TRIGGER anfangebot__b_05_iu__stkvkpuf1
    BEFORE INSERT OR UPDATE OF aAng_preis, aAng_preiseinheit, aAng_ep
    ON anfangebot
    FOR EACH ROW
    EXECUTE PROCEDURE anfangebot__b_05_iu__stkvkpuf1();
--

CREATE OR REPLACE FUNCTION anfangebot_menge_wert_recalculate( _data anfangebot ) RETURNS void AS $$
  DECLARE
      _abzunetto         numeric;
      _faktor            numeric;
      _kurs              numeric;
      _new_netto         numeric;
      _new_ep_basis_w    numeric;
      _new_netto_basis_w numeric;
  BEGIN
      -- Kurs bestimmen
      _kurs := coalesce( waerkurs( _data.aang_Waer ), 1 );
      -- Einzelpreis in Basiswährung füllen
      _new_ep_basis_w := coalesce( _data.aang_ep, 1 ) * _kurs;
      -- rabattierten Preis berechnen
      _faktor := 1 - ( _data.aang_rabatt / 100 );
      -- Abzüge/Zuschläge = (Anzahl * Betrag)
      _abzunetto := sum( anfaz_betr * anfaz_anz ) FROM anfabzu WHERE anfaz_aang_id = _data.aang_id;

      -- Positionssummen
      _new_netto :=
            _data.aang_menge * coalesce( _data.aang_ep, 1 ) * _faktor
          + coalesce( _abzunetto, 0 )
      ;

      -- Positionssummen in Basiswährung
      _new_netto_basis_w := _new_netto * _kurs;

      UPDATE anfangebot SET
        aAng_ep_basis_w = _new_ep_basis_w,
        aAng_netto = _new_netto,
        aAng_netto_basis_w = _new_netto_basis_w
      WHERE aAng_id = _data.aAng_id;

  END $$ LANGUAGE plpgsql;
--

  CREATE OR REPLACE FUNCTION anfangebot__a_iu__menge_wert__recalculate() RETURNS TRIGGER AS $$
    BEGIN
       PERFORM anfangebot_menge_wert_recalculate( new );
       RETURN new;
    END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER anfangebot__a_iu__menge_wert__recalculate
    AFTER INSERT OR UPDATE OF aAng_preis, aAng_preiseinheit, aAng_ep, aAng_rabatt, aAng_Waer, aang_menge
    ON anfangebot
    FOR EACH ROW
    EXECUTE PROCEDURE anfangebot__a_iu__menge_wert__recalculate();
--

CREATE OR REPLACE FUNCTION anfangebot__b_70_iu__aang_los() RETURNS trigger AS $$
  BEGIN

      -- Die Losgröße wird initial von der Lieferantenanfrage übernommen.
      new.aang_los :=
          aart_los
          FROM anfart
          WHERE anfart.aart_id = new.aang_aart_id
      ;

      RETURN new;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anfangebot__b_70_iu__aang_los
    BEFORE INSERT OR UPDATE
    ON anfangebot
    FOR EACH ROW
    WHEN ( new.aang_los IS NULL )
    EXECUTE PROCEDURE anfangebot__b_70_iu__aang_los();
--

CREATE OR REPLACE FUNCTION anfangebot__b_70_iu__aang_menge() RETURNS trigger AS $$
  BEGIN

      -- Die Angebotsmenge wird initial von der Lieferantenanfrage übernommen.
      new.aang_menge :=
          aart_menge
          FROM anfart
          WHERE anfart.aart_id = new.aang_aart_id
      ;

      RETURN new;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anfangebot__b_70_iu__aang_menge
    BEFORE INSERT OR UPDATE
    ON anfangebot
    FOR EACH ROW
    WHEN ( new.aang_menge IS NULL )
    EXECUTE PROCEDURE anfangebot__b_70_iu__aang_menge();
--

CREATE OR REPLACE FUNCTION anfangebot__a_u__menge() RETURNS TRIGGER AS $$
  BEGIN
      PERFORM teinkauf.anfangebot__update__aang_epreis__epreisstaffel( new.aang_id, new.aang_menge );

      RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anfangebot__a_u__menge
    AFTER UPDATE OF aang_menge
    ON anfangebot
    FOR EACH ROW
    EXECUTE PROCEDURE anfangebot__a_u__menge();
 --

CREATE OR REPLACE FUNCTION anfangebot__b_i_aang_akref() RETURNS TRIGGER AS $$
  DECLARE
    _aknr varchar;
    _lkn varchar;
  BEGIN

    -- übernimmt die Artikelreferenz aus der letzen passenden Bestellung,
    -- die nicht länger als ein Jahr zurückliegt
    -- und wenn keine Artikelreferenz manuell vorgegeben ist
    -- und dise Funktionalität in den dynamischen Settings aktiviert wurde

    _aknr := aart_ak_nr FROM anfart WHERE aart_id = new.aang_aart_id;
    _lkn := alief_lkn FROM anflief WHERE alief_id = new.aang_alief_id;

    IF tsystem.settings__getbool('aang_akref__ldsdok') THEN

      new.aang_akref := ld_bem
        FROM ldsdok
        WHERE ld_aknr = _aknr
        AND ld_kn = _lkn
        AND ld_bem IS NOT null
        AND ld_datum >= current_date - 365
        ORDER BY ld_datum DESC
        LIMIT 1;

    ELSE

      new.aang_akref := e_best
        FROM epreis
        WHERE e_aknr = _aknr
        AND e_lkn = _lkn
        AND e_best IS NOT null
        AND ( e_bisdatum IS null OR e_bisdatum >= current_date )
        ORDER BY e_gdatum DESC
        LIMIT 1;

    END IF;

    RETURN new;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER anfangebot__b_i_aang_akref
    BEFORE INSERT
    ON anfangebot
    FOR EACH ROW
    WHEN ( new.aang_akref IS null )
    EXECUTE PROCEDURE anfangebot__b_i_aang_akref();
  --

/* Loll-Trigger *****************************************************************************************
 Trigger ist im Loll-System eingespielt. Benachrichtigt BANF-Ersteller über neue Angebote auf Banf.
 Nachfragen ob noch notwendig/gewünscht/funktionierend und dann wieder einkommentieren oder weglassen.
 ******************************************************************************************

 CREATE FUNCTION anfangebot__a_i() RETURNS TRIGGER AS $$
 DECLARE minr VARCHAR;
     banr VARCHAR;
     bapos INTEGER;
     anfnr VARCHAR;
     anfpos INTEGER;
 BEGIN

  --Erstmal Anfragenummer und Position des Artikels in Anfrage holen
  SELECT aArt_anf_nr, aart_pos INTO anfnr, anfpos FROM anfart WHERE aart_id = new.aang_aart_id;

  -- Jetzt schauen, ob wir dafür Bestellanforderungen finden
  SELECT bap_banr,bap_pos,bestanfpos.insert_by INTO banr,bapos,minr FROM bestanfpos WHERE bap_bestellnr = anfnr AND bap_bestellpos = anfpos;

  IF NOT ((banr IS NULL) OR (bapos IS NULL) OR (minr IS NULL)) THEN
     PERFORM
         msg_SendMsg(CAST(current_user AS VARCHAR), 'Neues Angebot - Bestellanforderung '||banr||', Position '||bapos, '', CAST(minr AS VARCHAR));
  END IF;

  RETURN new;
 END$$LANGUAGE plpgsql;

 CREATE TRIGGER anfangebot__a_i
 AFTER INSERT
 ON anfangebot
 FOR EACH ROW
 EXECUTE PROCEDURE anfangebot__a_i();
 */
--


-- Ab- und Zuschläge für die Angebotspositionen
CREATE TABLE anfabzu (                                                                            -- VIEWFELDER
  anfaz_id            SERIAL PRIMARY KEY,                                                           --  ID des Zuschlags
  anfaz_type          VARCHAR(1)  DEFAULT 'E',                                                      --  Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
  anfaz_pos           INTEGER,                                                                      --  Position
  anfaz_abz_id        INTEGER NOT NULL REFERENCES abzu,                                             --  ID der Vorgabe
  anfaz_aang_id       INTEGER NOT NULL REFERENCES anfangebot ON UPDATE CASCADE ON DELETE CASCADE,   --  ID des Datensatzes an dem der Zuschlag hängt
  anfaz_anz           NUMERIC NOT NULL DEFAULT 1,                                                   --  Anzahl / Menge
  anfaz_betr          NUMERIC NOT NULL DEFAULT 0,                                                   --  Betrag in Währung des Parent-Datensatzes
  anfaz_proz          NUMERIC,                                                                      --  Prozentualer Zuschlag auf Basis des Parent-Betrags
  anfaz_canSkonto     BOOLEAN NOT NULL DEFAULT TRUE,                                                --  Gilt Skonto für den Zuschlag?
  anfaz_steucode      INTEGER REFERENCES steutxt,                                                   --  Steuercode (meist gleich Parent)
  anfaz_steuproz      NUMERIC(5,2) NOT NULL DEFAULT 0,                                              --  Prozentsatz der Steuer
  anfaz_konto         VARCHAR(25),                                                                  --  Kontierung
  anfaz_visible       BOOLEAN NOT NULL DEFAULT TRUE,                                                --  Auf Dokument sichtbar oder nicht?
  anfaz_zutxt         TEXT,                                                                         --  Zusätzlicher Hinweistext
  anfaz_zutxt_rtf     TEXT,                                                                         --  Zusätzlicher Hinweistext (RTF)
  anfaz_zutxt_int     TEXT,                                                                         --  Interner zusatztext (erscheint nicht auf Dokumenten)
  anfaz_source_table  VARCHAR(40),                                                                  --  Aus welcher Quelle wurde Abzu hierhin kopiert
  anfaz_source_dbrid  VARCHAR(32),                                                                  --  Aus welchem Datensatz wurde Abzu hierhin kopiert
  CHECK (anfaz_proz <> 0::numeric)
);

 CREATE UNIQUE INDEX anfangebot_aLief_aArt_anfID ON anfangebot(AAng_aLief_id,aAng_aArt_id);
--
 -- Positions-Werte des Angebots neu bestimmen
  CREATE OR REPLACE FUNCTION anfabzu__a_iud__anfangebot_recalculate() RETURNS TRIGGER AS $$
   DECLARE _aang_id integer;
   BEGIN
     IF tg_op = 'DELETE' THEN
        _aang_id := old.anfaz_aang_id;
     ELSE
        _aang_id := new.anfaz_aang_id;
     END IF;

     PERFORM anfangebot_menge_wert_recalculate( anfangebot )
        FROM anfangebot
       WHERE aang_id = _aang_id;

    RETURN new;
   END $$ LANGUAGE plpgsql;
--
 CREATE TRIGGER anfabzu__a_iud__anfangebot_recalculate
  AFTER INSERT OR UPDATE OR DELETE
  ON anfabzu
  FOR EACH ROW
  EXECUTE PROCEDURE anfabzu__a_iud__anfangebot_recalculate();

-- Sucht aus Angeboten für eine Position das günstigste heraus
 CREATE OR REPLACE FUNCTION bestePreis(_artid INTEGER) RETURNS INTEGER AS $$
  BEGIN
   -- Nettopreis in Basiswährung abfragen, sortieren und 1. Wert zurückgeben
   RETURN aAng_aLief_id
   FROM anfangebot
   WHERE aAng_aArt_ID = _artid AND aang_preis IS NOT NULL AND NOT aAng_ka
   ORDER BY aang_netto_basis_w ASC
   LIMIT 1;
  END $$ LANGUAGE plpgSQL;
--

-- Berechnet (Netto)Summe für Position mit Rabatt und Menge. Abzu bei Bedarf.
  CREATE OR REPLACE FUNCTION getAngebotArtPreis(
      _angid integer,
      _withabzu boolean = false
    ) RETURNS numeric AS $$
    DECLARE
       _rec    record;
       _az_sum numeric(12,4) := 0;
    BEGIN

        SELECT aAng_ep, aAng_Rabatt, aArt_menge
          INTO _rec
          FROM anfAngebot
          JOIN anfArt ON aang_aart_id = aArt_id
         WHERE aAng_id = _angid;

        IF _withabzu THEN

            _az_sum :=
                sum(
                      coalesce( anfaz_anz, 0 )
                    * coalesce( anfaz_betr, 0 )
                )
                FROM anfabzu
                WHERE anfaz_aang_id = _angid
            ;

        END IF;

        RETURN
            _rec.aAng_ep
          * ( 1 - _rec.aAng_Rabatt / 100 )
          * _rec.aArt_menge
          + coalesce( _az_sum, 0 );

    END $$ LANGUAGE plpgsql;
--

-- Erzeugt eine Bestellposition aus dem Angebot eines Lieferanten, kopiert Zuschläge
CREATE OR REPLACE FUNCTION TEinkauf.anfrage_angebotZuBest(
    IN _aAngID      integer,
    IN _ldauftg     varchar
    )
    RETURNS integer
    AS $$
    DECLARE
        _ang        record;
        _az         record;
        _me         integer;
        _ldid       integer;
        _ncnum      integer;
        _banfnr     varchar(50);
        _bapid      integer;
        _bvp_id     integer;
        _akbtxt     text;
        _akbtxtrtf  text;
        _raddress   varchar;
        _laddress   varchar;
        _recs_artPruefung  artPruefung[];
        rec         record;
    BEGIN

        SELECT anfAngebot.*, anfArt.*, anfLief.aLief_lkn, anfLief.aLief_lkontakt, anfLief.aLief_lkontaktkrz, aLief_angNr, anfrage.*
          INTO _ang
          FROM anfAngebot
          JOIN anfArt  ON aAng_aArt_id = aArt_id
          JOIN anfLief ON aLief_id     = aAng_aLief_id
          JOIN anfrage ON aLief_anf_nr = anf_nr
         WHERE aAng_id = _aAngID
         ORDER BY aArt_pos;

        SELECT m_id INTO _me FROM artmgc WHERE m_ak_nr = _ang.aArt_ak_nr AND m_mgcode = _ang.aArt_m_id;

        IF _me IS NULL THEN
          RAISE EXCEPTION 'xtt4064 ("%")', _ang.aArt_ak_nr;
        END IF;

        --Bestelltext-Vorgabe aus Artikelstamm
        -- #7715
        SELECT
               (tartikel.adtx_getArtTxtLang(ak_nr, 'EK', _ang.aLief_lkn)).txt    AS ak_bestxt,
               (tartikel.adtx_getArtTxtLang(ak_nr, 'EK', _ang.aLief_lkn)).txtrtf AS ak_bestxt_rtf
          INTO _akbtxt, _akbtxtrtf
          FROM art
         WHERE ak_nr = _ang.aArt_ak_nr;

        --Wenn im Angebot selbst was steht, nehmen wir aber den.
        IF trim(coalesce(_ang.aAng_txt, '')) <> '' THEN
           _akbtxt    := _ang.aAng_txt;
           _akbtxtrtf := coalesce(_ang.aAng_txt_rtf, '');
        END IF;

        --Für die Position gibt's noch keine Bestellung, Preis ist vorhanden
        IF (_ang.aArt_ldid IS null) AND (_ang.aAng_preis IS NOT null) THEN

            IF current_user = 'root' then
              RAISE NOTICE 'anfrage_angebotZuBest - %', _aAngID;
            END IF;

            -- Bestellanforderungsnummer an Einkauf weitergeben #8647
            SELECT bap_id, bap_banr ||'-P-'|| (bap_pos::varchar) INTO _bapid, _banfnr FROM bestanfpos WHERE bap_aart_id = _ang.aart_id;

            -- Eigene Liefer- und Rechnungsadresse, ggf. abweichend
            _laddress := tadk.get_vorg_ladress( '#' );
            _raddress := tadk.get_vorg_radress( '#' );

            -- Neue Bestellung Anlegen
            INSERT INTO ldsdok (
              ld_code, ld_auftg, ld_krzl, ld_krzf,
              ld_aknr, ld_akbz, ld_kn,
              ld_stk, ld_preis, ld_arab,
              ld_termweek, ld_term, ld_waer, ld_preiseinheit, ld_ekref, ld_mce, ld_nident, ld_an_nr,
              ld_lkontakt, ld_lkontaktkrzl, ld_txt, ld_txt_rtf, ld_txtint, ld_txtint_rtf, ld_aAng_id,
              ld_konto, ld_ks, ld_steucode, ld_steuproz, ld_kontakt, ld_anfnr, ld_banfnr,
              ld_bem
            ) VALUES (
              'E', _ldauftg, _laddress, _raddress,
              _ang.aArt_ak_nr, _ang.aArt_bez, _ang.aLief_lkn,
              _ang.aang_menge, _ang.aAng_preis, _ang.aAng_rabatt,
              _ang.aArt_termweek, _ang.aArt_termin, _ang.aAng_waer, coalesce( _ang.aAng_preiseinheit, 1 ), _ang.aLief_angNr, _me, _ang.anf_nident, _ang.anf_an_nr,
              _ang.aLief_lkontakt, _ang.aLief_lkontaktkrz,_akbtxt, _akbtxtrtf, _ang.aAng_txtint, _ang.aAng_txtint_rtf, _ang.aAng_id,
              _ang.aArt_konto, _ang.aArt_ks, _ang.aAng_steucode, _ang.aAng_steuproz, _ang.anf_apint, _ang.aArt_anf_nr, _banfnr,
              _ang.aAng_akref
            ) RETURNING ld_id INTO _ldid;

            --Ab- und Zuschläge für Bestellung übernehmen
            PERFORM TWawi.Abzu_Copy('AnfAngebot_Abzu', _aAngID::varchar, 'Ldsdok_Abzu', _ldid::varchar, _ang.aang_menge);

            -- ID im Angebot speichern damit wir Bestellnummer bei Bestellung eines anderen Angebotes der gleichen Anfrage wiederverwenden können
            UPDATE anfart SET aArt_ldid = _ldid WHERE aArt_id = _ang.aArt_id;
            -- Wenn Anfrage aus Bestellvorschlag kam, dann Verknüpfung herstellen! -- ldsauftg wird damit auch automatisch verbunden! Hinweis: bvp_ldsduftg_dolink wurde bereits beim Erstellen der Anfrage aus dem BSV gesetzt (wir sind jetz bei Angebot => Bestellung)
            UPDATE BestVorschlagPos SET bvp_einkauf_p_id = _ldid WHERE bvp_aArt_id = _ang.aAng_aArt_id AND bvp_einkauf_p_id IS null RETURNING bvp_id INTO _bvp_id;

            -- Bestellung und Banf-Position verknüpfen #8647 -- ACHTUNG, nach BestVorschlagPos da sonst bestanfpos__a_50_iu__bap_ld_id__ldsauftg_link einen neuen ldsauftg Record anlegt
            UPDATE bestanfpos SET bap_ld_id = _ldid WHERE bap_id = _bapid AND bap_ld_id IS null;


            -- Kontrollmerkmale anhängen
            _recs_artPruefung  :=      array_agg( jsonb_populate_record( null::artPruefung, x.out_recs_artPruefung ) )
                                  FROM (
                                         SELECT unnest AS out_recs_artPruefung
                                           FROM unnest( twawi.einkauf__artPruefung__create__from__bestellvorschlag__jsonb(_bvp_id) )
                                       ) AS x;
            FOR rec IN
                SELECT * FROM unnest(_recs_artPruefung)
            LOOP
                INSERT INTO artpruefungtest
                       ( aprt_apr_id, aprt_ldid, aprt_pos, aprt_bez )
                VALUES ( rec.apr_id, _ldid, rec.apr_pos, rec.apr_bez );
            END LOOP;


        ELSE
            IF current_user='root' then
              RAISE NOTICE 'anfrage_angebotZuBest - SKIP - % - _ang.aArt_ldid - % - ep %, ', _aAngID, _ang.aArt_ldid, _ang.aAng_preis;
            END IF;
        END IF;

        RETURN _ldid;
    END $$ LANGUAGE plpgsql;
--
/******************** BANF - Bestellanforderungen *************************************************************************/

 -- Kopfdaten für Bestellanforderungen (BANF)
 CREATE TABLE bestanftxt (
   ba_nr         varchar(40) PRIMARY KEY,                        -- Nr. der Bestellanforderung
   ba_titel      varchar(100),                                   -- Titelfeld für Workorder
   ba_txt        text,                                           -- Hinweistexte
   ba_txt_rtf    text,
   ba_termweek   varchar(7),                                     --Terminwoche
   ba_dat        date,                                           -- Antwort/Bestellung bis zu dem Datum benötigt
   ba_prognose   boolean NOT NULL DEFAULT false CONSTRAINT prognose_not_allowed CHECK (ba_prognose IS false), -- Prognose aktuell deaktiviert. Konflikt mit "Nur Anfrage" (bap_doanfrage). Prognose wird in bedarfsberechnung aufgenommen, obwohl nur Anfrage. Ganzes Konzept Prognose ist zu hinterfrange
   ba_doeinkauf  boolean NOT NULL DEFAULT true                      -- Freigabe Einkauf, im Standard freigegeben
  );
 --


 -- Positionen für Bestellanforderungen (BANF)
  -- Bestellanforderungen - von AVOR erstellt, vom Einkauf realisiert. AVOR sagt sie braucht n-Stück von Teil X, darf
  -- aber keine Preise vorgeben. Der Einkäufer schaut sich die Bestellanforderung an und weißt eventuell schon Lieferant und Preise
  -- zu, bevor er eine Bestellung auslöst. Im Zweifelsfall wird eine Anfrage erstellt und die aktuellen Preise darüber eingeholt
  -- oder Angebote alternativer Lieferanten eingeholt.

 CREATE TABLE bestanfpos (
   bap_id                serial PRIMARY KEY,
   bap_pos               integer NOT NULL,                                  -- Positions-Nummer in Bestellanforderung
   bap_parent_id         integer REFERENCES bestanfpos ON DELETE CASCADE,   -- Unterpositionen zur Position

      -- Autooder DROP todo: Delphi Oberfläche wegwerfen
      bap_autoorder         boolean NOT NULL DEFAULT FALSE,

   -- Prognose
   bap_prognose          boolean NOT NULL DEFAULT false CONSTRAINT prognose_not_allowed CHECK (bap_prognose IS false), -- Prognose aktuell deaktiviert. Konflikt mit "Nur Anfrage" (bap_doanfrage). Prognose wird in bedarfsberechnung aufgenommen, obwohl nur Anfrage. Ganzes Konzept Prognose ist zu hinterfrange
   bap_pr_ag_id          integer REFERENCES auftg ON DELETE CASCADE,        -- Prognoseposition zu Auftrag (hält auch bei Stücklistenunterpositionen die ag_id Auftrag)
   bap_pr_ld_id          integer REFERENCES ldsdok ON DELETE CASCADE,       -- Prognoseposition zu Einkauf/PA (hält auch bei Stücklistenunterpositionen die ag_id Auftrag)
   bap_pr_done           boolean NOT NULL DEFAULT FALSE,                       -- Wenn ABK ausgelöst, Bestellung zu Verkauf ohne ABK ausgelöst, werden die prognostizierten Teile geschlossen
   --
   bap_banr              varchar(40) NOT NULL REFERENCES BestAnfTxt ON UPDATE CASCADE ON DELETE CASCADE, -- Für welche Bestellanforderung
   bap_aknr              varchar(40) NOT NULL,                              -- Artikel der angefragt/bestellt werden soll
   bap_akbez             varchar(100),                                      -- Artikelbezeichnung separat, falls Artikel frei gewählt ohne Stammdaten
   bap_menge             numeric NOT NULL,                                  -- Wieviel
   bap_menge_uf1         numeric(12,4),                                     -- Falls möglich, hier Menge in UF1. Nur möglich, wenn der Artikel die angegebene Mengeneinheit auch in den Stammdaten angegeben hat
   bap_menge_best_uf1    numeric(12,4) NOT NULL DEFAULT 0,                  -- Menge bestellt (eingekauft)
   bap_mecod             integer NOT NULL REFERENCES mgcode,                -- In welcher Mengeneinheit
   -- Zuschnitte
   bap_o6_dimi           varchar(50),                                       -- Freie  Zusatzeingabe Zuschnitt
   bap_o6_stkz           integer,                                           -- Stück  Zuschnitt
   bap_o6_lz             numeric(12,4),                                     -- Länge  Zuschnitt
   bap_o6_bz             numeric(12,4),                                     -- Breite Zuschnitt
   bap_o6_hz             numeric(12,4),                                     -- Höhe   Zuschnitt
   bap_o6_zz             numeric(12,4),                                     -- Zugabe Zuschnitt
   bap_o6_zme            integer REFERENCES mgcode,                         -- ZuschnittME
   --
   bap_termin            date,                                              -- Bis wann vorhanden sein muss
   bap_termweek          varchar(7),                                        -- Terminwoche
   --
   bap_agnr              varchar(40),                                       -- Freie Referenz auf den Auftrag
   bap_agpos             integer,                                           -- Auftragsposition. Ggf. uebernehmen wir aus der Position die Norm in die Bestellung
   bap_an_nr             varchar(50) REFERENCES anl ON UPDATE CASCADE,      -- Projektnummer
   --
   bap_txt               text,                                              -- Positionszusatztext
   bap_txt_rtf           text,
   bap_txtint            text,                                              -- Positionszusatztext (intern)
   bap_txtint_rtf        text,
   bap_lagzu_txt         text,                                              -- Zusatztext, der beim Lagerzugang des Artikels als Hinweis angezeigt werden soll.
   bap_lagzu_txt_rtf     text,                                              -- Wird in Bestellung (ld_lagzu_txt) zur BANF kopiert.
   --
   bap_minr              varchar(10),                                       -- Wird bearbeitet von Mitarbeiter Nr. ... ACHTUNG: das ist nicht mehr die MiNr, sondern der DBUseName
   bap_doeinkauf         boolean NOT NULL DEFAULT TRUE,                     -- Freigabe Einkauf, im Standard freigegeben
   bap_anfrage           boolean NOT NULL DEFAULT FALSE,                    -- Nur Anfragen für den Artikel
   bap_rahmen            boolean NOT NULL DEFAULT FALSE,                    -- Für die Position soll ein Rahmenvertrag abgeschlossen / angelegt werden
   bap_done              boolean NOT NULL DEFAULT FALSE,                    -- Anfrage/Bestellung erledigt
   --
   bap_lkn               varchar(21) REFERENCES adk ON UPDATE CASCADE,      -- Vorgeschlagener Lieferant für Anfrage/Bestellung
   bap_ep_uf1_basisw     numeric,                                           -- Preis in GME und Eigenwährung
   bap_rab               numeric(5,2),                                      -- Rabatt (laut Lieferantendaten oder manuell eingegeben)
   bap_ks                varchar(9) REFERENCES ksv,                         -- Vorgabe Kostenstelle (für Übernahme in Anfrage, Einkauf)
   bap_konto             varchar(25),                                       -- Vorgabe Kontierung (für Übernahme in Anfrage, Einkauf)
   -- Alternativmaterial
   bap_aMat_nr           varchar(40),                                       -- Nummer
   bap_aMat_bez          varchar(100),                                      -- Bezeichnung
   bap_aMat_txt          text,                                              -- Memo mit Freitext
   bap_aMat_status       varchar(5),                                        -- Status (Freigabe, Prüfung, etc.)
   -- Bestellanforderung auf Auswärtsbearbeitung (NUR ASK, ABK wird nicht unterstützt)
   bap_op_ix             integer REFERENCES opl ON UPDATE CASCADE,          -- Stammkarte für die angefragt werden soll
   bap_o2_n              integer,                                           -- "Pseudo" - Arbeitsgang: Wenn gesetzt, ist das eine Auswärtsbearbeitungs-Banf. Wenn bap_o2_id nicht gefunden wird, ist da "Frei"
   bap_o2_id             integer REFERENCES op2 ON UPDATE CASCADE,          -- Arbeitsgang (aus ASK) für Banf auf Auswärtsvergaben

   bap_ag_id             integer REFERENCES auftg ON UPDATE CASCADE ON DELETE CASCADE, -- ABK-Materialposition / Verkaufsauftrag, welche um diese BANF erweitert wird.
   --Anforderung wurde übernommen in Anfrage/Bestellung:
   bap_ld_id             integer REFERENCES ldsdok ON UPDATE CASCADE ON DELETE SET NULL,  -- verknüpften Bestellung, zu welcher diese Bestellanforderung gehört
   bap_aArt_id           integer REFERENCES anfart ON UPDATE CASCADE ON DELETE SET NULL   -- zugehörige Anfrage
 );

 -- Indizes (BANF)
     CREATE INDEX bestanfpos__bap_banr ON bestanfpos (bap_banr);
     CREATE INDEX bestanfpos__bap_banr_like ON bestanfpos (bap_banr varchar_pattern_ops);
     CREATE INDEX bestanfpos__bap_aknr ON bestanfpos (bap_aknr);
     CREATE INDEX bestanfpos__bap_aknr_like ON bestanfpos (bap_aknr varchar_pattern_ops);
     CREATE INDEX bestanfpos__bap_parent_id ON bestanfpos (bap_parent_id) WHERE bap_parent_id IS NOT NULL;
     -- Erweiterung #15324
       -- ABK-Materialpos (auftgi) kann nur einmal um BANF-Pos erweitert werden.
       -- Ohne Unique wäre eine Dopplung der Anzeige in ABK Materialliste möglich.
     CREATE UNIQUE INDEX bestanfpos__bap_ag_id ON bestanfpos (bap_ag_id) WHERE bap_ag_id IS NOT NULL;
     CREATE INDEX bestanfpos__bap_ld_id ON bestanfpos (bap_ld_id) WHERE bap_ld_id IS NOT NULL;
     CREATE INDEX bestanfpos__bap_aArt_id ON bestanfpos (bap_aArt_id) WHERE bap_aArt_id IS NOT NULL;
     CREATE INDEX bestanfpos__bap_termin ON bestanfpos(bap_termin);
     CREATE INDEX bestanfpos__ym_bap_termin ON bestanfpos(date_to_yearmonth(bap_termin));
 --

 -- Zuschnittsmenge + ME umrechnen
 CREATE OR REPLACE FUNCTION bestanfpos__b_iu() RETURNS TRIGGER AS $$
   DECLARE
           uf numeric(12,4);
   BEGIN
     -- Neu angelegt, keine Auswärtsvergabe und noch kein Text? Dann ggf. aus Bestelltext Artikel füllen
     IF (tg_op = 'INSERT') AND NullIf(new.bap_txt,'') IS NULL AND (new.bap_op_ix IS NULL AND new.bap_o2_n IS NULL AND new.bap_o2_id IS NULL) THEN
       SELECT ak_bestxt, ak_bestxt_rtf INTO new.bap_txt, new.bap_txt_rtf FROM art WHERE ak_nr = new.bap_aknr;
      END IF;

     IF new.bap_o6_stkz + new.bap_o6_lz > 0 THEN
         IF new.bap_o6_zme IS NOT NULL THEN
           new.bap_menge:=tartikel.zuschnittmenge(new.bap_o6_lz,
                                                  new.bap_o6_bz,
                                                  new.bap_o6_hz,
                                                  new.bap_o6_zz,
                                                  Round(new.bap_o6_stkz)::INTEGER,
                                                  TArtikel.me__art__artmgc__m_ids__uf(new.bap_mecod, new.bap_o6_zme));
         ELSE
           new.bap_menge:=tartikel.zuschnittmenge(new.bap_o6_lz, new.bap_o6_bz, new.bap_o6_hz, new.bap_o6_zz, new.bap_o6_stkz);
         END IF;
      END IF;
     --Menge UF1
     UF := m_uf FROM artmgc WHERE m_ak_nr = new.bap_aknr AND m_mgcode = new.bap_mecod;--umrechnungsfaktor der angegebenen Mengeneinheit
     new.bap_menge_uf1 := new.bap_menge / COALESCE(uf, 1); --COALESCE: freier Artikel
     -- Kostenstelle vorgeben (Artikel, AC)
     IF new.bap_ks IS NULL THEN
         SELECT COALESCE(ak_ks, ac_ks) INTO new.bap_ks
         FROM art JOIN artcod ON ak_ac=ac_n WHERE ak_nr=new.bap_aknr;
      END IF;
     -- Kontierung vorgeben (Artikel, AC, Kreditorendaten)
     IF new.bap_konto IS NULL THEN
         SELECT COALESCE(ak_awko, ac_konto, a2_desk) INTO new.bap_konto
         FROM art JOIN artcod ON ak_ac=ac_n LEFT JOIN adk2 ON a2_krz=new.bap_lkn WHERE ak_nr=new.bap_aknr;
      END IF;

     -- Termin eingegeben -> Woche setzen
     IF new.bap_termin IS NOT NULL THEN
        new.bap_termweek := termweek( new.bap_termin );
     END IF;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__b_iu
     BEFORE INSERT OR UPDATE
     ON bestanfpos
     FOR EACH ROW
     EXECUTE PROCEDURE bestanfpos__b_iu();
 --

 -- Auftragsposition zur Nummer / Artikel suchen und Verknüpfen
 CREATE OR REPLACE FUNCTION bestanfpos__b_iu_check_agpos() RETURNS TRIGGER AS $$
   DECLARE r   RECORD;
           msg VARCHAR;
   BEGIN
     IF (tg_op = 'UPDATE') AND (new.bap_agnr IS DISTINCT FROM old.bap_agnr) THEN -- Umgeschriebene Auftragsnummer
         IF (old.bap_agnr IS NOT NULL AND new.bap_agnr IS NULL) THEN
             new.bap_agpos:= NULL; -- Position zurücksetzen Auftragsnummer ist leer
             RETURN new;
         END IF;
     END IF;

     --Erste offene Auftragsposition für den Artikel suchen, die noch nicht in einer BANF ist.
     SELECT ag_id, ag_astat, ag_nr, ag_pos INTO r FROM auftg
       WHERE NOT ag_done
         AND ag_nr   = new.bap_agnr
         AND ag_aknr = new.bap_aknr
         AND NOT EXISTS(SELECT true FROM bestanfpos WHERE bap_agnr = ag_nr AND bap_agpos = ag_pos AND bap_aknr = ag_aknr)
       ORDER BY ag_pos LIMIT 1;

     IF (r.ag_id IS NULL) THEN RETURN new; END IF; -- Gibts nix. Raus.

     -- Position setzen und dem Nutzer Bescheid sagen
     new.bap_agpos := r.ag_pos;
     msg := FormatS( FormatLines( lang_text(13524),                  -- Bestellanforderungs-Position wurde mit Auftragsposition verknüpft.
                                  lang_text(10333)||': % | %',       -- Bestellanforderung: Banfnr-PosNr
                                  lang_text(248)||': % | % | %'),    -- Auftrag: Astat|Agnr|PosNr
                     new.bap_banr, new.bap_pos::VARCHAR, r.ag_astat, r.ag_nr, r.ag_pos::VARCHAR );
     PERFORM PRODAT_HINT(msg);

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__b_iu_check_agpos
     BEFORE INSERT OR UPDATE OF bap_agnr
     ON bestanfpos
     FOR EACH ROW
     WHEN (COALESCE(new.bap_op_ix, new.bap_o2_n, new.bap_o2_id) IS NULL) -- Nicht für Auswärtsvergaben
     EXECUTE PROCEDURE bestanfpos__b_iu_check_agpos();
 --

 -- Synchron halten von ASK-Index+ABG Nummer mit o2_id (Ändern in Banf-Oberfläche vs. Umnummerieren in Stammkarte)
 CREATE OR REPLACE FUNCTION bestanfpos__b_iu_sync_askabg() RETURNS TRIGGER AS $$
   DECLARE o2id_changed  BOOLEAN;
           abg_changed   BOOLEAN;
   BEGIN
     -- Fall 0: op_ix, o2_n, o2_id leer  => Nix machen
     -- Fall 1: o2_id gesetzt            => Banf auf ASK-Auswärtsarbeitsgang, op_ix und o2_n nachsetzen
     -- Fall 2: op_ix und o2_n gesetzt   => Banf auf ASK-Auswärtsarbeitsgang, o2_id nachsetzen
     -- Fall 3: nur o2_n gesetzt oder Text umgeschrieben

     --Fall 0
     IF (new.bap_op_ix IS NULL AND new.bap_o2_n IS NULL AND new.bap_o2_id IS NULL) THEN
         RETURN new;
     ELSE
         new.bap_anfrage:=true;
     END IF;

     IF (tg_op = 'INSERT') THEN
         o2id_changed:=(new.bap_o2_id IS NOT NULL);                          -- Fall 1
         IF NOT o2id_changed THEN                                            -- Fall 2
             abg_changed:=(new.bap_o2_n IS NOT NULL) AND (new.bap_o2_n <> 0);
         END IF;
     END IF;

     IF (tg_op = 'UPDATE') THEN
         o2id_changed:=(new.bap_o2_id IS DISTINCT FROM old.bap_o2_id);       -- Fall 1
         IF NOT o2id_changed THEN                                            -- Fall 2
             abg_changed := (new.bap_o2_n IS DISTINCT FROM old.bap_o2_n) OR (new.bap_op_ix IS DISTINCT FROM old.bap_op_ix);
         END IF;
     END IF;

     -- Behandlung Fall 1
     IF o2id_changed THEN
         SELECT o2_ix, o2_n INTO new.bap_op_ix, new.bap_o2_n FROM op2 WHERE o2_id = new.bap_o2_id;
     END IF;

     IF abg_changed THEN
         -- Behandlung Fall 2
         IF (new.bap_op_ix IS NOT NULL) AND (new.bap_o2_n > 0) THEN
             SELECT o2_id INTO new.bap_o2_id FROM op2 WHERE o2_n = new.bap_o2_n AND o2_ix = new.bap_op_ix;
         END IF;

         -- Behandlung Fall 3
         IF (new.bap_o2_n = 0) THEN
             new.bap_op_ix := NULL;
             new.bap_o2_id := NULL;
         END IF;
     END IF;

     -- Arbeitsgangtext in Banf übernehmen, sobald wir eine ASK zuordnen können.
     IF (new.bap_o2_id IS NOT NULL) THEN
         IF (tg_op = 'INSERT') OR (TRIM(COALESCE(new.bap_txt,'')) = '' ) THEN
             SELECT o2_txt, o2_txt_rtf INTO new.bap_txt, new.bap_txt_rtf FROM op2 WHERE o2_id = new.bap_o2_id;
         END IF;
     END IF;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__b_iu_sync_askabg
     BEFORE INSERT OR UPDATE OF bap_op_ix, bap_o2_n, bap_o2_id, bap_txt
     ON bestanfpos
     FOR EACH ROW
     EXECUTE PROCEDURE bestanfpos__b_iu_sync_askabg();
 --

 --
 CREATE OR REPLACE FUNCTION bestanfpos__a_iud__doBedarf() RETURNS TRIGGER AS $$
   BEGIN
     IF tg_op='DELETE' THEN
         PERFORM tartikel.prepare_artikel_bedarf(old.bap_aknr, false); --Bedarfsabgleich ohne Verfügbarkeitsberechnung
         RETURN old;
     END IF;
     --
     IF tg_op='UPDATE' THEN
         IF old.bap_aknr IS DISTINCT FROM new.bap_aknr THEN
             PERFORM tartikel.prepare_artikel_bedarf(old.bap_aknr, false);
         END IF;
     END IF;
     --
     PERFORM tartikel.prepare_artikel_bedarf(new.bap_aknr, false); --Bedarfsabgleich ohne Verfügbarkeitsberechnung

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__a_iud__doBedarf
     AFTER INSERT OR DELETE OR UPDATE
     OF bap_aknr, bap_menge, bap_menge_uf1, bap_mecod, bap_termin, bap_termweek, bap_done,
        -- Änderung Status anfrage => bei Anfrage KEIN Bedarf
        -- Umsetzen von Auswärtszuweisung setzt Anfrage daher auch auf diese Felder reagieren
        bap_anfrage, bap_op_ix, bap_o2_n, bap_o2_id, bap_doeinkauf
     ON bestanfpos
     FOR EACH ROW
     EXECUTE PROCEDURE bestanfpos__a_iud__doBedarf();
 --

 -- Bedarfsberechnung neu anstoßen
 CREATE OR REPLACE FUNCTION bestanfpos__as__a_iud() RETURNS TRIGGER AS $$
   BEGIN
     PERFORM do_artikel_bedarf();

     RETURN NULL;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__as__a_iud
     AFTER INSERT OR UPDATE OR DELETE
     ON BestAnfPos
     FOR EACH STATEMENT
     EXECUTE PROCEDURE bestanfpos__as__a_iud();
 --

 --Prognose: für Unterartikel der 1-Dimensionalen Stückliste die Mengen mitziehen
   --http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Prognose
     CREATE OR REPLACE FUNCTION bestanfpos__a_u__bap_menge() RETURNS TRIGGER AS $$
       DECLARE fakt NUMERIC;
       BEGIN
         IF old.bap_menge=0 THEN
             RETURN new;
         END IF;
         --
         fakt:=new.bap_menge/old.bap_menge;
         UPDATE bestanfpos SET bap_menge=bap_menge*fakt WHERE bap_parent_id=new.bap_id AND bap_id<>new.bap_id;--anteilig die Mengen der untergeordneten Artikel hoch/runtersetzen!

         RETURN new;
       END $$ LANGUAGE plpgsql;

       CREATE TRIGGER bestanfpos__a_u__bap_menge
         AFTER UPDATE
         OF bap_menge
         ON bestanfpos
         FOR EACH ROW
         EXECUTE PROCEDURE bestanfpos__a_u__bap_menge();
     --
 --

 -- Externen Text an Bestellpositionen weitergeben, wenn dort noch nicht geändert, nicht erledigt oder Dokument erzeugt. Ansonsten Meldung.
 CREATE OR REPLACE FUNCTION bestanfpos__a_u__bap_txt() RETURNS TRIGGER AS $$
   DECLARE infotxt TEXT;
   BEGIN -- WHEN (new.bap_ld_id IS NOT NULL AND old.bap_txt IS DISTINCT FROM new.bap_txt)
     -- Meldung für nicht veränderbare Bestellungen, bei denen der externe Text schon unterschiedlich ist, erledigt oder das Dokument erzeugt wurde.
     IF EXISTS(SELECT true FROM ldsdok WHERE ld_id = new.bap_ld_id AND ld_txt IS DISTINCT FROM new.bap_txt AND (ld_txt IS DISTINCT FROM old.bap_txt OR ld_done OR ld_dokunr IS NOT NULL)) THEN
         infotxt:=lang_text(16340)||E'\n\n'||lang_text(19003)||E':\n'|| -- Der Dokumenttext im Folgedokument wurde nicht angepasst ... Bestellung: ...
             (SELECT array_to_string(ARRAY( -- Stringliste aller Bestellungen
                 SELECT ld_code||' '||ld_auftg||' '||lang_text(164)||' '||ld_pos
                 FROM ldsdok
                 WHERE ld_id = new.bap_ld_id
                   AND ld_txt IS DISTINCT FROM new.bap_txt -- Ziel soll geändert werden
                   AND (ld_txt IS DISTINCT FROM old.bap_txt OR ld_done OR ld_dokunr IS NOT NULL) -- war aber vorher abweichend
                 ORDER BY ld_code, ld_auftg, ld_pos
                 ), E'\n'));
     END IF;

     IF infotxt IS NOT NULL THEN
         PERFORM PRODAT_TEXT(infotxt);
     END IF;

     -- Bestellpositionen, die automatisch synchron gehalten werden.
     UPDATE ldsdok SET
       ld_txt = new.bap_txt,
       ld_txt_rtf = new.bap_txt_rtf
     WHERE ld_id = new.bap_ld_id
       AND NOT ld_done
       AND ld_dokunr IS NULL
       AND ld_txt IS NOT DISTINCT FROM old.bap_txt -- waren die Texte vorher gleich
       AND ld_txt IS DISTINCT FROM new.bap_txt;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__a_u__bap_txt
     AFTER UPDATE
     OF bap_txt
     ON bestanfpos
     FOR EACH ROW
     WHEN (new.bap_ld_id IS NOT NULL AND old.bap_txt IS DISTINCT FROM new.bap_txt)
     EXECUTE PROCEDURE bestanfpos__a_u__bap_txt();
 --

 -- Verhindern, dass Einträge aus bestanfpos gelöscht werden, wenn Bestellung oder Anfrage damit verknüpft sind (#7661).
 CREATE OR REPLACE FUNCTION bestanfpos__b_d() RETURNS TRIGGER AS $$
   BEGIN
     IF (old.bap_ld_id IS NOT NULL) THEN
         RAISE EXCEPTION '%',lang_text(28217); -- Die BANF kann nicht gelöscht werden, da sie mit einer Bestellung verbunden ist.
     ELSIF (old.bap_aArt_id IS NOT NULL) THEN
         RAISE EXCEPTION '%',lang_text(28218); -- Die BANF kann nicht gelöscht werden, da sie mit einer Anfrage verbunden ist.
     END IF;

     RETURN old;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__b_d
     BEFORE DELETE
     ON bestanfpos
     FOR EACH ROW
     EXECUTE PROCEDURE bestanfpos__b_d();
 --

 -- Verlinkung in Gebundene Bedarfsverursacher nachsetzen bzw. entfernen.
 CREATE OR REPLACE FUNCTION bestanfpos__a_50_iu__bap_ld_id__ldsauftg_link() RETURNS TRIGGER AS $$
   BEGIN
     -- WHEN (NOT new.bap_prognose)

     IF new.bap_ld_id IS NOT NULL THEN -- INSERT OR UPDATE
         IF NOT EXISTS(SELECT true FROM ldsauftg
                        WHERE la_ld_id = new.bap_ld_id
                          AND la_bap_id = new.bap_id)
         THEN -- Eintrag in ldsauftg nachsetzen, wenn nich vorhanden.
             INSERT INTO ldsauftg (la_ld_id, la_bap_id, la_stk) VALUES (new.bap_ld_id, new.bap_id, new.bap_menge);
         END IF;
     ELSIF TG_OP = 'UPDATE' THEN
         IF     old.bap_ld_id IS NOT NULL
            AND new.bap_ld_id IS NULL
         THEN -- Bestellbezug wird explizit entfernt, dann Verlinkung entfernen (wird ggf. gelöscht, siehe ldsauftg).
             UPDATE ldsauftg
                SET la_ld_id = NULL
              WHERE la_ld_id = old.bap_ld_id
                AND la_bap_id = old.bap_id;
         END IF;
     END IF;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER bestanfpos__a_50_iu__bap_ld_id__ldsauftg_link
     AFTER INSERT OR UPDATE
     OF bap_ld_id
     ON bestanfpos
     FOR EACH ROW
     WHEN (NOT new.bap_prognose)
     EXECUTE PROCEDURE bestanfpos__a_50_iu__bap_ld_id__ldsauftg_link();
 --

-- BANF schließen und wieder öffnen, wenn Menge bestellt Bedarfsmenge erreicht bzw. unterschreitet.
CREATE OR REPLACE FUNCTION bestanfpos__a_60_u__bap_done__bap_menge_best_uf1() RETURNS TRIGGER AS $$
  DECLARE
      _new_bap_done boolean;
  BEGIN
      -- Beachte Trigger-Bedingung:
        -- BANF-Pos ist mit Einkauf-Pos verknüpft und ist keine Prognose
        -- WHEN ( new.bap_ld_id IS NOT NULL AND NOT new.bap_prognose )


      -- Menge bestellt erreicht oder unterschreitet Bedarfsmenge
      _new_bap_done := new.bap_menge_best_uf1 >= coalesce( new.bap_menge_uf1, new.bap_menge );

      -- Schließen bzw. Öffnen anhand Mengen.
        -- Löst bestanfpos__a_iud__doBedarf aus.
      UPDATE bestanfpos SET
        bap_done = _new_bap_done
      WHERE bap_id = new.bap_id
        AND bap_done <> _new_bap_done
        AND NOT bap_prognose
      ;


      RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bestanfpos__a_60_u__bap_done__bap_menge_best_uf1
    AFTER UPDATE
    OF bap_menge_best_uf1, bap_menge, bap_mecod, bap_menge_uf1
    ON bestanfpos
    FOR EACH ROW
    WHEN ( new.bap_ld_id IS NOT NULL AND NOT new.bap_prognose )
    EXECUTE PROCEDURE bestanfpos__a_60_u__bap_done__bap_menge_best_uf1();
--

-- ****************************** LDSAUFTG ********************** Bedarfsverusacher an Einkauf: ldsdok, bestellvorschlag, banf usw.
 -- Tabelle zur Verknüpfung eines Einkaufs mit mehreren Aufträgen und BANF
 CREATE TABLE ldsauftg(
   la_id          serial PRIMARY KEY,
   la_bvp_id      integer,           -- X TableContraints: REFERENCES BestVorschlagPos ON UPDATE CASCADE ON DELETE SET NULL, -- la_bvp_id NOT NULL
   la_ld_id       integer            REFERENCES ldsdok           ON UPDATE CASCADE ON DELETE SET NULL,                       -- AND la_ld_id NOT NULL per Trigger
   la_ag_id       integer            REFERENCES auftg            ON UPDATE CASCADE ON DELETE CASCADE,
   la_bap_id      integer            REFERENCES bestanfpos       ON UPDATE CASCADE ON DELETE CASCADE,
   la_stk         numeric(12,4),
   la_stk_uf1     numeric(12,4),
   la_me_mgcode   integer NOT NULL REFERENCES mgcode ON UPDATE CASCADE,
   la_mce         integer REFERENCES artmgc,
   la_txt         text,
   la_txt_rtf     text
   );
 --

 -- Indizes
     -- X TableContraints: CREATE UNIQUE INDEX ldsauftg_bvp_id_ag_id ON ldsauftg(la_bvp_id, COALESCE(la_ag_id, -1), COALESCE(la_bap_id, -1)) WHERE la_bvp_id IS NOT NULL; -- pro Bestellvorschlag-Pos 1x Auftrag bzw. BANF-Pos. Bezug zur Bestellung kann NULL sein, wenn nur Bestellvorschlag-Pos da ist.
     CREATE UNIQUE INDEX ldsauftg_ld_id_ag_id  ON ldsauftg(la_ld_id, coalesce(la_ag_id, -1), coalesce(la_bap_id, -1)) WHERE la_ld_id IS NOT NULL;                         -- pro Bestellung 1x Auftrag bzw. BANF-Pos.           Bezug zur Bestellvorschlag-Pos kann NULL sein, wenn nur Bestellung da ist.
         -- la_bvp_id NULL und la_ld_id NULL wird im ldsauftg__a_10_iu__constraints abgefangen.
         -- keine Lösung über einen einzigen UNIQUE INDEX per (COALESCE(la_bvp_id, -1), COALESCE(la_ld_id, -1), ...): führt zu Problemen beim gleichzeitigen Löschen von mehreren referenzierten Daten (row-level AFTER triggers fire at the end of the statement)
     CREATE INDEX        ldsauftg_la_ag_id  ON ldsauftg(la_ag_id) WHERE la_ag_id IS NOT NULL;
     CREATE INDEX        ldsauftg_la_bvp_id ON ldsauftg(la_bvp_id);
 --

  CREATE OR REPLACE FUNCTION ldsauftg__b_10_iu__mce() RETURNS TRIGGER AS $$
    BEGIN
        -- Mengeineinheit (freie Artikel)
        -- Zuerst MCV => ARTMGC-ID ist führend.

        -- COALESCE auf Stück wegen freien Artikel BANF
        new.la_me_mgcode :=
            COALESCE(
              tartikel.me__mec__by__mid( new.la_mce ),
              new.la_me_mgcode,
              1
            );

        RETURN new;

    END $$ LANGUAGE plpgsql;
    --
    CREATE TRIGGER ldsauftg__b_10_iu__mce
    BEFORE INSERT OR UPDATE
    OF la_mce
    ON ldsauftg
    FOR EACH ROW
    EXECUTE PROCEDURE ldsauftg__b_10_iu__mce();

 -- Automatische Berechnung der gebundenen Menge, wenn keine angegeben ist (z.B. beim manuellen Einfügen).
 CREATE OR REPLACE FUNCTION ldsauftg__b_05_i__calc_la_stk_uf1() RETURNS TRIGGER AS $$
   DECLARE
      bedarf_menge_max NUMERIC(12,4);
   BEGIN

     -- Maximale Bedarfsmenge je nach Herkunft
     IF new.la_ag_id IS NOT NULL THEN
         bedarf_menge_max := (SELECT ag_stk_uf1 - ag_stkb FROM auftg WHERE ag_id = new.la_ag_id); -- noch zu bestellende Menge aus Auftrag
     ELSIF new.la_bap_id IS NOT NULL THEN
         bedarf_menge_max := (SELECT coalesce(bap_menge_uf1, bap_menge) - bap_menge_best_uf1 FROM bestanfpos WHERE bap_id = new.la_bap_id); -- noch zu bestellende Menge aus Bestellanforderung
     END IF;

     new.la_stk_uf1 :=
       greatest(0, -- mindestens 0
         least( -- maximal verfügbare Menge:
           (   -- Bestellmenge - schon verteilter Bestellmenge
               (SELECT ld_stk_uf1 FROM ldsdok WHERE ld_id = new.la_ld_id)
             - (SELECT sum(la_stk_uf1) FROM ldsauftg WHERE la_ld_id = new.la_ld_id)
           )
           , bedarf_menge_max -- oder Bedarfsmenge
         )
       );

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER ldsauftg__b_05_i__calc_la_stk_uf1
     BEFORE INSERT
     ON ldsauftg
     FOR EACH ROW
     WHEN (new.la_ld_id IS NOT NULL AND new.la_stk IS NULL AND new.la_stk_uf1 IS NULL) -- Eintrag an Bestellung mit unbekannter Menge.
     EXECUTE PROCEDURE ldsauftg__b_05_i__calc_la_stk_uf1();
 --

 -- Berechnung von Menge in ME und GME
 CREATE OR REPLACE FUNCTION ldsauftg__b_10_iu__uf1() RETURNS TRIGGER AS $$
   BEGIN
     IF new.la_mce IS NULL THEN
         -- ME automatisch aus Bestellung/Bestellvorschlag ermitteln.
         new.la_mce := CASE WHEN new.la_ld_id IS NOT NULL THEN -- Bestellung führend
                                (SELECT ld_mce FROM ldsdok WHERE ld_id = new.la_ld_id)
                            WHEN new.la_bvp_id IS NOT NULL THEN
                                (SELECT bvp_mcv FROM BestVorschlagPos WHERE bvp_id = new.la_bvp_id)
                            END;
     END IF;

     IF new.la_stk IS NULL AND new.la_stk_uf1 IS NOT NULL THEN
         -- Menge in ME nicht vorhanden bzw. wird zurückgesetzt. Dann neu berechnen aus Menge in GME.
         -- Fall 1: INSERT von Menge in GME
         -- Fall 2: ME + Menge in Bestellung/Bestellvorschlag wird geändert (Option xtt6101: Preis / Mengen nach neuen Umrechnungsfaktor umrechnen? - Ja). Menge in GME bleibt erhalten.
         new.la_stk := coalesce( tartikel.me__menge_uf1__in__menge(new.la_mce, new.la_stk_uf1), new.la_stk_uf1 ); -- Bei Eintrag von Menge in GME, Menge in ME berechnen.
     ELSIF new.la_stk IS NOT NULL THEN
         -- Menge in ME vorhanden bzw. bleibt erhalten. Dann Menge in GME neu berechnen.
         -- Fall 1: INSERT von Menge in ME
         -- Fall 2: Nur ME in Bestellung/Bestellvorschlag wird geändert (Option xtt6101: Preis / Mengen nach neuen Umrechnungsfaktor umrechnen? - Nein). Menge in ME bleibt erhalten.
         -- Fall 3: Menge in ME wird in Oberfläche (Gebundene Aufträge) geändert.
         new.la_stk_uf1 := coalesce( tartikel.me__menge__in__menge_uf1(new.la_mce, new.la_stk), new.la_stk ); -- Bei Eintrag von Menge in ME, Menge in GME berechnen.
     END IF;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER ldsauftg__b_10_iu__uf1
     BEFORE INSERT OR UPDATE
     OF la_stk, la_stk_uf1, la_mce
     ON ldsauftg
     FOR EACH ROW
     EXECUTE PROCEDURE ldsauftg__b_10_iu__uf1();
 --

 -- Nachbau mehrdimensionaler Contraints per Trigger (Ziel-IDs und Quell-IDs NULL)
 CREATE OR REPLACE FUNCTION ldsauftg__a_10_iu__constraints() RETURNS TRIGGER AS $$
   BEGIN
     -- Verknüpfung Bestellvorschlag bei Löschen ggf. bereinigen.
     IF TG_OP = 'UPDATE' THEN
         IF  (new.la_bvp_id IS NULL AND old.la_bvp_id IS NOT NULL AND new.la_ld_id  IS NULL) OR  -- Bestellvorschlagsposition wird gelöscht (ON DELETE SET NULL) und kein Bestellbezug vorhanden,
             (new.la_ld_id  IS NULL AND old.la_ld_id  IS NOT NULL AND new.la_bvp_id IS NULL)     -- oder: Bestellung wird gelöscht (ON DELETE SET NULL) und keine Bestellvorschlagsbezug vorhanden,
         THEN
             DELETE FROM ldsauftg WHERE la_id = new.la_id;                                       -- dann sich selbst löschen (sonst erhalten wegen jeweils anderen Bezug). Nur im AFTER-Trigger möglich.
             RETURN new;                                                                         -- und raus.
         END IF;
     END IF;
     --

     -- Fehlerbehandlung
     IF TG_OP IN ('INSERT', 'UPDATE') THEN
         IF new.la_bvp_id IS NULL AND new.la_ld_id IS NULL THEN -- Bestvorschlagspos und Bestellung dürfen nicht gleichzeitig NULL sein.
             RAISE EXCEPTION 'xtt16694'; -- null value in column "la_bvp_id" and "la_ld_id" violates not-null constraint
         END IF;

         IF new.la_ag_id IS NULL AND new.la_bap_id IS NULL THEN -- Auftrag und BANF dürfen nicht gleichzeitig NULL sein.
             RAISE EXCEPTION 'xtt16695'; -- null value in column "la_ag_id" and "la_bap_id" violates not-null constraint
         END IF;

         IF new.la_ag_id IS NOT NULL AND new.la_bap_id IS NOT NULL THEN -- Auftrag und BANF dürfen nicht gleichzeitig gesetzt sein.
             RAISE EXCEPTION 'xtt16696'; -- non-exclusive content in "la_ag_id" xor "la_bap_id"
         END IF;
     END IF;
     --

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER ldsauftg__a_10_iu__constraints
     AFTER INSERT OR UPDATE
     OF la_bvp_id, la_ld_id, la_ag_id, la_bap_id
     ON ldsauftg
     FOR EACH ROW
     EXECUTE PROCEDURE ldsauftg__a_10_iu__constraints();
 --

 -- Setzen, aktualisieren und löschen der Verknüpfungen (Einkauf und Auftrag/BANF).
 CREATE OR REPLACE FUNCTION ldsauftg__a_20_iud__ldsdok_banf_links() RETURNS TRIGGER AS $$
   DECLARE _do_ldsdok_links boolean;
   BEGIN
     IF current_user = 'syncro' THEN
        RETURN new;
     END IF;

     -- Raus, wenn beide Referenzen entfernt worden sind (ON DELETE SET NULL führt zu DELETE per ldsauftg__a_10_iu__constraints).
     IF TG_OP = 'UPDATE' THEN
        IF new.la_bvp_id IS NULL AND new.la_ld_id IS NULL THEN
            RETURN new;
        END IF;
     END IF;


     PERFORM disablemodified();

     -- Prüfung, ob Einkauf-Links hergestellt werden müssen (_do_ldsdok_links). Ist für Insert und Update identisches Verhalten.
     IF TG_OP = 'INSERT' THEN
         IF new.la_ld_id IS NOT NULL THEN                            _do_ldsdok_links := true; END IF; -- Verlinkung wird aus Einkauf erstellt.
     ELSIF TG_OP = 'UPDATE' THEN
         IF new.la_ld_id IS NOT NULL AND old.la_ld_id IS NULL THEN   _do_ldsdok_links := true; END IF; -- Verknüpfung aus Bestellvorschlag wird erzeugt (BestVorschlagPos__a_iu__ldsauftg_links).
     END IF;
     --

     -- Einkauf-Links herstellen
     IF _do_ldsdok_links THEN
         IF new.la_ag_id IS NOT NULL THEN -- bei Verlinkung mit Auftrag
             UPDATE ldsdok
                SET ld_ag_id = new.la_ag_id
              WHERE ld_id = new.la_ld_id
                AND ld_ag_id IS NULL; -- Ersten Eintrag eines Auftrags im Einkauf direkt setzen.
         END IF;

         -- bei Verlinkung mit BANF
         IF new.la_bap_id IS NOT NULL THEN

             UPDATE ldsdok
                SET ld_banfnr = (SELECT bap_banr || '-P-' || bap_pos
                                   FROM bestanfpos
                                  WHERE bap_id = new.la_bap_id
                                 )
              WHERE ld_id = new.la_ld_id
                AND ld_banfnr IS NULL; -- Ersten Eintrag einer BANF im Einkauf direkt setzen.

             UPDATE bestanfpos
                SET bap_ld_id = new.la_ld_id
              WHERE bap_id = new.la_bap_id
                AND bap_ld_id IS NULL; -- Bestellung wird in BANF verlinkt.

             -- Lagerzugangstext aus BANF-Pos an Bestellung übertragen.
             UPDATE ldsdok
                SET ld_lagzu_txt =
                      concat_ws(
                        E'\n\n',
                        nullif(ld_lagzu_txt, ''),
                        'BANF: ' || bap_banr || ' Pos. ' || bap_pos || E': ' || bap_lagzu_txt -- Nicht leeren Lagerzugangstext aus BANF-Pos anfügen.
                      ),
                    ld_lagzu_txt_rtf = NULL -- RTF muss beim Konkatenieren entfernt werden.
               FROM ( -- Wenn Lagerzugangstext in BANF steht, dann an Lagzutext in Bestellung konkatenieren.
                     SELECT bap_banr, bap_pos, bap_lagzu_txt
                       FROM bestanfpos
                      WHERE bap_id = new.la_bap_id
                        AND nullif(bap_lagzu_txt, '') IS NOT NULL
                    ) AS banf
             WHERE ld_id = new.la_ld_id;
         END IF;
     END IF;
     --

     IF TG_OP = 'UPDATE' THEN
         -- Änderungen bei vorhandenem Bestellbezug
         IF new.la_ld_id IS NOT NULL THEN
             -- Verknüpfter Auftrag wird geändert, der zurzeit in ldsdok steht, dann ldsdok.ld_ag_id ändern.
             IF new.la_ag_id IS DISTINCT FROM old.la_ag_id THEN
                 UPDATE ldsdok
                    SET ld_ag_id = new.la_ag_id
                  WHERE ld_id = new.la_ld_id
                    AND ld_ag_id = old.la_ag_id;
             END IF;
             -- Verknüpfte BANF wird geändert, die zurzeit in ldsdok steht, dann ldsdok.ld_banfnr ändern.
             IF new.la_bap_id IS DISTINCT FROM old.la_bap_id THEN
                 UPDATE ldsdok
                    SET ld_banfnr = (SELECT bap_banr ||'-P-'|| bap_pos FROM bestanfpos WHERE bap_id = new.la_bap_id)
                  WHERE ld_id = new.la_ld_id
                    AND ld_banfnr = (SELECT bap_banr ||'-P-'|| bap_pos FROM bestanfpos WHERE bap_id = old.la_bap_id);

                 UPDATE bestanfpos
                    SET bap_ld_id = new.la_ld_id
                  WHERE bap_id = new.la_bap_id
                    AND bap_ld_id IS NULL; -- Bestellung wird in neuer BANF verlinkt.

                 UPDATE bestanfpos
                    SET bap_ld_id = NULL
                  WHERE bap_id = old.la_bap_id
                    AND bap_ld_id = new.la_ld_id; -- Link aus alter BANF wird entfernt.
             END IF;
         END IF;
         --
     ELSIF TG_OP = 'DELETE' THEN
         -- Löschen der Verknüfung, die gerade in ldsdok steht, dann in ldsdok selbst auch löschen.
         IF old.la_ld_id IS NOT NULL THEN
             -- bei Verlinkung mit Auftrag
             IF old.la_ag_id IS NOT NULL THEN
                 UPDATE ldsdok
                    SET ld_ag_id = NULL
                  WHERE ld_id = old.la_ld_id
                    AND ld_ag_id = old.la_ag_id;
             END IF;
             -- bei Verlinkung mit BANF
             IF old.la_bap_id IS NOT NULL THEN
                 UPDATE bestanfpos
                    SET bap_ld_id = NULL
                  WHERE bap_id = old.la_bap_id
                    AND bap_ld_id = old.la_ld_id; -- Link aus alter BANF wird entfernt.

                 UPDATE ldsdok
                    SET ld_banfnr = NULL
                  WHERE ld_id = old.la_ld_id
                    AND NOT EXISTS(SELECT true FROM bestanfpos WHERE bap_ld_id = old.la_ld_id AND bap_banr || '-P-' || bap_pos = ld_banfnr); -- old.la_bap_id kann nicht mehr verglichen werden im AFTER-Trigger, daher NOT EXISTS.
             END IF;
         END IF;
         --
     END IF;

     PERFORM enablemodified();

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER ldsauftg__a_20_iud__ldsdok_banf_links
     AFTER INSERT OR DELETE OR UPDATE
     OF la_bvp_id, la_ld_id, la_ag_id, la_bap_id
     ON ldsauftg
     FOR EACH ROW
     EXECUTE PROCEDURE ldsauftg__a_20_iud__ldsdok_banf_links();
 --

 -- Setzen und aktualisieren der Menge bestellt im Auftrag
 CREATE OR REPLACE FUNCTION ldsauftg__a_30_iud__auftg_ag_stkb_sum() RETURNS TRIGGER AS $$
   DECLARE new_la_ag_id INTEGER;
           old_la_ag_id INTEGER;
           ag_stkb_sum_new NUMERIC(12,4); -- siehe auftg.ag_stkb
           ag_stkb_sum_old NUMERIC(12,4);
   BEGIN
     IF TG_OP = 'INSERT' THEN
         IF     new.la_ag_id IS NOT NULL
            AND new.la_ld_id IS NOT NULL
            AND new.la_stk_uf1 > 0
         THEN -- Auftragsbezug und Bestellbezug mit Menge > 0
             new_la_ag_id := new.la_ag_id;
         END IF;
     ELSIF TG_OP = 'UPDATE' THEN -- OF la_ld_id, la_ag_id, la_stk, la_stk_uf1, la_mce
         IF     coalesce(new.la_ag_id, old.la_ag_id) IS NOT NULL
            AND coalesce(new.la_ld_id, old.la_ld_id) IS NOT NULL
         THEN -- Auftragsbezug und Bestellbezug vorhanden.
             new_la_ag_id := new.la_ag_id; -- Bestellung hinzugefügt, geändert, storniert oder entfernt. Sowie Änderung der zugeordneten Menge.

             IF new.la_ag_id IS DISTINCT FROM old.la_ag_id THEN -- Auftrag hinzugefügt, geändert oder entfernt
                 old_la_ag_id := old.la_ag_id;
             END IF;
         END IF;
     ELSE -- DELETE
         IF old.la_ag_id IS NOT NULL AND old.la_ld_id IS NOT NULL AND old.la_stk_uf1 > 0 THEN -- Auftragsbezug und Bestellbezug mit Menge > 0
             old_la_ag_id := old.la_ag_id;
         END IF;
     END IF;

     -- Summe Bestellt im Auftrag aktualisieren
     PERFORM disablemodified();

     IF new_la_ag_id IS NOT NULL THEN

         ag_stkb_sum_new := coalesce((SELECT sum(la_stk_uf1)
                                        FROM ldsauftg
                                        JOIN ldsdok ON ld_id = la_ld_id
                                       WHERE NOT ld_storno
                                         AND la_ag_id = new_la_ag_id
                                      )
                                      , 0
                                    );

         UPDATE auftg
            SET ag_stkb = ag_stkb_sum_new
          WHERE ag_id = new_la_ag_id
            AND ag_stkb <> ag_stkb_sum_new; -- beide NOT NULL
     END IF;

     IF old_la_ag_id IS NOT NULL THEN

         ag_stkb_sum_old := coalesce((SELECT sum(la_stk_uf1)
                                        FROM ldsauftg JOIN ldsdok ON ld_id = la_ld_id
                                       WHERE NOT ld_storno
                                         AND la_ag_id = old_la_ag_id
                                      )
                                      , 0
                                    );

         UPDATE auftg
            SET ag_stkb = ag_stkb_sum_old
          WHERE ag_id = old_la_ag_id
            AND ag_stkb <> ag_stkb_sum_old; -- beide NOT NULL
     END IF;

     PERFORM enablemodified();
     --

     -- und raus
     IF TG_OP = 'DELETE' THEN RETURN old; ELSE RETURN new; END IF;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER ldsauftg__a_30_iud__auftg_ag_stkb_sum
     AFTER INSERT OR DELETE OR UPDATE -- UPDATE OF => Daher UPDATE zuletzt
     OF la_ld_id, la_ag_id, la_stk, la_stk_uf1, la_mce
     ON ldsauftg
     FOR EACH ROW
     EXECUTE PROCEDURE ldsauftg__a_30_iud__auftg_ag_stkb_sum();
 --

 -- Setzen und aktualisieren der Menge bestellt im BANF
 CREATE OR REPLACE FUNCTION ldsauftg__a_40_iud__bestanfpos_bap_menge_best_uf1_sum() RETURNS TRIGGER AS $$
   DECLARE new_la_bap_id INTEGER;
           old_la_bap_id INTEGER;
           bap_menge_best_uf1_sum_new NUMERIC(12,4); -- siehe bestanfpos.bap_menge_best_uf1
           bap_menge_best_uf1_sum_old NUMERIC(12,4);
   BEGIN
     IF TG_OP = 'INSERT' THEN
         IF     new.la_bap_id IS NOT NULL
            AND new.la_ld_id IS NOT NULL
            AND new.la_stk_uf1 > 0
         THEN -- BANF-Bezug und Bestellbezug mit Menge > 0
             new_la_bap_id := new.la_bap_id;
         END IF;
     ELSIF TG_OP = 'UPDATE' THEN -- OF la_ld_id, la_bap_id, la_stk, la_stk_uf1, la_mce
         IF     coalesce(new.la_bap_id, old.la_bap_id) IS NOT NULL
            AND coalesce(new.la_ld_id, old.la_ld_id) IS NOT NULL
         THEN -- BANF-Bezug und Bestellbezug vorhanden.
             new_la_bap_id := new.la_bap_id; -- Bestellung hinzugefügt, geändert, storniert oder entfernt. Sowie Änderung der zugeordneten Menge.

             IF new.la_bap_id IS DISTINCT FROM old.la_bap_id THEN -- BANF hinzugefügt, geändert oder entfernt
                 old_la_bap_id := old.la_bap_id;
             END IF;
         END IF;
     ELSE -- DELETE
         IF old.la_bap_id IS NOT NULL AND old.la_ld_id IS NOT NULL AND old.la_stk_uf1 > 0 THEN -- BANF-Bezug und Bestellbezug mit Menge > 0
             old_la_bap_id := old.la_bap_id;
         END IF;
     END IF;

     -- Summe Bestellt in BANF aktualisieren
     PERFORM disablemodified();

     IF new_la_bap_id IS NOT NULL THEN

         bap_menge_best_uf1_sum_new:= coalesce((SELECT sum(la_stk_uf1) FROM ldsauftg JOIN ldsdok ON ld_id = la_ld_id WHERE NOT ld_storno AND la_bap_id = new_la_bap_id), 0);

         UPDATE bestanfpos
            SET bap_menge_best_uf1= bap_menge_best_uf1_sum_new
          WHERE bap_id = new_la_bap_id
            AND bap_menge_best_uf1 <> bap_menge_best_uf1_sum_new; -- beide NOT NULL
     END IF;

     IF old_la_bap_id IS NOT NULL THEN

         bap_menge_best_uf1_sum_old:= coalesce((SELECT sum(la_stk_uf1) FROM ldsauftg JOIN ldsdok ON ld_id = la_ld_id WHERE NOT ld_storno AND la_bap_id = old_la_bap_id), 0);

         UPDATE bestanfpos
            SET bap_menge_best_uf1 = bap_menge_best_uf1_sum_old
          WHERE bap_id = old_la_bap_id
            AND bap_menge_best_uf1 <> bap_menge_best_uf1_sum_old; -- beide NOT NULL
     END IF;

     PERFORM enablemodified();
     --

     -- und raus
     IF TG_OP = 'DELETE' THEN RETURN old; ELSE RETURN new; END IF;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER ldsauftg__a_40_iud__bestanfpos_bap_menge_best_uf1_sum
     AFTER INSERT OR DELETE OR UPDATE
     OF la_ld_id, la_bap_id, la_stk, la_stk_uf1, la_mce
     ON ldsauftg
     FOR EACH ROW
     EXECUTE PROCEDURE ldsauftg__a_40_iud__bestanfpos_bap_menge_best_uf1_sum();
 --

/******************** Bestellvorschlag ********************************************************************************/

 CREATE TABLE bestvorschlag_kennung(
   bvsk_id                 serial PRIMARY KEY,
   bvsk_bez                varchar(75),
   bvsk_default            boolean NOT NULL DEFAULT false
  );

 CREATE UNIQUE INDEX bestvorschlag_kennung_bvsk_default_unique ON bestvorschlag_kennung(bvsk_default) WHERE bvsk_default;

 -- TODO in predefined, oder nicht? Weil ist systemrelevant, andere Dinge wie artcod sind aber auch in predefined
 INSERT INTO bestvorschlag_kennung (bvsk_bez, bvsk_default) VALUES ('Einzel / unabhängig', True);
 INSERT INTO bestvorschlag_kennung (bvsk_bez) VALUES ('Wöchentlich [Datenübernahme]');
 INSERT INTO bestvorschlag_kennung (bvsk_bez) VALUES ('Langfrist [Datenübernahme]');

 -- Function for default column value
 CREATE FUNCTION bestvorschlag_kennung__default__get()
      RETURNS integer
      AS $$
          SELECT bvsk_id FROM bestvorschlag_kennung WHERE bvsk_default;
      $$ LANGUAGE sql;


 -- Kopfdaten BestellVorschläge
 CREATE TABLE bestvorschlag (
   bvs_nr                    VARCHAR(40) PRIMARY KEY,                    -- Nr. der Bestellanforderung
   bvs_bvsk_id               INTEGER NOT NULL REFERENCES bestvorschlag_kennung DEFAULT bestvorschlag_kennung__default__get(),
   bvs_dat                   DATE,                                       -- Bestellvorschläge wurden zu diesem Zeitpunkt generiert
   bvs_bedarfdat             DATE,                                       -- Bedarf bis zu diesem Datum wurde berücksichtigt
   bvs_minpreis              BOOLEAN NOT NULL DEFAULT FALSE,             -- Vorschlagen der Lieferanten nach kleinstem Preis
   bvs_stdlief               BOOLEAN NOT NULL DEFAULT FALSE,             -- Vorschlagen der Lieferanten aus Standardlieferanten (Epreis)
   bvs_ac                    VARCHAR(10),                                -- Einschränkung auf bestimmten AC
   bvs_auftg                 VARCHAR(40),                                -- Einschränkung auf Auftragsnummer wie "A2011%"
   bvs_lgort                 VARCHAR(50),                                -- Meldebestände: Einschränken auf Lagerort
   bvs_doLos                 BOOLEAN NOT NULL DEFAULT (NOT TSystem.Settings__GetBool('lds_losgr_immer1')),                           -- Losgröße soll berücksichtigt werden
   -- bvs_useRahmen             BOOLEAN NOT NULL DEFAULT TRUE,           -- [Obsolet mit Anbindung Preissuche, #8350] Rahmenabrufe werden bevorzugt vor günstigeren Lieferanten.
   bvs_txt                   TEXT,                                               -- Hinweistexte
   bvs_txt_rtf               TEXT
  );
 --


 -- Positionen Bestellvorschlaege (aus Bedarfen generiert)
 -- Positionen Bestellvorschlaege (aus Bedarfen generiert)
 CREATE TABLE bestvorschlagpos (
   bvp_id                    serial PRIMARY KEY,
   bvp_pos                   integer NOT null,                                                      -- Positions-Nummer
   bvp_typindex              integer,                                                               -- 3=Bedarf, 2=Melde-Lag 1=Melde-Art
   bvp_typ                   varchar(75),                                                           -- Herkunft: Bedarf, Meldebestand...
   bvp_bvsnr                 varchar(40) NOT null REFERENCES BestVorschlag ON UPDATE CASCADE ON DELETE CASCADE, -- Für welche Bestellvorschlag
   bvp_aknr                  varchar(40) NOT null,                                                  -- Artikel der bestellt werden soll
   bvp_ak_bez                varchar(100),                                                          -- Freie Artikelbezeichnung
   bvp_best                  varchar(40),                                                           -- Referenz /Artikelnummer Lieferant
   bvp_lkn                   varchar(21) REFERENCES adk ON UPDATE CASCADE,                          -- Vorgeschlagener Lieferant für Bestellung
   bvp_ag_id                 integer REFERENCES auftg,                                              -- Verursacher des Bedarfs bei Einzelbestellungen
   bvp_bedarf_list           tartikel.bedarf_verursacher[],                                         -- Alle ungedeckten Verursacher des artikelweise zusammengefassten Bedarfs inkl. Bedarfsmenge, vgl. FUNCTION getBestVorschlag_Auftrag. PgDAC schreibt "castbaren" String aus '{1,2,3}'::ARRAY[] (implicitCast funtkioniert)
   bvp_bestdat               date,                                                                  -- Spätestes Bestelldatum (Bedarf-Beschaffungsfrist)
   bvp_ldatum                date,                                                                  -- Lieferdatum
   bvp_bedarfsmenge_uf1      numeric(20,8) NOT null DEFAULT 0,                                      -- Wieviel bestellt werden soll. Vorgeschlagen über Bedarfsermittlung / Meldebestände etc. Ohne Losrundung und Preissuche, als nur Fehlbedarf.
   bvp_menge                 numeric(14,6) NOT null,                                                -- Wie bvp_bedarfsmenge_uf1, aber nach Preissuche. Daher ggf. mit ME-Wechsel  und Losrundung
   bvp_menge_uf1             numeric(20,8) NOT null,                                                -- Wie bvp_menge, aber in Grundmengeneinheit
   bvp_me_mgcode             integer NOT null REFERENCES mgcode ON UPDATE CASCADE,                  -- mgcode (Artikel frei oder in Stammdaten)
   bvp_mcv                   integer REFERENCES artmgc ON UPDATE CASCADE,                           -- Benutzte Mengeneinheit (Artikel in Stammdaten)
   bvp_preis                 numeric(12,4) NOT null DEFAULT 0,                                      -- Preis unter Berücksichtung der Preiseinheit, Bsp: 4,99 pro 100 Stk.
   bvp_preiseinheit          numeric(12,4) NOT null DEFAULT 1 CONSTRAINT bestvorschlagpos__chk__preiseinheit CHECK ( bvp_preiseinheit > 0),                                      -- Menge, auf die sich die Preisangabe bezieht, Bsp: 100 Stk.
   bvp_eklos                 numeric(12,4),                                                         -- Losgröße für die Bestellung. Kein Default, sonst haben wir auch für Meterware etc. automatisch immer eine 1 oder sowas da stehen.
   bvp_ep                    numeric(12,4) NOT null,                                                -- Preis pro Mengeneinheit. Bsp: 0,0499
   bvp_rab                   numeric(5,2) NOT null DEFAULT 0,                                       -- Rabatt auf Preis laut Lieferantendaten
   bvp_ep_uf1                numeric(20,8),                                                               -- Einkaufspreis pro Grundmengeneinheit
   bvp_ep_uf1_basis_w        numeric(20,8),                                                               -- Einkaufspreis pro Grundmengeneinheit in Basiswaehrung
   bvp_ep_uf1_basis_w_abzu   numeric(20,8),                                                               -- Einkaufspreis pro Grundmengeneinheit in Basiswaehrung mit Ab/Zuschlägen
   bvp_waer                  varchar(3) NOT null REFERENCES bewa DEFAULT TSystem.Settings__Get('BASIS_W'),     -- Bestellwaehrung
   bvp_ldsduftg_dolink       boolean NOT null DEFAULT false,                                        -- verlinkung Bestellung mit Bedarfsverursachern
   bvp_einkauf_p_id          integer REFERENCES ldsdok ON UPDATE CASCADE ON DELETE SET null,        -- Resultierende Bestellposition
   bvp_aArt_id               integer, --REFERENCSES anfArt FOREIGN KEY (bvp_aArt_id)                -- Zugehörige Anfrage Position > foreign key siehe x table constraints
   bvp_bvp_id_replacedby     integer REFERENCES bestvorschlagpos ON DELETE SET null,                -- diese Position wurde in einem später erstellten BV übernommen und somit ersetzt
   bvp_closed                boolean NOT null DEFAULT false,                                        -- Position wurde bearbeitet oder in neuen BV übernommen. #16037, #16038
   bvp_status                varchar(300),
   bvp_ks                    varchar(100),  -- kein Ref, da Aggregiert evtl. REFERENCES ksv ON UPDATE CASCADE ON DELETE SET null,
   bvp_konto                 varchar(100),  -- kein Ref, da Aggregiert evtl. REFERENCES erloes ON UPDATE CASCADE ON DELETE SET null,
   bvp_txt                   text,                                                                  -- Positionszusatztext. Vorgefüllt aus Artikelbestelltext ... weitergegeben an Anfrage oder Bestellung.
   bvp_txt_rtf               text,
   bvp_txtint                text,                                                                  -- Positionszusatztext intern, kann auch aus BANF kommen
   bvp_txtint_rtf            text,
   bvp_txt_lag               text,                                                                  -- Positionszusatztext intern für Einlagerung, kann aus BANF kommen
   bvp_txt_lag_rtf           text,
   bvp_txtint_orga           text,                                                                  -- Hinweistext für Organisatorisches zur Position. Wir bei neu erstellen BV beibehalten!
   bvp_txtint_orga_rtf       text,
   bvp_db_usename            varchar(50),                                                           -- Zuständigen Einkäufer. Länger als normal, da string_agg bei Sammeln von Bedarfen zB über BANF
   bvp_preis_status_enum     text,                                                                  -- Hinweise zum Preis, zB Menge im Rahmen nicht ausreichend. #12958 und Oberticket #12911
   bvp_preis_table           varchar(40),
   bvp_preis_dbrid           varchar(32)
  );

 CREATE INDEX bestvorschlagpos_bvp_bvsnr ON bestvorschlagpos(bvp_bvsnr);
 CREATE INDEX bestvorschlagpos_bvp_einkauf_p_id ON bestvorschlagpos(bvp_einkauf_p_id) WHERE bvp_einkauf_p_id IS NOT null;
 CREATE INDEX bestvorschlagpos_bvp_aknr ON bestvorschlagpos(bvp_aknr);
 CREATE INDEX bestvorschlagpos_bvp_id_replacedby ON bestvorschlagpos(bvp_bvp_id_replacedby) WHERE bvp_bvp_id_replacedby IS NOT null;
 --

 -- Preiseinheiten
 CREATE OR REPLACE FUNCTION BestVorschlagPos__b_05_iu__Preiseinheit() RETURNS TRIGGER AS $$
   BEGIN
     new.bvp_preiseinheit := coalesce(new.bvp_preiseinheit,1);
     new.bvp_ep := new.bvp_preis / Do1If0(new.bvp_preiseinheit);
     --
     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER BestVorschlagPos__b_05_iu__Preiseinheit
     BEFORE INSERT OR UPDATE
     OF bvp_preiseinheit
     ON BestVorschlagPos
     FOR EACH ROW
     EXECUTE PROCEDURE BestVorschlagPos__b_05_iu__Preiseinheit();
 -- Mengeineinheit (freie Artikel)
 -- Zuerst MCV => ARTMGC-ID ist führend.
 CREATE OR REPLACE FUNCTION bestvorschlagpos__b_10_iu__mcv() RETURNS TRIGGER AS $$
  BEGIN
   -- keine ME? => Standard
   IF new.bvp_mcv IS NULL THEN
      -- Standard-ME aus Artikel, oder 1=Stück bei freiem Artikel
      new.bvp_mcv := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(new.bvp_aknr);
    END IF;
   --
   IF new.bvp_mcv IS NOT NULL THEN
        new.bvp_me_mgcode := tartikel.me__mec__by__mid( new.bvp_mcv );
    END IF;
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER bestvorschlagpos__b_10_iu__mcv
   BEFORE INSERT OR UPDATE
   OF bvp_mcv
   ON BestVorschlagPos
   FOR EACH ROW
   EXECUTE PROCEDURE bestvorschlagpos__b_10_iu__mcv();
 -- Wenn MGCODE direkt angesprochen wird, dann übernehmen wir mcv anhand mgc.
 -- Wenn beides angesprochen wurde, hat Trigger bestvorschlagpos__b_10_iu__mcv bvp_me_mgcode hier bereits gesetzt
 CREATE OR REPLACE FUNCTION bestvorschlagpos__b_12_iu__me_mgcode() RETURNS TRIGGER AS $$
  BEGIN
   new.bvp_mcv := tartikel.me__art__artmgc__m_id__by__mgc(new.bvp_aknr, new.bvp_me_mgcode);
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER bestvorschlagpos__b_12_iu__me_mgcode
   BEFORE INSERT OR UPDATE
   OF bvp_me_mgcode
   ON BestVorschlagPos
   FOR EACH ROW
   EXECUTE PROCEDURE bestvorschlagpos__b_12_iu__me_mgcode();
 -- Mengen
 CREATE OR REPLACE FUNCTION bestvorschlagpos__b_20_iu__menge__gme() RETURNS TRIGGER AS $$
   BEGIN
    IF new.bvp_mcv IS NULL THEN
        new.bvp_menge_uf1 := new.bvp_menge; --freie Eingabe einer freien Artikelnummer
     ELSE
        new.bvp_menge_uf1 := tartikel.me__menge__in__menge_uf1(new.bvp_mcv, new.bvp_menge);
     END IF;
    RETURN new;
   END $$ LANGUAGE plpgsql;
   --
   CREATE TRIGGER bestvorschlagpos__b_20_iu__menge__gme
    BEFORE INSERT OR UPDATE
    OF bvp_menge, bvp_mcv
    ON BestVorschlagPos
    FOR EACH ROW
    EXECUTE PROCEDURE bestvorschlagpos__b_20_iu__menge__gme();

 -- #13275 Bei Änderung der Menge, ändern sich die Ab/Zuschläge (vor allem die pro Vorgang -> nachrechnen)
 -- #14656 keine erneute Preissuche ausführen, sondern nur auf Basis der am BVP hinterlegten
 --        Preistabelle und Preis-Dbrid bvp_ep_uf1_basis_w_abzu ermitteln.
CREATE OR REPLACE FUNCTION BestVorschlagPos__b_22_u__preis_uf1_basisw_abzu() RETURNS TRIGGER AS $$
  DECLARE
      _preis     TWawi.Preis;
  BEGIN

      -- Hinterlegten Preis anhand neuer Menge abfragen (keine erneute Preissuche).
      _preis :=
          twawi.create_preis(
              new.bvp_preis_table,
              new.bvp_preis_dbrid,
              new.bvp_menge_uf1,
              -- Ohne Berücksichtigung der Losrundung, da neue Menge von Anwender angegeben.
              false
          )
      ;

      new.bvp_ep_uf1_basis_w_abzu := coalesce( _preis.preis_uf1_basisw_abzu, new.bvp_ep_uf1_basis_w_abzu );


      RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER BestVorschlagPos__b_22_u__preis_uf1_basisw_abzu
     BEFORE UPDATE
     OF bvp_menge,
        -- unklar: Ändern des Preis selbst?!
        -- Zuweisen anderer Lieferant bei gleicher Menge = ggf neuer Preis!
        bvp_preis_table, bvp_preis_dbrid
     ON BestVorschlagPos
     FOR EACH ROW
     EXECUTE PROCEDURE BestVorschlagPos__b_22_u__preis_uf1_basisw_abzu();



 -- ldsauftg an bestvorschlagpos

 -- Aufträge und BANF mit BestVorschlagPos und Bestellung verlinken
 CREATE OR REPLACE FUNCTION BestVorschlagPos__a_iu__ldsauftg_links() RETURNS TRIGGER AS $$
   DECLARE _ldid integer;
           _laid integer;
   BEGIN
     -- WHEN (new.bvp_auftg_bedarf_list IS NOT null)

     IF TG_OP = 'INSERT' THEN
         -- Initiale Verknüpfung von Bestellvorschlagsposition mit bedürftigen Aufträgen und BANFen
         -- Spalte new.bvp_bedarf_list hält Liste in Form eines Arrays
         -- Spalte in Einträge in ldsauftg überführen
         INSERT INTO ldsauftg(
                        la_bvp_id,
                        la_ag_id,
                        la_bap_id,
                        la_stk_uf1,
                        la_me_mgcode,
                        la_mce)
                       SELECT -- Auspacken Array "new.bvp_bedarf_list"
                         new.bvp_id,
                         agid,
                         bapid,
                         qty,
                         new.bvp_me_mgcode,
                         new.bvp_mcv -- Menge in GME, Menge in ME per Trigger ldsauftg__b_10_iu__uf1 (nicht erst in ME und dann wieder in GME)
                        FROM ( -- FROM new.bvp_bedarf_list => Spalte, welche Array von Verusachern hält
                            SELECT
                              CASE WHEN type_index = 1 THEN id END AS agid,  -- Typ 1: Auftrag-ID
                              CASE WHEN type_index = 2 THEN id END AS bapid, -- Typ 2: BANF-Pos-ID
                              qty
                            FROM unnest(new.bvp_bedarf_list)
                            ) AS sub
                        WHERE (
                             EXISTS(SELECT true FROM auftg WHERE ag_id = agid) -- Auftrag existiert auch
                             OR
                             EXISTS(SELECT true FROM bestanfpos WHERE bap_id = bapid) -- BANF-Pos existiert auch
                           )
                           AND NOT EXISTS(SELECT true FROM ldsauftg WHERE la_bvp_id = new.bvp_id AND (la_ag_id = agid OR la_bap_id = bapid)) -- Verlinkung eindeutig halten (la_ag_id und la_bap_id sind nie gleichzeitig gefüllt)
                        ORDER BY agid, bapid;
         --
     ELSIF new.bvp_ldsduftg_dolink THEN -- UPDATE und Option Bestellungen mit Aufträgen verknüpfen (Bestellvorschlag)
         -- Aufträge mit Bestellung verknüpfen
         _ldid := new.bvp_einkauf_p_id;
         ---
         IF _ldid IS null THEN
             RETURN new;
         END IF;
         --
         FOR _laid IN ( -- ordered UPDATE. Sortiertes Update, damit erster Eintrag (Auftrag bzw. BANF) mit Bestellung direkt verlinkt wird.
             SELECT la_id
               FROM ldsauftg
               LEFT JOIN auftg ON ag_id = la_ag_id
               LEFT JOIN bestanfpos ON bap_id = la_bap_id
              WHERE la_bvp_id = new.bvp_id
                AND la_ld_id IS null
              ORDER BY ag_astat, ag_nr, ag_pos, bap_banr, bap_pos, la_id)
         LOOP
             UPDATE ldsauftg
                SET la_ld_id = _ldid -- ID der Bestellung eintragen. Erzeugung der Verlinkung in Bestellung siehe ldsauftg__a_20_iud__ldsdok_banf_links.
              WHERE la_id = _laid; -- back
         END LOOP;
         --
     END IF;
     --
     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER BestVorschlagPos__a_iu__ldsauftg_links
     AFTER INSERT OR UPDATE
     --- #13244
     --- OF bvp_bestcode, bvp_bestellnr, bvp_bestellpos -- Bestellung wird aus Bestellvorschlagsposition erzeugt.
     OF bvp_einkauf_p_id -- Bestellung wird aus Bestellvorschlagsposition erzeugt.
     ON BestVorschlagPos
     FOR EACH ROW
     WHEN (new.bvp_bedarf_list IS NOT null) -- Es gibt Bedarfsbezüge. Bei zukünftigem Editieren der Auftragsbezüge in den Bestellvorschlägen ist diese Bedingung zu überprüfen (insb. komplettes Entfernen der Bezüge).
     EXECUTE PROCEDURE BestVorschlagPos__a_iu__ldsauftg_links();
 --
 -- Bei Änderung von ME und/oder Menge auch Mengen der Bedarfsverursacher-Liste neu berechnen.
 CREATE OR REPLACE FUNCTION BestVorschlagPos__a_u__ldsauftg_uf1() RETURNS TRIGGER AS $$
   BEGIN
     IF new.bvp_menge <> old.bvp_menge THEN
         -- ME + Menge in Bestellvorschlag wird geändert (Option xtt6101: Preis / Mengen nach neuen Umrechnungsfaktor umrechnen? - Ja).
         UPDATE ldsauftg SET
           la_stk = NULL, -- Menge in ME zurücksetzen. Wird neu berechnet per ldsauftg__b_10_iu__uf1.
           la_mce = new.bvp_mcv
         WHERE la_bvp_id = new.bvp_id
           AND la_ld_id IS NULL -- Noch kein Bestellung verknüpft (denn dann ist diese führend).
           AND la_mce <> new.bvp_mcv;
     ELSE
        --Nur ME in Bestellvorschlag wird geändert (Option xtt6101: Preis / Mengen nach neuen Umrechnungsfaktor umrechnen? - Nein).
         UPDATE ldsauftg SET
           la_mce = new.bvp_mcv -- Menge in ME bleibt erhalten. Mengen in GME wird neu berechnet per ldsauftg__b_10_iu__uf1.
         WHERE la_bvp_id = new.bvp_id
           AND la_ld_id IS NULL -- Noch kein Bestellung verknüpft (denn dann ist diese führend).
           AND la_mce <> new.bvp_mcv;
     END IF;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER BestVorschlagPos__a_u__ldsauftg_uf1
     AFTER UPDATE
     OF bvp_me_mgcode, bvp_mcv
     ON BestVorschlagPos
     FOR EACH ROW
     EXECUTE PROCEDURE BestVorschlagPos__a_u__ldsauftg_uf1();
 --

CREATE OR REPLACE FUNCTION bestvorschlagpos__b_90_iu__closed__execute() RETURNS TRIGGER AS $$
    BEGIN
      -- Beachte OF
      new.bvp_closed := (   -- Eingekauft ist immer erledigt
                            (new.bvp_einkauf_p_id IS NOT NULL)
                            -- Angefrage und Typ "Nur Anfrage" ist auch erledigt
                         OR (new.bvp_aArt_id IS NOT NULL AND new.bvp_typindex IN (55,56,57))
                            -- übernommen in einen neuen BV
                         OR (new.bvp_bvp_id_replacedby IS NOT NULL)
                        );

      RETURN new;
    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER bestvorschlagpos__b_90_iu__closed__execute
    BEFORE INSERT OR UPDATE
    OF bvp_einkauf_p_id, bvp_aArt_id, bvp_bvp_id_replacedby
    ON bestvorschlagpos
    FOR EACH ROW
    EXECUTE PROCEDURE bestvorschlagpos__b_90_iu__closed__execute();


CREATE OR REPLACE FUNCTION bestvorschlagpos__a_90_i__bvp_id_replacedby__set() RETURNS TRIGGER AS $$
    BEGIN
        -- in vorherigen BV aktuelle id eintragen. Trigger schliesst damit den vorherigen BV
        UPDATE bestvorschlagpos AS bvpos_to_close
           SET bvp_bvp_id_replacedby = new.bvp_id
          FROM bestvorschlag    AS bvkopf_to_close,
               bestvorschlag    AS bvkopf_mine
         WHERE bvpos_to_close.bvp_bvsnr   <> new.bvp_bvsnr
           AND bvpos_to_close.bvp_aknr     = new.bvp_aknr
           AND coalesce(bvpos_to_close.bvp_ak_bez, '') = coalesce(new.bvp_ak_bez, '')
           AND bvpos_to_close.bvp_typindex = new.bvp_typindex
               -- Kennung des BV muss zusammenpassen. 1 ist unabhängig und matched nie
           AND bvkopf_to_close.bvs_bvsk_id  = nullif(bvkopf_mine.bvs_bvsk_id, 1)
           AND NOT bvpos_to_close.bvp_closed
               -- JOIN auf Kopdaten von uns selbst (also der Datensatz, der angelegt wird)
           AND bvkopf_mine.bvs_nr = new.bvp_bvsnr
               -- JOIN auf Kopdaten des Datensatzes, welcher übernommen wird in uns
           AND bvkopf_to_close.bvs_nr = bvpos_to_close.bvp_bvsnr
        ;

        RETURN new;
    END $$ LANGUAGE plpgsql;


    CREATE TRIGGER bestvorschlagpos__a_90_i__bvp_id_replacedby__set
        AFTER INSERT
        ON bestvorschlagpos
        FOR EACH ROW
        EXECUTE PROCEDURE bestvorschlagpos__a_90_i__bvp_id_replacedby__set();
 --